/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.lucenewrapper;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.common.FullTextIndexType;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.common.IndexField;
import org.gcube.indexmanagement.common.IndexGenerator;
import org.gcube.indexmanagement.common.XMLProfileParser;
import org.gcube.indexmanagement.lucenewrapper.GlobalSimilarity;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class LuceneGenerator
implements IndexGenerator {
    static GCUBELog logger = new GCUBELog(LuceneGenerator.class);
    private final String baseIndexDir;
    private final String deletionDir;
    private IndexWriter writer = null;
    private IndexWriter ramWriter = null;
    private IndexReader reader = null;
    private IndexReader ramReader = null;
    private RAMDirectory ramDir = null;
    private String indexDir = null;
    private FullTextIndexType idxType = null;
    private Analyzer NoStopAnalyser = new StandardAnalyzer(new String[0]);

    public LuceneGenerator(String baseIndexDir, String deletionDir) {
        this.baseIndexDir = baseIndexDir;
        this.deletionDir = deletionDir;
        File ddFile = new File(deletionDir);
        if (!ddFile.exists()) {
            ddFile.mkdirs();
        }
    }

    @Override
    public synchronized void createIndex(String indexName, FullTextIndexType idxType, boolean forceCreate) throws IndexException {
        try {
            logger.info((Object)("creating index: " + indexName));
            this.writer = this.createLuceneIndexWriter(this.baseIndexDir + indexName, forceCreate);
            this.writer.close();
            this.indexDir = indexName;
            this.idxType = idxType;
        }
        catch (Exception e) {
            throw new IndexException(e);
        }
    }

    private IndexWriter createLuceneIndexWriter(String dir, boolean forceCreate) throws IOException {
        GlobalSimilarity similarity = new GlobalSimilarity();
        IndexWriter indexWriter = new IndexWriter(dir, this.NoStopAnalyser, forceCreate);
        indexWriter.setSimilarity((Similarity)similarity);
        return indexWriter;
    }

    private IndexWriter createLuceneIndexWriter(Directory dir, boolean forceCreate) throws IOException {
        GlobalSimilarity similarity = new GlobalSimilarity();
        IndexWriter indexWriter = new IndexWriter(dir, this.NoStopAnalyser, forceCreate);
        indexWriter.setSimilarity((Similarity)similarity);
        return indexWriter;
    }

    @Override
    public synchronized void openIndex(String indexName) throws IndexException {
        try {
            this.ramDir = new RAMDirectory();
            this.ramWriter = this.createLuceneIndexWriter((Directory)this.ramDir, true);
            this.indexDir = indexName;
            logger.info((Object)("opening index: " + this.indexDir));
        }
        catch (IOException e) {
            throw new IndexException(e);
        }
    }

    @Override
    public synchronized void setIndexType(FullTextIndexType idxType) throws IndexException {
        this.idxType = idxType;
    }

    @Override
    public synchronized long getIndexFileSize() throws IndexException {
        String directoryPath = this.baseIndexDir + this.indexDir;
        return this.getFileSize(new File(directoryPath));
    }

    private synchronized long getFileSize(File file) throws IndexException {
        if (file.canRead()) {
            if (file.isDirectory()) {
                long size = 0L;
                String[] files = file.list();
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        size += this.getFileSize(new File(file, files[i]));
                    }
                }
                return size;
            }
            return file.length();
        }
        throw new IndexException("Unable to get the size of the Index");
    }

    @Override
    public synchronized void abort() throws IndexException {
        try {
            if (this.ramWriter != null) {
                this.ramWriter.close();
            }
            this.ramDir = new RAMDirectory();
            this.ramWriter = this.createLuceneIndexWriter((Directory)this.ramDir, true);
        }
        catch (IOException e) {
            throw new IndexException(e);
        }
    }

    @Override
    public synchronized void commit() throws IndexException {
        try {
            this.ramWriter.close();
            Directory[] mergeDirs = new Directory[]{this.ramDir};
            this.writer = this.createLuceneIndexWriter(this.baseIndexDir + this.indexDir, false);
            this.writer.addIndexes(mergeDirs);
            this.writer.close();
            this.ramDir = new RAMDirectory();
            this.ramWriter = this.createLuceneIndexWriter((Directory)this.ramDir, true);
        }
        catch (Exception e) {
            throw new IndexException(e);
        }
    }

    @Override
    public synchronized long getCommittedFileSize() throws IndexException {
        try {
            long size = 0L;
            Directory tempDir = this.writer.getDirectory();
            String[] files = tempDir.list();
            if (files != null) {
                for (String fileName : files) {
                    size += tempDir.fileLength(fileName);
                }
            }
            return size;
        }
        catch (Exception e) {
            throw new IndexException(e);
        }
    }

    @Override
    public synchronized long getUnCommittedFileSize() throws IndexException {
        try {
            return this.ramDir.sizeInBytes();
        }
        catch (Exception e) {
            throw new IndexException(e);
        }
    }

    private synchronized File createDeletionFile() throws IndexException {
        try {
            File deletionFile;
            int deletionCount = 0;
            do {
                deletionFile = new File(this.deletionDir + "deletion" + deletionCount + ".xml");
                ++deletionCount;
            } while (deletionFile.exists());
            deletionFile.createNewFile();
            FileWriter writer = new FileWriter(deletionFile);
            writer.write("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?><IDList/>");
            writer.close();
            return deletionFile;
        }
        catch (Exception e) {
            throw new IndexException(e);
        }
    }

    @Override
    public synchronized int mergeIndex(File inputIndex) throws IndexException {
        try {
            IndexWriter mergeWriter = this.createLuceneIndexWriter(this.baseIndexDir + this.indexDir, false);
            int docCount = mergeWriter.docCount();
            FSDirectory inputDirectory = FSDirectory.getDirectory((String)inputIndex.getAbsolutePath(), (boolean)false);
            Directory[] mergeDirs = new Directory[]{inputDirectory};
            mergeWriter.addIndexes(mergeDirs);
            int change = mergeWriter.docCount() - docCount;
            mergeWriter.close();
            return change;
        }
        catch (Exception e) {
            logger.error((Object)"Error while merging index.", (Throwable)e);
            throw new IndexException(e);
        }
    }

    @Override
    public synchronized int mergeDeletionFile(File deletionFile) throws IndexException {
        try {
            IdDeletionHandler deletionHandler = new IdDeletionHandler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(deletionHandler);
            xmlReader.parse(new InputSource(deletionFile.toURI().toURL().toString()));
            return deletionHandler.getDeletionCount();
        }
        catch (Exception e) {
            throw new IndexException(e);
        }
    }

    @Override
    public synchronized void closeIndex() throws IndexException {
        try {
            if (this.ramWriter != null) {
                this.ramWriter.close();
                Directory[] mergeDirs = new Directory[]{this.ramDir};
                this.writer = this.createLuceneIndexWriter(this.baseIndexDir + this.indexDir, false);
                this.writer.addIndexes(mergeDirs);
                this.writer.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"Failed to merge active RamWriter with the persistent index.", (Throwable)e);
            throw new IndexException(e);
        }
    }

    @Override
    public void close() {
        this.ramWriter = null;
        this.writer = null;
    }

    @Override
    public synchronized void deleteIndex() throws IndexException {
        this.closeIndex();
        File dataDir = new File(this.baseIndexDir + this.indexDir);
        logger.info((Object)("Going to delete all files in: " + dataDir.getAbsolutePath()));
        if (dataDir.exists()) {
            for (File f : dataDir.listFiles()) {
                f.delete();
                logger.info((Object)("Deleted file: " + f.getAbsolutePath()));
            }
            dataDir.delete();
            logger.info((Object)("Deleted directory: " + dataDir.getAbsolutePath()));
        }
    }

    @Override
    public File deleteDocuments(String[] documentIDs) throws IndexException {
        File deletionFile = this.createDeletionFile();
        this.deleteDocuments(documentIDs, true, deletionFile);
        return deletionFile;
    }

    @Override
    public int deleteDocumentsLocally(String[] documentIDs) throws IndexException {
        return this.deleteDocuments(documentIDs, false, null);
    }

    private int deleteDocuments(String[] documentIDs, boolean deleteFromMainIndex, File deletionFile) throws IndexException {
        try {
            this.reader = IndexReader.open((String)(this.baseIndexDir + this.indexDir));
            this.ramReader = IndexReader.open((Directory)this.ramDir);
            HashSet<String> deletionSet = new HashSet<String>();
            int deletedDocs = 0;
            for (String documentID : documentIDs) {
                Term idTerm = new Term("objectid", documentID);
                if (this.reader != null) {
                    deletedDocs += this.reader.deleteDocuments(idTerm);
                }
                if (this.ramReader != null) {
                    deletedDocs += this.ramReader.deleteDocuments(idTerm);
                }
                if (!deleteFromMainIndex) continue;
                deletionSet.add(documentID);
            }
            if (deleteFromMainIndex) {
                this.addToDeletionFile(deletionFile, deletionSet);
            }
            return deletedDocs;
        }
        catch (Exception e) {
            throw new IndexException();
        }
    }

    private void addToDeletionFile(File delFile, Set<String> deletionSet) throws Exception {
        long i;
        if (deletionSet.size() == 0) {
            return;
        }
        RandomAccessFile deletionFile = new RandomAccessFile(delFile, "rw");
        for (i = deletionFile.length() - 1L; i >= 0L; --i) {
            deletionFile.seek(i);
            String line = deletionFile.readLine();
            logger.info((Object)line);
            if (line != null && line.equals("<IDList/>")) {
                deletionFile.seek(i);
                deletionFile.writeBytes("<IDList>");
                break;
            }
            if (line == null || !line.equals("</IDList>")) continue;
            deletionFile.seek(i);
            break;
        }
        if (i == -1L) {
            deletionFile.seek(0L);
            deletionFile.writeBytes("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?><IDList>");
        }
        for (String id : deletionSet) {
            deletionFile.writeBytes("<id>" + id + "</id>");
        }
        deletionFile.writeBytes("</IDList>");
        deletionFile.close();
    }

    @Override
    public int insertRowSet(String rowsetXML) throws IndexException {
        try {
            XMLProfileParser XMLparser = new XMLProfileParser();
            XMLparser.readString(rowsetXML, null);
            XMLparser.setRootNode("ROWSET");
            int docCount = 0;
            while (XMLparser.setNextField()) {
                ++docCount;
                String[][] fieldData = XMLparser.getSubFields();
                if (fieldData == null) continue;
                Document doc = new Document();
                String docContents = "";
                for (int i = 0; i < this.idxType.getNumberOfFields(); ++i) {
                    IndexField idxTypeField = this.idxType.getFields()[i];
                    Field.Store store = idxTypeField.store ? Field.Store.YES : Field.Store.NO;
                    Field.Index index = idxTypeField.index ? (idxTypeField.tokenize ? Field.Index.TOKENIZED : Field.Index.UN_TOKENIZED) : Field.Index.NO;
                    String fieldContentSum = "";
                    for (int ii = 0; ii < fieldData[0].length; ++ii) {
                        String baseName = fieldData[0][ii];
                        String fieldContents = fieldData[1][ii];
                        if (idxTypeField.name.equals(baseName) && fieldContents != null) {
                            if (!baseName.equals("fullpayload")) {
                                docContents = docContents + " " + fieldContents;
                            }
                            fieldContentSum = fieldContentSum + " " + fieldContents;
                            continue;
                        }
                        if (!this.isDescendant(baseName, idxTypeField) || fieldContents == null) continue;
                        fieldContentSum = fieldContentSum + " " + fieldContents;
                    }
                    if (fieldContentSum.equals("")) continue;
                    doc.add((Fieldable)new Field(idxTypeField.name, fieldContentSum, store, index));
                    logger.debug((Object)("added field in document: " + idxTypeField.name + ", " + fieldContentSum));
                }
                Field contents = new Field("_contents", docContents, Field.Store.YES, Field.Index.TOKENIZED);
                doc.add((Fieldable)contents);
                logger.debug((Object)("added field in document: _contents, " + docContents));
                TokenStream tokens = this.NoStopAnalyser.tokenStream("_contents", (Reader)new StringReader(docContents));
                int wordCount = 0;
                while (tokens.next() != null) {
                    ++wordCount;
                }
                doc.add((Fieldable)new Field("_wordcount", "" + wordCount, Field.Store.YES, Field.Index.NO));
                logger.debug((Object)("added field in document: _wordcount, " + wordCount));
                for (int ii = 0; ii < fieldData[0].length; ++ii) {
                    if (!fieldData[0][ii].equalsIgnoreCase("ObjectID") || fieldData[1][ii] == null) continue;
                    Field.Store store = Field.Store.YES;
                    Field.Index index = Field.Index.TOKENIZED;
                    String data = fieldData[1][ii];
                    doc.add((Fieldable)new Field(fieldData[0][ii].toLowerCase(), data, store, index));
                    logger.debug((Object)("added field in document: " + fieldData[0][ii] + ", " + data));
                }
                if (this.ramWriter != null) {
                    this.ramWriter.addDocument(doc);
                    this.ramWriter.flush();
                    continue;
                }
                throw new IndexException("Index not open for insertion");
            }
            return docCount;
        }
        catch (Exception e) {
            logger.error((Object)"Error while inserting rowset.", (Throwable)e);
            throw new IndexException(e);
        }
    }

    private boolean isDescendant(String descendantFieldName, IndexField parentField) {
        for (IndexField childField : parentField.childrenFields) {
            if (childField.name.equalsIgnoreCase(descendantFieldName)) {
                return true;
            }
            if (!this.isDescendant(descendantFieldName, childField)) continue;
            return true;
        }
        return false;
    }

    private class IdDeletionHandler
    extends DefaultHandler {
        boolean isID;
        int count = 0;

        public IdDeletionHandler() throws Exception {
            LuceneGenerator.this.reader = IndexReader.open((String)(LuceneGenerator.this.baseIndexDir + LuceneGenerator.this.indexDir));
        }

        @Override
        public void startElement(String ns, String sname, String qName, Attributes atts) {
            this.isID = qName != null && qName.trim().equalsIgnoreCase("id");
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.isID) {
                String id = new String(ch, start, length);
                if (!(id = id.trim()).equals("")) {
                    try {
                        Term idTerm = new Term("objectid", id.trim());
                        LuceneGenerator.this.reader.deleteDocuments(idTerm);
                        ++this.count;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }

        public int getDeletionCount() {
            return this.count;
        }
    }
}

