/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.common;

import java.util.Vector;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.common.IndexField;
import org.gcube.indexmanagement.common.IndexType;
import org.gcube.indexmanagement.common.XMLProfileParser;

public class FullTextIndexType
extends IndexType {
    static GCUBELog logger = new GCUBELog(FullTextIndexType.class);
    private int noOfFields;
    private IndexField[] fields;
    private XMLProfileParser parser = null;

    public FullTextIndexType(String indexTypeName, GCUBEScope scope) {
        super(indexTypeName);
        try {
            String indexType = this.retrieveIndexTypeGenericResource(scope);
            if (this.parser == null) {
                this.parser = new XMLProfileParser();
            }
            this.parser.readString(indexType, null);
            this.readIndexType();
        }
        catch (Exception ex) {
            logger.error((Object)"Error initializing FullTextIndexType.", (Throwable)ex);
        }
    }

    public int getNumberOfFields() {
        return this.noOfFields;
    }

    public IndexField[] getFields() {
        return this.fields;
    }

    private void readIndexType() throws Exception {
        int position = 0;
        try {
            this.parser.setRootNode("field-list");
            this.noOfFields = this.parser.countDescendants("field");
            this.fields = new IndexField[this.noOfFields];
            Vector<IndexField> parents = new Vector<IndexField>();
            while (true) {
                if (this.parser.goChildElement("field")) {
                    this.fillField(position);
                    if (position != 0) {
                        parents.add(this.fields[position - 1]);
                        ((IndexField)parents.get(parents.size() - 1)).addChildField(this.fields[position]);
                    }
                    ++position;
                    continue;
                }
                if (this.parser.goSiblingElement("field")) {
                    this.fillField(position);
                    if (!parents.isEmpty()) {
                        ((IndexField)parents.get(parents.size() - 1)).addChildField(this.fields[position]);
                    }
                    ++position;
                    continue;
                }
                boolean foundAnotherNode = false;
                while (this.parser.goParentElement("field")) {
                    parents.removeElementAt(parents.size() - 1);
                    if (!this.parser.goSiblingElement("field")) continue;
                    this.fillField(position);
                    if (!parents.isEmpty()) {
                        ((IndexField)parents.get(parents.size() - 1)).addChildField(this.fields[position]);
                    }
                    ++position;
                    foundAnotherNode = true;
                    break;
                }
                if (!foundAnotherNode) break;
            }
            return;
        }
        catch (Exception ex) {
            logger.error((Object)("Error while reading indexType, position: " + position), (Throwable)ex);
            throw ex;
        }
    }

    private void fillField(int position) throws Exception {
        this.fields[position] = new IndexField();
        this.fields[position].name = this.parser.getFieldByValue("name");
        this.fields[position].index = !this.parser.getFieldByValue("index").equalsIgnoreCase("no");
        this.fields[position].tokenize = !this.parser.getFieldByValue("tokenize").equalsIgnoreCase("no");
        this.fields[position].store = !this.parser.getFieldByValue("store").equalsIgnoreCase("no");
        this.fields[position].returned = !this.parser.getFieldByValue("return").equalsIgnoreCase("no");
        this.fields[position].sort = !this.parser.getFieldByValue("sort").equalsIgnoreCase("no");
        this.fields[position].boost = new Float(this.parser.getFieldByValue("boost")).floatValue();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("\nID=" + this.indexTypeID + "\n\nFields:\n");
        for (int i = 0; i < this.noOfFields; ++i) {
            ret.append(this.fields[i] + "\n");
        }
        return ret.toString();
    }
}

