/*
 * LemmatizerPlugin.java
 *
 * $Author: tsakas $
 * $Date: 2007/12/20 14:37:39 $
 * $Id: LemmatizerPlugin.java,v 1.1 2007/12/20 14:37:39 tsakas Exp $
 *
 * <pre>
 *             Copyright (c) : 2006 Fast Search & Transfer ASA
 *                             ALL RIGHTS RESERVED
 * </pre>
 */

package org.gcube.indexmanagement.common.linguistics.lemmatizerplugin;

import org.gcube.indexmanagement.common.IndexException;

import java.util.Vector;

/**
 * The interface that all lemmatizer plugins implement.
 *
 */
public interface LemmatizerPlugin {

    /**
     * Method to initialise this plugin, the configuration file is optional.
     * @param configFile         The config file
     * @param languages          The vector of languages that shall be supported
     * @throws IndexException    In case of failure
     */
    public void init(String configFile,Vector<Language> languages)
        throws IndexException;

    /**
     * Method to lemmatize a word
     * @param wordToLemmatize      The word to lemmatize.
     * @param language             The language to use when getting
     *                             the lemmatized forms.
     * @return                     The string with the lemmatized forms
     *                             of the word.
     *                             Each form is separated by !
     *                             The string may look like : house!houses
     * @throws IndexException      In case of failure
     */
    public String lemmatize_word(String wordToLemmatize,
                                 Language language) throws IndexException;

    /**
     * Method to lemmatize a word
     * @param stringToLemmatize    The string to lemmatize. The string can
     *                             be a single word,
     *                             or several words
     *                             separated by spaces.
     * @param language             The language to use when getting the lemmatized forms.
     * @return                     The string with the lemmatized forms of the word.
     *                             Each form for the same word
     *                             is separated by !, and the # is used as a separater between words
     *                             The string may look like : house!houses#knee!knees#
     * @throws IndexException      In case of failure
     */
    public String lemmatize_string(String stringToLemmatize,
                                   Language language)
        throws IndexException;

    /**
     * Method to initialise this plugin, the configuration file is optional,
     * but most language detection tools need some sort
     * of statistics, references and so on.
     * @param  language            The language to add to the lemmatizer
     * @throws IndexException      In case of failure
     */
    public void add_language(Language language) throws IndexException;
}
