/**
 * 
 */
package org.gcube.indexmanagement.common.notifications;

import java.util.LinkedList;
import java.util.List;

import javax.xml.namespace.QName;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.informationsystem.notifier.ISNotifier.BaseNotificationConsumer;
import org.gcube.common.core.informationsystem.notifier.ISNotifier.GCUBENotificationTopic;
import org.gcube.common.core.scope.GCUBEScope;

/**
 * @author Spyros Boutsis, NKUA
 *
 */
public class SubscribeToNotificationRequest extends NotifierRequest {

	private List<QName> topicList;
	private BaseNotificationConsumer consumer;
	
	public SubscribeToNotificationRequest(List<QName> topicList, BaseNotificationConsumer consumer, GCUBEServiceContext sctx, GCUBEScope scope) {
		super(null, sctx, scope);
		this.topicList = new LinkedList<QName>(topicList);
		this.consumer = consumer;
	}
	
	/* (non-Javadoc)
	 * @see org.gcube.indexmanagement.common.notifications.NotifierRequest#doRequest()
	 */
	@Override
	public void doRequest() {
		ISNotifier notifier = NotifierRequestQueue.getInstance().getNotifier();
		//construct the list with the topics
		List<GCUBENotificationTopic> topics = new LinkedList<GCUBENotificationTopic>();
		for(int i=0; i<topicList.size(); i++)
		{
			GCUBENotificationTopic topic = new GCUBENotificationTopic(topicList.get(i));
			//receive past notifications, sent before subscription
			topic.setUseRenotifier(true);
			topics.add(topic);
		}
		
		try {
			notifier.registerToISNotification(this.consumer, topics, this.sctx, this.scope);
		} catch (Exception e) {
			logger.warn("Exception while trying to subscribe to topics.", e);
			try {
				Thread.sleep(5000);
			} catch (InterruptedException ex) { }
		}
	}

}
