package org.gcube.indexmanagement.geo;

import java.util.ArrayList;

import org.gcube.indexmanagement.gcqlwrapper.GcqlQueryContainer;
import org.gcube.indexmanagement.geo.shape.Polygon;

public class GeoGcqlCollectionQuery{
	
	/**
	 * This is a flag that denotes if a leaf collection query
	 * must be reversed the first time it will be merged
	 */
	private boolean not;
	
	private InclusionType inclusion;
	
	private Polygon searchPolygon;
	
	private ArrayList<RefinementRequest> refineRequests = new ArrayList<RefinementRequest>();
	
	private RankingRequest rankRequest;
	
	public GeoGcqlCollectionQuery(InclusionType inclusion, Polygon searchPolygon,
			ArrayList<RefinementRequest> refineRequests, RankingRequest rankRequest, boolean not) {
		this.setInclusion(inclusion);
		this.setSearchPolygon(searchPolygon);
		this.setRefineRequests(refineRequests);
		this.setRankRequest(rankRequest);		
		this.setNot(not);
	}

	public void setInclusion(InclusionType inclusion) {
		this.inclusion = inclusion;
	}

	public InclusionType getInclusion() {
		return inclusion;
	}

	public void setSearchPolygon(Polygon searchPolygon) {
		this.searchPolygon = searchPolygon;
	}

	public Polygon getSearchPolygon() {
		return searchPolygon;
	}

	public void setRefineRequests(ArrayList<RefinementRequest> refineRequests) {
		this.refineRequests = refineRequests;
	}
	
	public void addRefineRequests(RefinementRequest refineRequest) {
		this.refineRequests.add(refineRequest);
	}

	public ArrayList<RefinementRequest> getRefineRequests() {
		return refineRequests;
	}

	public void setRankRequest(RankingRequest rankRequest) {
		this.rankRequest = rankRequest;
	}

	public RankingRequest getRankRequest() {
		return rankRequest;
	}

	public void setNot(boolean not) {
		this.not = not;
	}

	public boolean isNot() {
		return not;
	}
	
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("not: " + not);
		if(inclusion != null) {
			builder.append(" - inclusion: " + inclusion);
		}
		if(searchPolygon != null) {
			builder.append(" - Polygon: " + searchPolygon);
		}
		for(RefinementRequest req : refineRequests) {
			builder.append(" - refinerRequest: " + req.toString());
		}
		if(rankRequest != null) {
			builder.append(" - rankingRequest: " + rankRequest.toString());
		}
		
		return builder.toString();
	}
	

}
