package org.gcube.indexmanagement.common.dupelimination;

import java.util.HashMap;
import java.util.HashSet;

public class ResultsIdentifierSet {
	
	private HashMap<String, HashSet<String>> set = new HashMap<String, HashSet<String>>();
	
	/**
	 * If the element identified by language, identifier is already in the set of results, returns
	 * false. Else it adds it to the set of results and returns true. If either of the arguments 
	 * is null then it takes no action and returns true.		
	 * @param language
	 * @param identifier
	 * @return true/false
	 */
	public boolean canSend(String language, String identifier) {
		
		//if either of the arguments is null then take no action and return true
		if(language == null || identifier == null) {
			return true;
		}
		
		//first check if this element is in the set
		HashSet<String> ids = set.get(language);
		if(ids != null) {
			if(ids.contains(identifier)) {
				return false;
			}
		}
		
		//if not add it
		if(ids == null) {
			ids = new HashSet<String>();
			set.put(language, ids);
		}
		
		ids.add(identifier);
		
		return true;
		
	}

}
