package org.gcube.indexmanagement.featureindexlibrary.commons;

import java.io.File;

/**
 * Helper class
 * 
 * @author UoA
 */
public class FileHelper {
	/**
	 * Constant used
	 */
	private static final String BUFFERPOSTFIX=".tmp"; 
	/**
	 * Constant used
	 */
	private static final String FULLSCANPOSTFIX=".FullScan";
	/**
	 * Constant used
	 */
	private static final String VAFVECTORPOSTFIX=".VAFVector";
	/**
	 * Constant used
	 */
	private static final String VAFAPPROXPOSTFIX=".VAFApprox";
	
	//Full Vector Scan
	
	/**
	 * Checks if the full scan file exists
	 * 
	 * @param storage The storage location
	 * @param indexID The index id
	 * @return <code>true</code> if it exists, <code>false</code> otherwise
	 */
	public static boolean existsFullScanFile(String storage,String indexID){
		File tmp=new File(getFullScanFile(storage,indexID));
		return tmp.exists();
	}

	/**
	 * Checks if the full scan buffer file exists
	 * 
	 * @param storage The storage location
	 * @param indexID The index id
	 * @return <code>true</code> if it exists, <code>false</code> otherwise
	 */
	public static boolean existsFullScanBufferFile(String storage,String indexID){
		File tmp=new File(getFullScanBufferFile(storage,indexID));
		return tmp.exists();
	}

	/**
	 * Retrieves the full scan file
	 * 
	 * @param storage The storage location
	 * @param indexID The index id
	 * @return the file path
	 */
	public static String getFullScanFile(String storage,String indexID){
		return storage+indexID+FileHelper.FULLSCANPOSTFIX;
	}

	/**
	 * Retrieves the full scan buffer file
	 * 
	 * @param storage The storage location
	 * @param indexID The index id
	 * @return the file path
	 */
	public static String getFullScanBufferFile(String storage,String indexID){
		return storage+indexID+FileHelper.FULLSCANPOSTFIX+FileHelper.BUFFERPOSTFIX;
	}
	
	/**
	 * removes the full scan file
	 * 
	 * @param storage The storage location
	 * @param indexID The index id
	 * @return wheter or not the file was deleted
	 */
	public static boolean removeFullScanBufferFile(String storage,String indexID){
		File buf=new File(FileHelper.getFullScanBufferFile(storage,indexID));
		return buf.delete();
	}
	
	//VAFile
	
	/**
	 * Checks if the VA buffer file exists
	 * 
	 * @param storage The storage location
	 * @param indexID The index id
	 * @return <code>true</code> if it exists, <code>false</code> otherwise
	 */
	public static boolean existsVAFBufferFile(String storage,String indexID){
		File tmp=new File(getVAFBufferFile(storage,indexID));
		return tmp.exists();
	}
	
	/**
	 * Checks if the VA vector file exists
	 * 
	 * @param storage The storage location
	 * @param indexID The index id
	 * @return <code>true</code> if it exists, <code>false</code> otherwise
	 */
	public static boolean existsVAFVectorFile(String storage,String indexID){
		File tmp=new File(getVAFVectorFile(storage,indexID));
		return tmp.exists();
	}
	
	/**
	 * Checks if the VA approximations file exists
	 * 
	 * @param storage The storage location
	 * @param indexID The index id
	 * @return <code>true</code> if it exists, <code>false</code> otherwise
	 */
	public static boolean existsVAFApproxFile(String storage,String indexID){
		File tmp=new File(getVAFApproxFile(storage,indexID));
		return tmp.exists();
	}
	
	/**
	 * Retrieves the VA buffer file
	 * 
	 * @param storage The storage location
	 * @param indexID The index id
	 * @return the file path
	 */
	public static String getVAFBufferFile(String storage,String indexID){
		return storage+indexID+FileHelper.VAFVECTORPOSTFIX+FileHelper.BUFFERPOSTFIX;
	}

	/**
	 * Retrieves the VA vector file
	 * 
	 * @param storage The storage location
	 * @param indexID The index id
	 * @return the file path
	 */
	public static String getVAFVectorFile(String storage,String indexID){
		return storage+indexID+FileHelper.VAFVECTORPOSTFIX;
	}

	/**
	 * Retrieves the VA approximation file
	 * 
	 * @param storage The storage location
	 * @param indexID The index id
	 * @return the file path
	 */
	public static String getVAFApproxFile(String storage,String indexID){
		return storage+indexID+FileHelper.VAFAPPROXPOSTFIX;
	}

	/**
	 * Removes the VA buffer file
	 * 
	 * @param storage The storage location
	 * @param indexID The index id
	 * @return wheter or not the file was deleted
	 */
	public static boolean removeVAFBufferFile(String storage,String indexID){
		File buf=new File(FileHelper.getVAFBufferFile(storage,indexID));
		return buf.delete();
	}
}
