package org.gcube.indexmanagement.featureindexlibrary.vafile.io;

import java.io.*;
import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.FileHelper;
import org.gcube.indexmanagement.featureindexlibrary.vafile.VAFileParams;
import org.gcube.indexmanagement.featureindexlibrary.vafile.elements.VectorFileEntry;
import org.gcube.indexmanagement.featureindexlibrary.vafile.elements.VectorFileEntryInfo;

/**
 * Vector File Reader
 * 
 * @author UoA
 */
public class VectorFileReader {
	/**
	 * The Logger the class uses
	 */
	private static Logger log = Logger.getLogger(VectorFileReader.class);
	/**
	 * The VAFile header parameters
	 */
	private VAFileParams params=null;
	/**
	 * The input stream
	 */
	private FileInputStream fis=null;
	/**
	 * The input stream
	 */
	private BufferedInputStream bis=null;
	/**
	 * The input stream
	 */
	private DataInputStream dis=null;
	/**
	 * The IO helper
	 */
	private IOHelper helper=null;
	/**
	 * Element count
	 */
	private int count=0;
	
	/**
	 * Creates a new instance
	 * 
	 * @param params The VAFile header params
	 * @throws Exception An error
	 */
	public VectorFileReader(VAFileParams params) throws Exception{
		this.params=params;
		this.helper=new IOHelper();
		this.helper.setIDLength(params.getIDLength());
		this.helper.setVectorLength(params.getVectorLength());
		this.count=0;
	}
	
	/**
	 * Opens
	 * 
	 * @throws Exception An error
	 */
	public void open() throws Exception{
		try{
			fis=new FileInputStream(FileHelper.getVAFVectorFile(params.getStorage(),params.getIndexID()));
			bis=new BufferedInputStream(fis);
			dis=new DataInputStream(bis);
		}catch(Exception e){
			log.error("Could not create reader. Throwing Exception",e);
			throw new Exception("Could not create reader");
		}
	}
	
	/**
	 * reads next entry
	 * 
	 * @return The entry
	 */
	public VectorFileEntryInfo getNext(){
		try{
			VectorFileEntry entry=helper.readRecord(dis);
			count+=1;
			if(entry.isActive()) return new VectorFileEntryInfo(entry,count-1);
			else return this.getNext();
		}catch(Exception e){
			return null;
		}
	}
	
	/**
	 * Closes
	 * 
	 * @throws Exception An error
	 */
	public void close() throws Exception{
		try{
			this.dis.close();
			this.bis.close();
			this.fis.close();
		}catch(Exception e){
			log.error("Could not close reader. Throwing Exception",e);
			throw new Exception("Could not close reader");
		}
	}
}
