/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.common;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBLOBBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBLOBGeneric;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSBLOBIterator;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSBLOBReader;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSBLOBWriter;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.common.ServiceContextContainer;

public class StatisticsFileMerger {
    private static GCUBELog logger = new GCUBELog(StatisticsFileMerger.class);

    public static String merge(List<String> RS_EPRs, ServiceContextContainer scc) throws IndexException {
        try {
            logger.info((Object)"Statistics file merger called");
            logger.info((Object)"Fetching statistics resultsets...");
            ArrayList<BufferedReader> statFileInputs = new ArrayList<BufferedReader>();
            block2: for (int i = 0; i < RS_EPRs.size(); ++i) {
                RSBLOBIterator iterator = RSBLOBReader.getRSBLOBReader((RSLocator)new RSLocator(RS_EPRs.get(i))).makeLocal((RSResourceType)new RSResourceLocalType()).getRSIterator();
                while (iterator.hasNext()) {
                    ResultElementBLOBGeneric blob = (ResultElementBLOBGeneric)iterator.next(ResultElementBLOBGeneric.class);
                    if (blob == null) continue;
                    statFileInputs.add(new BufferedReader(new InputStreamReader(new BufferedInputStream(blob.getContentOfBLOB()))));
                    continue block2;
                }
            }
            logger.info((Object)"Combining statistics...");
            PipedOutputStream combinedOutput = new PipedOutputStream();
            PipedInputStream combinedInput = new PipedInputStream(combinedOutput);
            StatFileCombiner combiner = new StatFileCombiner(statFileInputs, combinedOutput);
            combiner.combine();
            logger.info((Object)"Creating output ResultSet...");
            RSBLOBWriter writer = RSBLOBWriter.getRSBLOBWriter();
            ResultElementBLOBGeneric blob = new ResultElementBLOBGeneric("foo", "bar", null, (InputStream)new BufferedInputStream(combinedInput));
            writer.addResults((ResultElementBLOBBase)blob);
            writer.close();
            return writer.getRSLocator((RSResourceType)new RSResourceWSRFType()).getLocator();
        }
        catch (Exception e) {
            logger.error((Object)"Error while merging statistics.", (Throwable)e);
            throw new IndexException(e);
        }
    }

    private static class StatFileCombiner {
        private BufferedWriter writer;
        private ArrayList<BufferedReader> readers;
        private ArrayList<BufferedReader> unfinishedReaders;
        private HashSet<BufferedReader> nextLineReaders = new HashSet();
        private HashMap<BufferedReader, String> currentLines = new HashMap();

        public StatFileCombiner(ArrayList<BufferedReader> statFileReaders, PipedOutputStream out) {
            try {
                this.readers = statFileReaders;
                this.unfinishedReaders = new ArrayList();
                this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "ISO-8859-1"));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }

        public void combine() {
            try {
                String regex = "^<term><t>(.*)</t><d>(\\d*)</d><c>(\\d*)</c></term>$";
                Pattern termPattern = Pattern.compile(regex);
                String docsRegex = "^<numDocs>(\\d*)</numDocs>$";
                Pattern docsPattern = Pattern.compile(docsRegex);
                int numDocs = 0;
                for (BufferedReader reader : this.readers) {
                    String line = "";
                    while (line != null && !line.trim().startsWith("<term>") && !line.trim().startsWith("</terms>")) {
                        if (line.trim().startsWith("<numDocs>")) {
                            Matcher m = docsPattern.matcher(line.trim());
                            m.find();
                            String docs = m.group(1);
                            if (docs != null) {
                                numDocs += Integer.parseInt(docs);
                            }
                        }
                        line = reader.readLine();
                    }
                    if (line == null || !line.trim().startsWith("<term>")) continue;
                    this.unfinishedReaders.add(reader);
                    this.currentLines.put(reader, line);
                }
                String header = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<statistics>\n<head>\n<numDocs>" + numDocs + "</numDocs>\n" + "<time_created>" + new Date() + "</time_created>\n</head>\n" + "<body><terms>\n";
                this.writer.write(header);
                while (this.unfinishedReaders.size() > 0) {
                    String smallestTerm = null;
                    int docCount = 0;
                    int termCount = 0;
                    ListIterator<BufferedReader> iterator = this.unfinishedReaders.listIterator();
                    while (iterator.hasNext()) {
                        int comparison;
                        BufferedReader reader = iterator.next();
                        String termLine = this.currentLines.get(reader);
                        if (termLine == null || !termLine.trim().startsWith("<term>")) {
                            iterator.remove();
                            continue;
                        }
                        Matcher m = termPattern.matcher(termLine.trim());
                        m.find();
                        String myTerm = m.group(1);
                        int n = comparison = smallestTerm == null ? -1 : myTerm.compareTo(smallestTerm);
                        if (comparison < 0) {
                            smallestTerm = myTerm;
                            docCount = Integer.parseInt(m.group(2));
                            termCount = Integer.parseInt(m.group(3));
                            this.nextLineReaders.clear();
                            this.nextLineReaders.add(reader);
                            continue;
                        }
                        if (comparison != 0) continue;
                        docCount += Integer.parseInt(m.group(2));
                        termCount += Integer.parseInt(m.group(3));
                        this.nextLineReaders.add(reader);
                    }
                    for (BufferedReader reader : this.nextLineReaders) {
                        this.currentLines.put(reader, reader.readLine());
                    }
                    this.writer.write("  <term><t>" + smallestTerm + "</t><d>" + docCount + "</d><c>" + termCount + "</c></term>\n");
                }
                String footer = "</terms></body>\n</statistics>\n";
                this.writer.write(footer);
            }
            catch (Exception e) {
                logger.error((Object)"Error while combining statistics.", (Throwable)e);
            }
        }
    }
}

