/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.featureindexlibrary.vafile;

import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.DistanceCalculation;
import org.gcube.indexmanagement.featureindexlibrary.commons.FIEnums;
import org.gcube.indexmanagement.featureindexlibrary.commons.FeatureIndex;
import org.gcube.indexmanagement.featureindexlibrary.commons.FeatureVectorElement;
import org.gcube.indexmanagement.featureindexlibrary.commons.FileHelper;
import org.gcube.indexmanagement.featureindexlibrary.commons.HeapElement;
import org.gcube.indexmanagement.featureindexlibrary.commons.LookupBuffer;
import org.gcube.indexmanagement.featureindexlibrary.commons.LookupParams;
import org.gcube.indexmanagement.featureindexlibrary.commons.RankedResultElement;
import org.gcube.indexmanagement.featureindexlibrary.commons.SortedHeap;
import org.gcube.indexmanagement.featureindexlibrary.vafile.VAFileParams;
import org.gcube.indexmanagement.featureindexlibrary.vafile.algo.ComputeBoundsL;
import org.gcube.indexmanagement.featureindexlibrary.vafile.algo.ComputeBoundsLU;
import org.gcube.indexmanagement.featureindexlibrary.vafile.algo.PointPartitioning;
import org.gcube.indexmanagement.featureindexlibrary.vafile.algo.PopulateIndex;
import org.gcube.indexmanagement.featureindexlibrary.vafile.elements.ApproximationFileEntry;
import org.gcube.indexmanagement.featureindexlibrary.vafile.elements.ApproximationFileEntryInfo;
import org.gcube.indexmanagement.featureindexlibrary.vafile.elements.VectorFileEntry;
import org.gcube.indexmanagement.featureindexlibrary.vafile.elements.VectorFileEntryInfo;
import org.gcube.indexmanagement.featureindexlibrary.vafile.io.ApproximationFileRandomAccess;
import org.gcube.indexmanagement.featureindexlibrary.vafile.io.ApproximationFileReader;
import org.gcube.indexmanagement.featureindexlibrary.vafile.io.FileBufferWriter;
import org.gcube.indexmanagement.featureindexlibrary.vafile.io.IOHelper;
import org.gcube.indexmanagement.featureindexlibrary.vafile.io.VectorFileRandomAccess;
import org.gcube.indexmanagement.featureindexlibrary.vafile.io.VectorFileReader;

public class VAFile
implements FeatureIndex {
    private static final Object lockMe = new Object();
    private static Logger logger = Logger.getLogger(VAFile.class);
    private VAFileParams params = null;

    public VAFile(VAFileParams params) throws Exception {
        try {
            this.params = params;
            if (this.params.getDistanceMeasure().compareTo(FIEnums.DistanceTypes.Default) == 0) {
                logger.error((Object)"Cannot initialize index with default distance measure. throwing exception");
                throw new Exception("Cannot initialize index with default distance measure");
            }
            if (FileHelper.existsVAFVectorFile(params.getStorage(), params.getIndexID())) {
                IOHelper helper = new IOHelper();
                RandomAccessFile rand = new RandomAccessFile(FileHelper.getVAFVectorFile(params.getStorage(), params.getIndexID()), "rw");
                this.params = helper.readHeader(rand);
                rand.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Could not initialize VAFile. throwing Exception", (Throwable)e);
            throw new Exception("Could not initialize VAFile");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFeatureVector(FeatureVectorElement elem) throws Exception {
        Object object = lockMe;
        synchronized (object) {
            FileBufferWriter writer = null;
            int count = 0;
            try {
                writer = new FileBufferWriter(FileHelper.getVAFBufferFile(this.params.getStorage(), this.params.getIndexID()), this.params);
                writer.openForUpdate();
                if (!writer.addElement(elem)) {
                    ++count;
                }
                writer.close();
                if (count > 0) {
                    logger.info((Object)("Could not add " + count + " record"));
                }
            }
            catch (Exception e) {
                if (writer != null) {
                    writer.close();
                }
                logger.error((Object)"Could not add record. throwing Exception", (Throwable)e);
                throw new Exception("Could not add record");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFeatureVector(FeatureVectorElement[] elem) throws Exception {
        Object object = lockMe;
        synchronized (object) {
            FileBufferWriter writer = null;
            int count = 0;
            try {
                writer = new FileBufferWriter(FileHelper.getVAFBufferFile(this.params.getStorage(), this.params.getIndexID()), this.params);
                writer.openForUpdate();
                for (int i = 0; i < elem.length; ++i) {
                    if (writer.addElement(elem[i])) continue;
                    ++count;
                }
                writer.close();
                if (count > 0) {
                    logger.info((Object)("Could not add " + count + " record"));
                }
            }
            catch (Exception e) {
                if (writer != null) {
                    writer.close();
                }
                logger.error((Object)"Could not add records. throwing Exception", (Throwable)e);
                throw new Exception("Could not add records");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws Exception {
        Object object = lockMe;
        synchronized (object) {
            PopulateIndex pop = null;
            try {
                if (!FileHelper.existsVAFBufferFile(this.params.getStorage(), this.params.getIndexID())) {
                    return;
                }
                if (!FileHelper.existsVAFVectorFile(this.params.getStorage(), this.params.getIndexID())) {
                    PointPartitioning partitioning = new PointPartitioning(FileHelper.getVAFBufferFile(this.params.getStorage(), this.params.getIndexID()), this.params);
                    partitioning.computePartitionPoints();
                    this.params.setBuckets(partitioning.getPartitionBuckets());
                    this.params.setPartitionPoints(partitioning.getPartitionPoints());
                    pop = new PopulateIndex(this.params, true);
                } else {
                    pop = new PopulateIndex(this.params, false);
                }
                pop.open();
                pop.populate();
                pop.close();
                FileHelper.removeVAFBufferFile(this.params.getStorage(), this.params.getIndexID());
            }
            catch (Exception e) {
                FileHelper.removeVAFBufferFile(this.params.getStorage(), this.params.getIndexID());
                if (pop != null) {
                    pop.close();
                }
                logger.error((Object)"Could not perform commit. Throwing Exception", (Throwable)e);
                throw new Exception("Could not perform commit");
            }
        }
    }

    @Override
    public long getNumberOfElements() throws Exception {
        return this.params.getElementCount();
    }

    @Override
    public ArrayList<RankedResultElement> lookup(float[] vector, int k) throws Exception {
        try {
            return this.lookup(vector, k, new LookupParams(FIEnums.AlgoType.Default, FIEnums.DistanceTypes.Default, this.params.getWeighted()));
        }
        catch (Exception e) {
            logger.error((Object)"Could not perform lookup operation. Throwing Exception", (Throwable)e);
            throw new Exception("Could not perform lookup operation");
        }
    }

    @Override
    public ArrayList<RankedResultElement> lookup(float[] vector, int k, LookupParams lp) throws Exception {
        try {
            Object bounds;
            ArrayList<RankedResultElement> res = null;
            long start = Calendar.getInstance().getTimeInMillis();
            long bstart = 0L;
            long bstop = 0L;
            long lstart = 0L;
            long lstop = 0L;
            if (lp.getAlgo().compareTo(FIEnums.AlgoType.SSA) == 0) {
                bstart = Calendar.getInstance().getTimeInMillis();
                bounds = new ComputeBoundsL(this.params.getPartitionPoints(), this.params.getBuckets());
                ((ComputeBoundsL)bounds).preCompute(vector);
                bstop = Calendar.getInstance().getTimeInMillis();
                lstart = Calendar.getInstance().getTimeInMillis();
                res = this.lookupSSA(vector, k, (ComputeBoundsL)bounds, lp);
                lstop = Calendar.getInstance().getTimeInMillis();
            }
            if (lp.getAlgo().compareTo(FIEnums.AlgoType.Default) == 0 || lp.getAlgo().compareTo(FIEnums.AlgoType.NOA) == 0) {
                bstart = Calendar.getInstance().getTimeInMillis();
                bounds = new ComputeBoundsLU(this.params.getPartitionPoints(), this.params.getBuckets());
                ((ComputeBoundsLU)bounds).preCompute(vector);
                bstop = Calendar.getInstance().getTimeInMillis();
                lstart = Calendar.getInstance().getTimeInMillis();
                res = this.lookupNOA(vector, k, (ComputeBoundsLU)bounds, lp);
                lstop = Calendar.getInstance().getTimeInMillis();
            }
            long stop = Calendar.getInstance().getTimeInMillis();
            logger.info((Object)("bound computations took " + (bstop - bstart) + " millisecs"));
            logger.info((Object)("lookup computations took " + (lstop - lstart) + " millisecs"));
            logger.info((Object)("total lookup took " + (stop - start) + " millisecs"));
            return res;
        }
        catch (Exception e) {
            logger.error((Object)"Could not perform lookup operation. Throwing Exception", (Throwable)e);
            throw new Exception("Could not perform lookup operation");
        }
    }

    private ArrayList<RankedResultElement> lookupSSA(float[] vector, int k, ComputeBoundsL bounds, LookupParams lp) throws Exception {
        try {
            ApproximationFileEntryInfo info;
            ApproximationFileReader aReader = new ApproximationFileReader(this.params);
            VectorFileRandomAccess vReader = new VectorFileRandomAccess(this.params);
            LookupBuffer buf = new LookupBuffer(k);
            aReader.open();
            vReader.open();
            float threshold = Float.MAX_VALUE;
            while ((info = aReader.getNext()) != null) {
                if (!(bounds.getLowerBound(info.getEntry().getBitString()) < threshold)) continue;
                vReader.moveTo(info.getPosition());
                VectorFileEntry entry = vReader.read();
                if (entry == null) continue;
                FIEnums.DistanceTypes distMeasure = this.params.getDistanceMeasure();
                if (lp.getDist().compareTo(FIEnums.DistanceTypes.Default) != 0) {
                    distMeasure = lp.getDist();
                }
                float distance = 0.0f;
                distance = lp.isWeighted() ? DistanceCalculation.distance(vector, entry.getVector(), threshold, distMeasure, this.params.getWeights()) : DistanceCalculation.distance(vector, entry.getVector(), threshold, distMeasure);
                threshold = buf.process(new RankedResultElement(entry.getId(), distance));
            }
            aReader.close();
            vReader.close();
            return buf.getResults(this.params.getIndexName());
        }
        catch (Exception e) {
            logger.error((Object)"Could not perform lookup operation. Throwing Exception", (Throwable)e);
            throw new Exception("Could not perform lookup operation");
        }
    }

    private ArrayList<RankedResultElement> lookupNOA(float[] vector, int k, ComputeBoundsLU bounds, LookupParams lp) throws Exception {
        try {
            ApproximationFileEntryInfo info;
            ApproximationFileReader aReader = new ApproximationFileReader(this.params);
            LookupBuffer buf = new LookupBuffer(k);
            SortedHeap heap = new SortedHeap();
            aReader.open();
            float threshold = Float.MAX_VALUE;
            float lBound = 0.0f;
            while ((info = aReader.getNext()) != null) {
                lBound = bounds.getLowerBound(info.getEntry().getBitString());
                if (!(lBound < threshold)) continue;
                threshold = buf.process(new RankedResultElement("", bounds.getUpperBound(info.getEntry().getBitString())));
                heap.add(new HeapElement(info.getPosition(), lBound));
            }
            aReader.close();
            heap.sort();
            VectorFileRandomAccess vReader = new VectorFileRandomAccess(this.params);
            vReader.open();
            buf = new LookupBuffer(k);
            threshold = Float.MAX_VALUE;
            lBound = 0.0f;
            long recNum = 0L;
            int count = heap.getNumberOfElements();
            for (int i = 0; i < count && lBound < threshold; ++i) {
                lBound = heap.get(i).getLBound();
                recNum = heap.get(i).getRecNum();
                if (!(lBound < threshold)) continue;
                vReader.moveTo(recNum);
                VectorFileEntry entry = vReader.read();
                if (entry == null) continue;
                FIEnums.DistanceTypes distMeasure = this.params.getDistanceMeasure();
                if (lp.getDist().compareTo(FIEnums.DistanceTypes.Default) != 0) {
                    distMeasure = lp.getDist();
                }
                float distance = 0.0f;
                distance = lp.isWeighted() ? DistanceCalculation.distance(vector, entry.getVector(), threshold, distMeasure, this.params.getWeights()) : DistanceCalculation.distance(vector, entry.getVector(), threshold, distMeasure);
                threshold = buf.process(new RankedResultElement(entry.getId(), distance));
            }
            vReader.close();
            return buf.getResults(this.params.getIndexName());
        }
        catch (Exception e) {
            logger.error((Object)"Could not perform lookup operation. Throwing Exception", (Throwable)e);
            throw new Exception("Could not perform lookup operation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntry(String id) throws Exception {
        Object object = lockMe;
        synchronized (object) {
            try {
                VectorFileEntryInfo entry;
                VectorFileReader reader = new VectorFileReader(this.params);
                long recNum = 0L;
                reader.open();
                while ((entry = reader.getNext()) != null) {
                    if (entry.getEntry().getId().compareTo(id) != 0) continue;
                    recNum = entry.getPosition();
                    break;
                }
                reader.close();
                ApproximationFileRandomAccess apReader = new ApproximationFileRandomAccess(this.params);
                apReader.open();
                apReader.moveTo(recNum);
                ApproximationFileEntry apEntry = apReader.read();
                apEntry.setActive(false);
                apReader.moveTo(recNum);
                apReader.write(apEntry);
                apReader.close();
                VectorFileRandomAccess vReader = new VectorFileRandomAccess(this.params);
                vReader.open();
                vReader.moveTo(recNum);
                VectorFileEntry vEntry = vReader.read();
                vEntry.setActive(false);
                vReader.moveTo(recNum);
                vReader.write(vEntry);
                vReader.close();
            }
            catch (Exception e) {
                logger.error((Object)"Could not remove record. Throwing Exception", (Throwable)e);
                throw new Exception("Could not remove record");
            }
        }
    }

    @Override
    public String getIndexID() throws Exception {
        return this.params.getIndexID();
    }
}

