/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.common.linguistics.jtextcat;

import java.util.Vector;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.common.linguistics.languageidplugin.LanguageIdPlugin;
import org.gcube.indexmanagement.common.linguistics.lemmatizerplugin.Language;
import org.knallgrau.utils.textcat.TextCategorizer;

public class JTextCatPlugin
implements LanguageIdPlugin {
    private TextCategorizer guesser;
    private Vector<Language> languageVector;

    @Override
    public void init(String configFile) throws IndexException {
        this.guesser = new TextCategorizer();
        this.languageVector = new Vector();
        for (Language ll : Language.values()) {
            this.languageVector.add(ll);
        }
    }

    @Override
    public String detectLanguage(String document) throws IndexException {
        String res;
        try {
            res = this.guesser.categorize(document);
            for (Language l : this.languageVector) {
                if (!res.equalsIgnoreCase(l.toLongString())) continue;
                res = l.toShortString();
            }
        }
        catch (Exception ex) {
            return "nolang";
        }
        if (res.equals("unknown")) {
            return "nolang";
        }
        return res;
    }
}

