package org.gcube.indexmanagement.featureindexlibrary.commons;

import java.util.ArrayList;

/**
 * Feature index interface
 * 
 * @author UoA
 */
public interface FeatureIndex {
	
	/**
	 * Adds a new element
	 * 
	 * @param elem The element
	 * @throws Exception An unrecoverable for the operation error occured
	 */
	public void addFeatureVector(FeatureVectorElement elem) throws Exception;

	/**
	 * Adds new elements
	 * 
	 * @param elem The elements
	 * @throws Exception An unrecoverable for the operation error occured
	 */
	public void addFeatureVector(FeatureVectorElement []elem) throws Exception;
	
	/**
	 * Commits additions
	 * 
	 * @throws Exception An unrecoverable for the operation error occured
	 */
	public void commit() throws Exception;
	
	/**
	 * Retrieves the number of elements in the index
	 * 
	 * @return the number of results
	 * @throws Exception An unrecoverable for the operation error occured
	 */
	public long getNumberOfElements() throws Exception;
	
	/**
	 * Removes the record from the index
	 * 
	 * @param id The id of the record
	 * @throws Exception An unrecoverable for the operation error occured
	 */
	public void removeEntry(String id) throws Exception;
	
	/**
	 * Performs a lookup with default parameter values
	 * 
	 * @param vector The prototype vector
	 * @param k The number of results
	 * @return The results 
	 * @throws Exception An unrecoverable for the operation error occured
	 */
	public ArrayList<RankedResultElement> lookup(float []vector,int k) throws Exception;
	
	/**
	 * Performs a lookup with default parameter values
	 * 
	 * @param vector The prototype vector
	 * @param k The number of results
	 * @param params The parameters of the lookup
	 * @return The results 
	 * @throws Exception An unrecoverable for the operation error occured
	 */
	public ArrayList<RankedResultElement> lookup(float []vector,int k,LookupParams params) throws Exception;
	
	/**
	 * Returns the index id of the index instance
	 * 
	 * @return The index ID
	 * @throws Exception An unrecoverable for the operation error occured
	 */
	public String getIndexID() throws Exception;
}
