/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.lucenewrapper;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.Hits;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.indexmanagement.common.FullTextIndexType;
import org.gcube.indexmanagement.common.IndexField;
import org.gcube.indexmanagement.common.XMLProfileParser;
import org.gcube.indexmanagement.common.XMLTokenReplacer;
import org.gcube.indexmanagement.lucenewrapper.HighlighterWrapper;
import org.gcube.indexmanagement.lucenewrapper.QuerySnippetTermsPair;
import org.gcube.indexmanagement.lucenewrapper.QueryTerm;
import org.gcube.indexmanagement.resourceregistry.RRadaptor;

public class LuceneSearchWorker
extends Thread {
    private static final long RSTIMEOUT = 10L;
    static GCUBELog logger = new GCUBELog(LuceneSearchWorker.class);
    private RecordWriter<GenericRecord> rsWriter;
    private Hits queryHits;
    private int numberOfHits;
    private QueryTerm[] terms;
    private IndexReader reader;
    private FullTextIndexType idxType;
    private boolean isComplete;
    private LinkedHashMap<String, String> projections;
    private ArrayList<String> presentable;
    private RRadaptor adaptor = null;
    private QuerySnippetTermsPair querySnippetTermsPair;
    private HighlighterWrapper highlighter;
    private Integer snippetSize;
    private Integer maximumSnippetsCount;

    public void setSnippetSize(Integer snippetSize) {
        this.snippetSize = snippetSize;
    }

    public void setMaximumSnippetsCount(Integer maximumSnippetsCount) {
        this.maximumSnippetsCount = maximumSnippetsCount;
    }

    public LuceneSearchWorker(RecordWriter<GenericRecord> rsWriter, IndexReader reader, QueryTerm[] terms, Hits queryHits, int numberOfHits, FullTextIndexType idxType, boolean isComplete, ArrayList<String> presentable, LinkedHashMap<String, String> projections, QuerySnippetTermsPair querySnippetTermsPair, RRadaptor adaptor) {
        this.rsWriter = rsWriter;
        this.queryHits = queryHits;
        this.numberOfHits = numberOfHits;
        this.terms = terms;
        this.reader = reader;
        this.idxType = idxType;
        this.isComplete = isComplete;
        this.projections = projections;
        this.presentable = presentable;
        this.adaptor = adaptor;
        this.querySnippetTermsPair = querySnippetTermsPair;
        this.highlighter = new HighlighterWrapper(reader);
    }

    @Override
    public void run() {
        try {
            logger.info((Object)"Starting lucene worker");
            long before = Calendar.getInstance().getTimeInMillis();
            long beforeFirst = Calendar.getInstance().getTimeInMillis();
            long totalTimeForPuttingResults = 0L;
            long totalLucene = 0L;
            int capacity = 0;
            if (this.rsWriter != null) {
                capacity = this.rsWriter.getCapacity();
            }
            for (int i = 0; i < this.numberOfHits && this.rsWriter.getStatus() == IBuffer.Status.Open; ++i) {
                GenericRecord rec = new GenericRecord();
                ArrayList<StringField> fields = new ArrayList<StringField>();
                long beforeLucene = Calendar.getInstance().getTimeInMillis();
                fields.add(new StringField("" + this.queryHits.score(i)));
                int docID = this.queryHits.id(i);
                Document doc = this.queryHits.doc(i);
                Vector<String> addedTermStrings = new Vector<String>();
                String docStatistics = "<docStatistics wc=\"" + doc.get("_wordcount") + "\"><terms>\n";
                for (int tt = 0; tt < this.terms.length; ++tt) {
                    String termString = this.terms[tt].getTerm();
                    if (addedTermStrings.contains(termString)) continue;
                    int termCount = this.getFreq(doc.fields(), termString, docID);
                    docStatistics = docStatistics + "<term name=\"" + termString + "\" tf=\"" + termCount + "\"/>\n";
                    addedTermStrings.add(termString);
                }
                docStatistics = docStatistics + "</terms><rank>" + this.queryHits.score(i) + "</rank>";
                docStatistics = docStatistics + "</docStatistics>\n";
                long afterLucene = Calendar.getInstance().getTimeInMillis();
                totalLucene += afterLucene - beforeLucene;
                fields.add(new StringField(docStatistics));
                String objectID = "NoMetaId";
                String fieldContentDocID = doc.get("ObjectID".toLowerCase());
                if (fieldContentDocID != null) {
                    objectID = fieldContentDocID;
                }
                fields.add(new StringField(objectID));
                if (!this.isComplete) {
                    if (this.projections != null && this.projections.size() != 0) {
                        if (this.projections.containsValue("*")) {
                            for (String string : this.presentable) {
                                if (string.equalsIgnoreCase("ObjectID") || string.equalsIgnoreCase("fullpayload")) continue;
                                String fieldContent = null;
                                fieldContent = string.equals("S") ? this.createSnippet(doc, this.querySnippetTermsPair.snippetTerms) : doc.get(string);
                                if (fieldContent != null) {
                                    fields.add(new StringField(XMLProfileParser.escapeForXML(fieldContent)));
                                    continue;
                                }
                                fields.add(new StringField(""));
                            }
                        } else {
                            for (Map.Entry<String, String> entry : this.projections.entrySet()) {
                                String proj = entry.getValue();
                                String fieldContent = "";
                                if (proj.equals("S")) {
                                    fieldContent = this.createSnippet(doc, this.querySnippetTermsPair.snippetTerms);
                                } else {
                                    IndexField idxTypeField = this.getFieldFromIndexType(proj);
                                    if (idxTypeField == null) {
                                        logger.error((Object)("The projection " + proj + ", is not part of the index Type"));
                                    }
                                    String fieldName = idxTypeField.name;
                                    fieldContent = doc.get(fieldName);
                                }
                                if (fieldContent != null) {
                                    fieldContent = XMLProfileParser.escapeForXML(fieldContent);
                                }
                                fields.add(new StringField(fieldContent));
                            }
                        }
                    }
                } else {
                    fields.add(new StringField(XMLTokenReplacer.XMLResolve(doc.get("fullpayload"))));
                }
                if (this.rsWriter != null) {
                    if (this.rsWriter.getStatus() != IBuffer.Status.Open) break;
                    rec.setFields(fields.toArray(new gr.uoa.di.madgik.grs.record.field.Field[fields.size()]));
                    long beforePut = Calendar.getInstance().getTimeInMillis();
                    while (!this.rsWriter.put((Record)rec, 10L, TimeUnit.SECONDS) && this.rsWriter.getStatus() == IBuffer.Status.Open) {
                    }
                    long afterPut = Calendar.getInstance().getTimeInMillis();
                    if (i == capacity) {
                        beforeFirst = Calendar.getInstance().getTimeInMillis();
                        continue;
                    }
                    totalTimeForPuttingResults += afterPut - beforePut;
                    continue;
                }
                for (gr.uoa.di.madgik.grs.record.field.Field field : fields) {
                    logger.info((Object)("Field content: " + ((StringField)field).getPayload()));
                }
            }
            long after = Calendar.getInstance().getTimeInMillis();
            logger.info((Object)("Lucene worker finished after: " + (after - before)));
            logger.info((Object)("Lucene worker, actual time from first to last: " + (after - beforeFirst)));
            logger.info((Object)("Lucene worker, total time for lucene: " + totalLucene));
            logger.info((Object)("Lucene worker, total time for putting results into the RS: " + totalTimeForPuttingResults));
            logger.info((Object)("Percentage of total time for putting results TO total time from first to last: " + (double)totalTimeForPuttingResults / (double)(after - beforeFirst) * 100.0 + "%"));
            if (this.rsWriter.getStatus() != IBuffer.Status.Dispose) {
                this.rsWriter.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error during search.", (Throwable)e);
            try {
                if (this.rsWriter.getStatus() != IBuffer.Status.Dispose) {
                    this.rsWriter.close();
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Error while closing RS writer.", (Throwable)ex);
            }
        }
    }

    private String createSnippet(Document doc, HashMap<String, ArrayList<String>> snippetTerms) throws Exception {
        this.highlighter.setMaximumSnippetsCount(this.maximumSnippetsCount);
        this.highlighter.setSnippetSize(this.snippetSize);
        List<String> snippets = this.highlighter.getDocSnippets(doc, snippetTerms);
        return HighlighterWrapper.getSnippetString(snippets);
    }

    private IndexField getFieldFromIndexType(String proj) {
        for (IndexField type : this.idxType.getFields()) {
            if (!type.name.equalsIgnoreCase(proj)) continue;
            if (type.store && type.returned) {
                return type;
            }
            logger.warn((Object)("Projection: " + proj + ", isStored: " + type.store + ", and isReturned: " + type.returned));
            return null;
        }
        logger.warn((Object)("Projection: " + proj + " was not found!"));
        return null;
    }

    public int getFreq(Term t, int docID) throws IOException {
        TermDocs td = this.reader.termDocs(t);
        if (td.skipTo(docID) && td.doc() == docID) {
            return td.freq();
        }
        return 0;
    }

    public int getFreq(Enumeration fields, String termString, int docID) throws IOException {
        int count = 0;
        Vector<String> countedFields = new Vector<String>();
        while (fields.hasMoreElements()) {
            Field field = (Field)fields.nextElement();
            if (countedFields.contains(field.name()) || !field.isIndexed()) continue;
            count += this.getFreq(new Term(field.name(), termString), docID);
            countedFields.add(field.name());
        }
        return count;
    }
}

