/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.featureindexlibrary.commons;

import org.apache.log4j.Logger;
import org.gcube.indexmanagement.featureindexlibrary.commons.FeatureIndexStatsContainer;

public class FeatureFactoryStatsContainer
extends Thread {
    private static Logger log = Logger.getLogger(FeatureIndexStatsContainer.class);
    private Object lockMe = new Object();
    private long NumberOfIndexesCreated = 0L;
    private long NumberofVAFIles = 0L;
    private long NumberOfFullScans = 0L;
    private long NumberOfMerge = 0L;
    private long MeanMergeTime = 0L;
    private long MaxMergeTime = 0L;
    private long MinMergeTime = Long.MAX_VALUE;
    private long MeanMergeResults = 0L;
    private long MaxMergeResults = 0L;
    private long MinMergeResults = Long.MAX_VALUE;

    public FeatureFactoryStatsContainer(String ServiceClass, String ServiceName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newFullScan() {
        Object object = this.lockMe;
        synchronized (object) {
            ++this.NumberOfIndexesCreated;
            ++this.NumberOfFullScans;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newVAFile() {
        Object object = this.lockMe;
        synchronized (object) {
            ++this.NumberOfIndexesCreated;
            ++this.NumberofVAFIles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newMerge() {
        Object object = this.lockMe;
        synchronized (object) {
            ++this.NumberOfMerge;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeTime(long time) {
        Object object = this.lockMe;
        synchronized (object) {
            if (this.MinMergeTime > time) {
                this.MinMergeTime = time;
            }
            if (this.MaxMergeTime < time) {
                this.MaxMergeTime = time;
            }
            if (this.NumberOfMerge != 0L) {
                this.MeanMergeTime = (this.MeanMergeTime * (this.NumberOfMerge - 1L) + time) / this.NumberOfMerge;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeResults(long results) {
        Object object = this.lockMe;
        synchronized (object) {
            if (this.MinMergeResults > results) {
                this.MinMergeResults = results;
            }
            if (this.MaxMergeResults < results) {
                this.MaxMergeResults = results;
            }
            if (this.NumberOfMerge != 0L) {
                this.MeanMergeResults = (this.MeanMergeResults * (this.NumberOfMerge - 1L) + results) / this.NumberOfMerge;
            }
        }
    }

    public void writeToRI() throws Exception {
        log.info((Object)("specific data : " + this.toXML()));
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(1200000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.writeToRI();
                continue;
            }
            catch (Exception e) {
                log.error((Object)"could not update RI profile.continuing", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<Statistics>");
        buf.append("<text>");
        buf.append("this section summarizes some statisitc information for the service since the last restart");
        buf.append("</text>");
        buf.append("<NumberOfIndexesCreated>");
        buf.append("<value>");
        buf.append(this.NumberOfIndexesCreated);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the total number of indexes created");
        buf.append("</description>");
        buf.append("</NumberOfIndexesCreated>");
        buf.append("<NumberofVAFIles>");
        buf.append("<value>");
        buf.append(this.NumberofVAFIles);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the total number of VAFile indexes created");
        buf.append("</description>");
        buf.append("</NumberofVAFIles>");
        buf.append("<NumberOfFullScans>");
        buf.append("<value>");
        buf.append(this.NumberOfFullScans);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the total number of FullScan indexes created");
        buf.append("</description>");
        buf.append("</NumberOfFullScans>");
        buf.append("<NumberOfMerge>");
        buf.append("<value>");
        buf.append(this.NumberOfMerge);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the total number of merge requests");
        buf.append("</description>");
        buf.append("</NumberOfMerge>");
        buf.append("<MeanMergeTime>");
        buf.append("<value>");
        buf.append(this.MeanMergeTime);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the mean time of merge requests");
        buf.append("</description>");
        buf.append("</MeanMergeTime>");
        buf.append("<MaxMergeTime>");
        buf.append("<value>");
        buf.append(this.MaxMergeTime);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the max time of merge requests");
        buf.append("</description>");
        buf.append("</MaxMergeTime>");
        buf.append("<MinMergeTime>");
        buf.append("<value>");
        buf.append(this.MinMergeTime);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the min time of merge requests");
        buf.append("</description>");
        buf.append("</MinMergeTime>");
        buf.append("<MeanMergeResults>");
        buf.append("<value>");
        buf.append(this.MeanMergeResults);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the mean results of merge requests");
        buf.append("</description>");
        buf.append("</MeanMergeResults>");
        buf.append("<MaxMergeResults>");
        buf.append("<value>");
        buf.append(this.MaxMergeResults);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the max results of merge requests");
        buf.append("</description>");
        buf.append("</MaxMergeResults>");
        buf.append("<MinMergeResults>");
        buf.append("<value>");
        buf.append(this.MinMergeResults);
        buf.append("</value>");
        buf.append("<description>");
        buf.append("the min results of merge requests");
        buf.append("</description>");
        buf.append("</MinMergeResults>");
        buf.append("</Statistics>");
        return buf.toString();
    }
}

