/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geo;

public class GeoIndexField {
    public String name;
    public boolean isVariable;
    public boolean isReturnable;
    public int size;
    public DataType dataType;

    public GeoIndexField() {
    }

    public GeoIndexField(String name, boolean isReturnable, DataType dataType) {
        this.name = name;
        this.isReturnable = isReturnable;
        this.dataType = dataType;
        this.size = dataType.getDefaultSize();
    }

    public GeoIndexField(String name, boolean isReturnable, int stringDataTypeSize) {
        this.name = name;
        this.isReturnable = isReturnable;
        this.dataType = DataType.STRING;
        this.size = stringDataTypeSize;
    }

    public String toString() {
        return this.name + "( isReturnable=" + this.isReturnable + " dataType=" + (Object)((Object)this.dataType) + " class=" + this.dataType.getTypeClass().getName() + " size=" + this.size + " )";
    }

    public static enum DataType {
        SHORT(Short.class, 2),
        INT(Integer.class, 4),
        LONG(Long.class, 8),
        DATE(Long.class, 8),
        FLOAT(Float.class, 4),
        DOUBLE(Double.class, 8),
        STRING(String.class, 100);

        private final Class typeClass;
        private final int defaultSize;

        private DataType(Class typeClass, int defaultSize) {
            this.typeClass = typeClass;
            this.defaultSize = defaultSize;
        }

        public static DataType getByName(String name) throws Exception {
            for (DataType type : DataType.values()) {
                if (!name.equalsIgnoreCase(type.toString())) continue;
                return type;
            }
            throw new Exception("specified DataTypeName does not match any DataTypes: \"" + name + "\"");
        }

        public Class getTypeClass() {
            return this.typeClass;
        }

        public int getDefaultSize() {
            return this.defaultSize;
        }
    }
}

