/*
 * PropertyElementForwardIndexService.java
 *
 * $Author: tsakas $
 * $Date: 2007/12/20 14:37:40 $
 * $Id: PropertyElementForwardIndex.java,v 1.1 2007/12/20 14:37:40 tsakas Exp $
 *
 * <pre>
 *             Copyright (c) : 2006 Fast Search & Transfer ASA
 *                             ALL RIGHTS RESERVED
 * </pre>
 */

package org.gcube.indexmanagement.common;

import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementBase;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Class used to get the property elements for the ForwardIndex.
 *
 */

public class PropertyElementForwardIndex extends PropertyElementBase {

    /**
     * The property type .
     */
    public static final String propertyType = "ForwardIndexProperty";

    /**
     * The number of hits
     */
    private int nrOfHits = 0;

    /**
     * Constructor.
     */
    public PropertyElementForwardIndex() {
        super();
    }

    /**
     * Constructor.
     * @param nrOfHits - the number of hits.
     * @throws Exception  - from the super class.
     */
    public PropertyElementForwardIndex(int nrOfHits) throws Exception{
        super();
        this.nrOfHits = nrOfHits;
        setType(PropertyElementForwardIndex.propertyType);
    }

    /**
     * Method to get the element from the XML formatted string.
     * @param element - the element to  format
     * @throws Exception - when the element can not be formatted.
     */
    public void fromXML(String element) throws Exception {
        try {
            String regex = "^<lookup\\s+numberofHits=\"(\\d*)\"\\s*/>$";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(element.trim());
            nrOfHits = Integer.parseInt(m.group(1));
        }
        catch (Exception e) {
            throw new Exception("invalid argument (xml)", e);
        }
    }

    /**
     * Method to get the number of hits.
     * @return XML formatted string with the number of hits.
     */
    public String toXML() {
        return "<lookup numberofHits=\"" + nrOfHits +  "\"/>";
    }

}
