package org.gcube.indexmanagement.featureindexlibrary.commons;

/**
 * Element used to store records in heap
 * 
 * @author UoA
 */
public class HeapElement {
	/**
	 * The number of th record
	 */
	private long recNum=0;
	/**
	 * The lower bound
	 */
	private float lBound=0;
	
	/**
	 * Creates a new instance
	 * 
	 * @param recNum The record number
	 * @param lBound The lower bound
	 */
	public HeapElement(long recNum,float lBound){
		this.recNum=recNum;
		this.lBound=lBound;
	}

	/**
	 * Retrieves the lower bound
	 * 
	 * @return The lower bound
	 */
	public float getLBound() {
		return lBound;
	}

	/**
	 * Sets the lower bound
	 * 
	 * @param bound The lower bound
	 */
	public void setLBound(float bound) {
		lBound = bound;
	}

	/**
	 * Retrieves the record number
	 * 
	 * @return The record number
	 */
	public long getRecNum() {
		return recNum;
	}

	/**
	 * Sets the record number
	 * 
	 * @param recNum The record number
	 */
	public void setRecNum(long recNum) {
		this.recNum = recNum;
	}
}
