/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.common;

public class ForwardIndexField {
    public String name;
    public int size;
    public DataType dataType;
    public String dataTypeFormat;

    public ForwardIndexField() {
    }

    public ForwardIndexField(String name, DataType dataType) {
        this.name = name;
        this.dataType = dataType;
        this.size = dataType.getDefaultSize();
    }

    public ForwardIndexField(String name, int stringDataTypeSize) {
        this.name = name;
        this.dataType = DataType.STRING;
        this.size = stringDataTypeSize;
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public String getDataTypeFormat() {
        return this.dataTypeFormat;
    }

    public String toString() {
        return this.name + "( dataType=" + (Object)((Object)this.dataType) + " class=" + this.dataType.getTypeClass().getName() + " size=" + this.size + " )";
    }

    public static enum DataType {
        INT(Integer.class, 4),
        DATE(Long.class, 8),
        FLOAT(Float.class, 4),
        STRING(String.class, 40);

        private final Class typeClass;
        private final int defaultSize;

        private DataType(Class typeClass, int defaultSize) {
            this.typeClass = typeClass;
            this.defaultSize = defaultSize;
        }

        public static DataType getByName(String name) throws Exception {
            for (DataType type : DataType.values()) {
                if (!name.equalsIgnoreCase(type.toString())) continue;
                return type;
            }
            throw new Exception("specified DataTypeName does not match any DataTypes: \"" + name + "\"");
        }

        public Class getTypeClass() {
            return this.typeClass;
        }

        public int getDefaultSize() {
            return this.defaultSize;
        }
    }
}

