/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.textextractor.extractors;

import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class InformationExtractor {
    public static final String idxType = "SmartfishFT";
    public static final String autocompleteIDXType = "SmartfishAutocompleteFT";
    public static final String collectionID = "faoCollection";
    public static final String autocompleteCollectionID = "faoAutocompleteCollection";

    public abstract String convertInfoToRowset(Map<String, String> var1);

    public abstract Map<String, String> extractFieldsFromFile(String var1) throws Exception;

    public abstract Map<String, String> enrichRecord(Map<String, String> var1, String var2);

    public abstract List<Map<String, String>> extractInfo(String var1) throws FileNotFoundException;

    public void extractInfoAndWriteToFile(String path, String outputFilename) throws IOException {
        try (FileWriter fw = new FileWriter(new File(outputFilename), true);){
            for (Map<String, String> info : this.extractInfo(path)) {
                String rowset = this.convertInfoToRowset(info);
                fw.write(rowset);
            }
            fw.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void extractInfoAndWriteToRS(String path, RecordWriter<GenericRecord> writer) throws GRS2WriterException, FileNotFoundException {
        for (Map<String, String> info : this.extractInfo(path)) {
            String rowset = this.convertInfoToRowset(info);
            GenericRecord rec = new GenericRecord();
            rec.setFields(new Field[]{new StringField(rowset.toString())});
            writer.put((Record)rec, 2L, TimeUnit.MINUTES);
        }
    }
}

