/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.textextractor.extractors;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.gcube.semantic.annotator.AnnotationBase;
import org.gcube.semantic.annotator.utils.ANNOTATIONS;
import org.gcube.textextractor.entities.ShortenCE4NameResponse;
import org.gcube.textextractor.extractors.InformationExtractor;
import org.gcube.textextractor.helpers.ExtractorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTServiceExtractor
extends InformationExtractor {
    private static final Logger logger = LoggerFactory.getLogger(RESTServiceExtractor.class);
    private static Gson gson = new Gson();

    @Override
    public String convertInfoToRowset(Map<String, String> info) {
        String documentID = info.get("documentID");
        info.remove("documentID");
        return ExtractorHelper.createRowseFromFields(documentID, "faoCollection", "SmartfishFT", info.get("language"), info);
    }

    @Override
    public Map<String, String> extractFieldsFromFile(String filename) throws Exception {
        String docID = filename;
        List<IntermediateCriterionObj> intermediateCriteria = RESTServiceExtractor.getCriteria(filename);
        HashMap document = Maps.newHashMap();
        for (IntermediateCriterionObj intermediateCriterion : intermediateCriteria) {
            String fieldNamePrefix = RESTServiceExtractor.kebabCaseToSnakeCase(intermediateCriterion.criterionName);
            String criterionUrl = docID + "/criteria/" + String.valueOf(intermediateCriterion.criterionId);
            CriterionObj criterion = RESTServiceExtractor.getCriterionValues(criterionUrl);
            for (ValueObj value : criterion.values) {
                String frLabelName = fieldNamePrefix + "_" + "frLabel";
                String frLabelValue = value.frLabel;
                String enLabelName = fieldNamePrefix + "_" + "enLabel";
                String enLabelValue = value.enLabel;
                String enDescriptionName = fieldNamePrefix + "_" + "enDescription";
                String enDescriptionValue = value.enDescription;
                String frDescriptionName = fieldNamePrefix + "_" + "frDescription";
                String frDescriptionValue = value.frDescription;
                document.put("documentID", docID);
                document.put(enLabelName, enLabelValue);
                document.put(frLabelName, frLabelValue);
                document.put(enDescriptionName, enDescriptionValue);
                document.put(frDescriptionName, frDescriptionValue);
            }
            System.out.println(criterion.values);
            System.out.println("doc : " + document);
        }
        return document;
    }

    @Override
    public Map<String, String> enrichRecord(Map<String, String> record, String filename) {
        HashMap enrichedRecord = Maps.newHashMap();
        HashMap uris = Maps.newHashMap();
        String docURI = filename;
        enrichedRecord.put("documentID", docURI);
        enrichedRecord.putAll(record);
        ExtractorHelper.enrichSimpleField(record, enrichedRecord, uris, ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#country"), new ExtractorHelper.QueryWrapperSimple(){

            @Override
            public String doCall(String arg) throws Exception {
                return ExtractorHelper.queryCountry(arg);
            }
        });
        try {
            String speciesURIJson = null;
            if (record.get("species_english_name") != null && record.get("species_english_name").trim().length() > 0) {
                speciesURIJson = ExtractorHelper.querySpecies(ExtractorHelper.covertToStringList(record.get("species_english_name")));
                uris.put("species_uris", ShortenCE4NameResponse.getURIFromJSON(speciesURIJson));
                enrichedRecord.put("species_uris", speciesURIJson);
            }
        }
        catch (Exception e) {
            logger.warn("Error processing species : " + record.get("species_english_name"), (Throwable)e);
        }
        try {
            this.annotate(docURI, uris);
        }
        catch (FileNotFoundException ex) {
            logger.error("file : " + filename + " not found", (Throwable)ex);
        }
        return enrichedRecord;
    }

    static List<String> getDocumentUrls(String path) throws Exception {
        ArrayList documentUrls = Lists.newArrayList();
        List<String> countriesIds = RESTServiceExtractor.getCountriesIds(path);
        for (String countryId : countriesIds) {
            try {
                String tableUrl = RESTServiceExtractor.createUrlForTablesQueries(path, countryId);
                System.out.println("getting tables for url : " + tableUrl);
                List<String> tablesIds = RESTServiceExtractor.getTablesIds(tableUrl);
                for (String tableId : tablesIds) {
                    System.out.println("tables : " + tablesIds);
                    String tableDataUrl = RESTServiceExtractor.createUrlForTableDataQueries(path, countryId, tableId);
                    System.out.println("tableID : " + tableDataUrl);
                    documentUrls.add(tableDataUrl);
                }
            }
            catch (Exception e) {
            }
        }
        return documentUrls;
    }

    @Override
    public List<Map<String, String>> extractInfo(String path) throws FileNotFoundException {
        List<String> documentUrls;
        int cnt = 0;
        try {
            documentUrls = RESTServiceExtractor.getDocumentUrls(path);
        }
        catch (Exception e) {
            return Lists.newArrayList();
        }
        ArrayList extractedInfo = Lists.newArrayList();
        for (String documentUrl : documentUrls) {
            logger.info("Processing documentUrl : " + ++cnt + " " + documentUrl);
            try {
                Map<String, String> info = this.extractFieldsFromFile(documentUrl);
                long part_start_time = System.currentTimeMillis();
                Map<String, String> enriched = this.enrichRecord(info, documentUrl);
                long part_end_time = System.currentTimeMillis();
                logger.info("~> field enrichment time  : " + (double)(part_end_time - part_start_time) / 1000.0 + " secs");
                extractedInfo.add(enriched);
            }
            catch (Exception e) {
                logger.error("error while extracting info from : " + documentUrl + " . will skip this documentUrl", (Throwable)e);
            }
        }
        return extractedInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<CountryObj> getCountries(String url) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet request = new HttpGet(url);
        HttpResponse httpResponse = client.execute((HttpUriRequest)request);
        try (InputStream responseStream = httpResponse.getEntity().getContent();){
            List countries;
            Map resp = (Map)gson.fromJson((Reader)new InputStreamReader(responseStream), new TypeToken<Map<String, List<CountryObj>>>(){}.getType());
            List list = countries = (List)resp.get("countries");
            return list;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<IntermediateCriterionObj> getCriteria(String url) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet request = new HttpGet(url);
        HttpResponse httpResponse = client.execute((HttpUriRequest)request);
        try (InputStream responseStream = httpResponse.getEntity().getContent();){
            List<IntermediateCriterionObj> criteria;
            TableDataObj resp = (TableDataObj)gson.fromJson((Reader)new InputStreamReader(responseStream), new TypeToken<TableDataObj>(){}.getType());
            List<IntermediateCriterionObj> list = criteria = resp.criteria;
            return list;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static CriterionObj getCriterionValues(String url) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet request = new HttpGet(url);
        HttpResponse httpResponse = client.execute((HttpUriRequest)request);
        try (InputStream responseStream = httpResponse.getEntity().getContent();){
            CriterionObj resp;
            CriterionObj criterionObj = resp = (CriterionObj)gson.fromJson((Reader)new InputStreamReader(responseStream), new TypeToken<CriterionObj>(){}.getType());
            return criterionObj;
        }
    }

    static List<String> getCountriesIds(String url) throws Exception {
        List<CountryObj> countries = RESTServiceExtractor.getCountries(url);
        ArrayList ids = Lists.newArrayList();
        for (CountryObj country : countries) {
            ids.add(String.valueOf(country.id));
        }
        return ids;
    }

    static String createUrlForTablesQueries(String baseUrl, String id) {
        return baseUrl + "/" + id;
    }

    static List<String> createUrlsForTablesQueries(String baseUrl, List<String> ids) {
        ArrayList urls = Lists.newArrayList();
        for (String id : ids) {
            urls.add(baseUrl + "/" + id);
        }
        return urls;
    }

    static String createUrlForCriteriaQueries(String baseUrl, String countryID, String tableID, String criterionId) {
        return baseUrl + "/" + countryID + "/tables/" + tableID + "/criteria/" + criterionId;
    }

    static String createUrlForTableDataQueries(String baseUrl, String countryID, String tableID) {
        return baseUrl + "/" + countryID + "/tables/" + tableID;
    }

    static List<String> createUrlsForTableDataQueries(String baseUrl, String countryID, List<String> ids) {
        ArrayList urls = Lists.newArrayList();
        for (String id : ids) {
            urls.add(baseUrl + "/" + countryID + "/tables/" + id);
        }
        return urls;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<String> getTablesIds(String url) throws Exception {
        ArrayList<String> listings = new ArrayList<String>();
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet request = new HttpGet(url);
        HttpResponse httpResponse = client.execute((HttpUriRequest)request);
        try (InputStream responseStream = httpResponse.getEntity().getContent();){
            Map resp = (Map)gson.fromJson((Reader)new InputStreamReader(responseStream), new TypeToken<Map<String, Object>>(){}.getType());
            List listingObjs = (List)resp.get("listing");
            for (Map listing : listingObjs) {
                Double idStr = (double)((Double)listing.get("id"));
                Integer id = idStr.intValue();
                listings.add(String.valueOf(id));
            }
            ArrayList<String> arrayList = listings;
            return arrayList;
        }
    }

    public static void main(String[] args) throws Exception {
        RESTServiceExtractor ex = new RESTServiceExtractor();
        ex.extractInfo("http://statbase.pirogprod.info:8080/statbase/rest/country");
    }

    private void annotate(String filename, Map<String, List<String>> uris) throws FileNotFoundException {
        AnnotationBase annotator = AnnotationBase.getInstance();
        Set<Map.Entry<String, List<String>>> entrySet = uris.entrySet();
        for (Map.Entry<String, List<String>> entry : entrySet) {
            List<String> uris_;
            if (entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#country") + "_uris")) {
                uris_ = entry.getValue();
                for (String uri_ : uris_) {
                    annotator.STATBASE_country(filename, uri_);
                }
            }
            if (entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#species") + "_uris")) {
                uris_ = entry.getValue();
                for (String uri_ : uris_) {
                    annotator.STATBASE_species(filename, uri_);
                }
            }
            if (entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#gear") + "_uris")) {
                uris_ = entry.getValue();
                for (String uri_ : uris_) {
                    annotator.STATBASE_gear(filename, uri_);
                }
            }
            if (!entry.getKey().equals(ANNOTATIONS.getLocalName("http://www.fao.org/figis/onto/smartfish/annotation.owl#vessel") + "_uris")) continue;
            uris_ = entry.getValue();
            for (String uri_ : uris_) {
                annotator.STATBASE_vessel(filename, uri_);
            }
        }
    }

    static String kebabCaseToCamelCase(String str) {
        str = str.replace(" ", "-");
        List w = Splitter.on((String)"-").splitToList((CharSequence)str.toLowerCase());
        StringBuilder camelCase = new StringBuilder();
        camelCase.append((String)w.get(0));
        for (int i = 1; i < w.size(); ++i) {
            camelCase.append(RESTServiceExtractor.capitalizeFirst((String)w.get(i)));
        }
        return camelCase.toString();
    }

    static String kebabCaseToSnakeCase(String str) {
        str = str.toLowerCase().replace(" ", "-");
        return str;
    }

    static String capitalizeFirst(String input) {
        String output = input.substring(0, 1).toUpperCase() + input.substring(1);
        return output;
    }

    static class ValueObj
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Integer id;
        String name;
        String frLabel;
        String enLabel;
        String frDescription;
        String enDescription;

        public String toString() {
            return "ValueObj [id=" + this.id + ", name=" + this.name + ", frLabel=" + this.frLabel + ", enLabel=" + this.enLabel + ", frDescription=" + this.frDescription + ", enDescription=" + this.enDescription + "]";
        }
    }

    static class CriterionObj
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Integer tableId;
        String tableName;
        Integer criterionId;
        String criterionName;
        List<ValueObj> values;
    }

    static class IntermediateCriterionObj
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Integer countryID;
        String countryName;
        Integer criterionId;
        Integer nomenclatureId;
        String criterionName;
        String criterionColumnName;
        String frLabel;
        String enLabel;

        public String toString() {
            return "IntermediateCriterionObj [countryID=" + this.countryID + ", countryName=" + this.countryName + ", criterionId=" + this.criterionId + ", nomenclatureId=" + this.nomenclatureId + ", criterionName=" + this.criterionName + ", criterionColumnName=" + this.criterionColumnName + ", frLabel=" + this.frLabel + ", enLabel=" + this.enLabel + "]";
        }
    }

    static class TableDataObj
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String tableId;
        String tableName;
        String tableSQLName;
        List<IntermediateCriterionObj> criteria;

        TableDataObj() {
        }

        public String toString() {
            return "TableDataObj [tableID=" + this.tableId + ", tableName=" + this.tableName + ", tableSQLName=" + this.tableSQLName + ", criteria=" + this.criteria + "]";
        }
    }

    static class CountryObj
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Integer id;
        String name;

        public String toString() {
            return "CountryObj [id=" + this.id + ", name=" + this.name + "]";
        }
    }
}

