/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.gcube.textextractor.entities;

import java.security.NoSuchAlgorithmException;
import org.gcube.semantic.annotator.utils.MD5Generator;

/**
 *
 * @author Claudio Baldassarre <c.baldassarre@me.com>
 */
public class ExtractedEntity {
    public final String en_name;
    public final String fr_name;
    public String uri_localName = "";

    public ExtractedEntity(String en_name_, String fr_name_) throws Exception {
        this.en_name = en_name_ != null ?  en_name_.trim() : "";
        this.fr_name = fr_name_ != null ?  fr_name_.trim() : "";
        if(this.isEmpty())
            throw new Exception("Both labels are empty!");
        setLocalName();
    }
    
    @Override
    public String toString(){
        return "en name : "+this.en_name +", fr name : "+this.fr_name;
    }
    
    @Override
    public boolean equals(Object o){
         return ((ExtractedEntity)o).en_name.equals(this.en_name);
    }

    public boolean isEmpty() {
       return this.en_name.isEmpty()
               && this.fr_name.isEmpty();
    }

    private void setLocalName() throws NoSuchAlgorithmException {
       if(!this.en_name.isEmpty())
           this.uri_localName = MD5Generator.getMD5Sum(this.en_name);
       else
           this.uri_localName = MD5Generator.getMD5Sum(this.fr_name);
    }
    
}
