/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.textextractor.entities;

import java.security.NoSuchAlgorithmException;
import org.gcube.semantic.annotator.utils.MD5Generator;

public class ExtractedEntity {
    public final String en_name;
    public final String fr_name;
    public String uri_localName = "";

    public ExtractedEntity(String en_name_, String fr_name_) throws Exception {
        this.en_name = en_name_ != null ? this.normalize(en_name_.trim()) : "";
        String string = this.fr_name = fr_name_ != null ? this.normalize(fr_name_.trim()) : "";
        if (this.isEmpty()) {
            throw new Exception("Both labels are empty!");
        }
        this.setLocalName();
    }

    public String toString() {
        return "en name : " + this.en_name + ", fr name : " + this.fr_name;
    }

    public boolean equals(Object o) {
        return ((ExtractedEntity)o).en_name.equals(this.en_name);
    }

    public boolean isEmpty() {
        return this.en_name.isEmpty() && this.fr_name.isEmpty();
    }

    private void setLocalName() throws NoSuchAlgorithmException {
        this.uri_localName = !this.en_name.isEmpty() ? MD5Generator.getMD5Sum(this.en_name) : MD5Generator.getMD5Sum(this.fr_name);
    }

    private String normalize(String fr_name) {
        fr_name = fr_name.replaceAll("[\u00e8\u00e9\u00ea\u00eb]", "e");
        fr_name = fr_name.replaceAll("[\u00fb\u00f9]", "u");
        fr_name = fr_name.replaceAll("[\u00ef\u00ee]", "i");
        fr_name = fr_name.replaceAll("[\u00e0\u00e2]", "a");
        fr_name = fr_name.replaceAll("\u00d4", "o");
        fr_name = fr_name.replaceAll("\u00e7", "c");
        fr_name = fr_name.replaceAll("[\u00c8\u00c9\u00ca\u00cb]", "E");
        fr_name = fr_name.replaceAll("[\u00db\u00d9]", "U");
        fr_name = fr_name.replaceAll("[\u00cf\u00ce]", "I");
        fr_name = fr_name.replaceAll("[\u00c0\u00c2]", "A");
        fr_name = fr_name.replaceAll("\u00d4", "O");
        fr_name = fr_name.replaceAll("\u00c7", "C");
        return fr_name;
    }
}

