package org.gcube.informationsystem.model.entity.facet;

import org.gcube.informationsystem.model.annotations.ISProperty;
import org.gcube.informationsystem.model.entity.Facet;

/**
 * A facet with a name property.
 *  
 * @author Manuele Simi (ISTI CNR)
 *
 */
public interface NamedFacet extends Facet {

	public static final String NAME_PROPERTY = "name";

	/**
	 * Gets the name of the facet.
	 * @return the name
	 */
	@ISProperty(name=NAME_PROPERTY, mandatory=true, nullable=false)
	public String getName();

	/**
	 * Sets the name of the facet.
	 * @param name the new name
	 */
	public void setName(String name);	

}
