/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.icproxy.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="GCoreEndpoint")
@Api(value="GCoreEndpoint", authorizations={@Authorization(value="gcube-token-query"), @Authorization(value="gcube-token-header")})
public class GCoreEndpointResource {
    private static final Logger log = LoggerFactory.getLogger(GCoreEndpointResource.class);

    @GET
    @Path(value="/{class}{name:(/[^/?$]+)?}")
    @Produces(value={"text/xml"})
    @ApiOperation(value="Retrieve a GCoreEndpoint by specifying service class and service name within the path.", response=String.class, notes="Retrieve a GCoreEndPoint given the service class and service name information. For example: /icproxy/gcube/service/GCoreEndpoint/InformationSystem/ICProxy retrieves the GCoreEndpoint having service class InformationSystem and service name ICProxy", nickname="get-gcore-endpoint")
    @ApiResponses(value={@ApiResponse(code=200, message="The resource (in xml format) is returned.", response=String.class), @ApiResponse(code=400, message="The error is specified in the body of the response message", response=String.class)})
    public String retrieveCustom(@NotNull @PathParam(value="class") String serviceClass, @PathParam(value="name") String serviceName, @ApiParam(required=false, name="result", value="An XPath filter to be applied to the search query.") @QueryParam(value="result") String resultXPath) {
        try {
            String scope = ScopeProvider.instance.get();
            log.info("gcoreendpoint wuth result called with serviceclass {} and servicename {} and result {} in scope {}", new Object[]{serviceClass, serviceName, resultXPath, scope});
            SimpleQuery query = this.createClassQuery(serviceClass);
            if (serviceName != null && !serviceName.isEmpty()) {
                serviceName = serviceName.replace("/", "");
                query.addCondition(String.format("$resource/Profile/ServiceName/text() eq '%s'", serviceName));
            }
            if (resultXPath != null && !resultXPath.isEmpty()) {
                if (resultXPath.startsWith("/")) {
                    query.setResult("$resource" + resultXPath);
                } else {
                    query.setResult("$resource/" + resultXPath);
                }
            }
            DiscoveryClient client = ICFactory.client();
            List endpoints = client.submit((Query)query);
            StringBuilder builder = new StringBuilder("<Results>");
            for (String single : endpoints) {
                builder.append("<Result>").append(single.replaceAll("\n", "")).append("</Result>");
            }
            builder.append("</Results>");
            log.debug("retrieved resources are " + endpoints.size());
            return builder.toString();
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error : " + e.getMessage())).type("text/plain").build());
        }
    }

    SimpleQuery createClassQuery(String serviceClass) {
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition(String.format("$resource/Profile/ServiceClass/text() eq '%s'", serviceClass));
        query.addCondition("$resource/Profile/DeploymentData/Status/text() eq 'ready'");
        return query;
    }
}

