/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.icproxy.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="ServiceEndpoint")
@Api(value="ServiceEndpoint", authorizations={@Authorization(value="gcube-token-query"), @Authorization(value="gcube-token-header")})
public class ServiceEndpointResource {
    private static final Logger log = LoggerFactory.getLogger(ServiceEndpointResource.class);

    @GET
    @Path(value="/{category}/{name}")
    @Produces(value={"application/xml"})
    @ApiOperation(value="Retrieve a Service Endpoint by specifying the category and the name within the path", response=String.class, notes="Retrieve a Service Endpoint by specifying the category and the name within the path. For example: /icproxy/gcube/service/ServiceEndpoint/Portal/SocialNetworking retrieves the Service Endpoint having category Portal and name SocialNetworking.", nickname="get-service-endpoint-by-category-and-name")
    public List<ServiceEndpoint> retrieve(@NotNull @PathParam(value="name") String resourceName, @NotNull @PathParam(value="category") String resourceCategory) {
        log.info("ServiceEndpoint called with category {} and name {} in scope {}", new Object[]{resourceCategory, resourceName, ScopeProvider.instance.get()});
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List endpoints = client.submit((Query)this.getQuery(resourceName, resourceCategory));
        log.debug("retrieved resources are " + endpoints.size());
        return endpoints;
    }

    private SimpleQuery getQuery(String resourceName, String resourceCategory) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition(String.format("$resource/Profile/Name/text() eq '%s'", resourceName));
        query.addCondition(String.format("$resource/Profile/Category/text() eq '%s'", resourceCategory));
        return query;
    }
}

