/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.icproxy.resources;

import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.keycloak.model.ModelUtils;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="ServiceEndpoint")
public class ServiceEndpointResource {
    private static final Logger log = LoggerFactory.getLogger(ServiceEndpointResource.class);

    @GET
    @Path(value="/{category}")
    @Produces(value={"application/xml"})
    public List<ServiceEndpoint> retrieve(@NotNull @PathParam(value="category") String resourceCategory) {
        log.info("ServiceEndpoint called with category {} in context {}", (Object)resourceCategory, (Object)ScopeProvider.instance.get());
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List endpoints = client.submit((Query)this.getQuery(resourceCategory));
        log.debug("retrieved resources are " + endpoints.size());
        return endpoints;
    }

    @GET
    @Path(value="/{category}/{name}")
    @Produces(value={"application/xml"})
    public List<ServiceEndpoint> retrieve(@NotNull @PathParam(value="name") String resourceName, @NotNull @PathParam(value="category") String resourceCategory, @QueryParam(value="decrypt") boolean isDecrypt) {
        log.info("ServiceEndpoint called with category {} and name {} in scope {}", new Object[]{resourceCategory, resourceName, ScopeProvider.instance.get()});
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List endpoints = client.submit((Query)this.getQuery(resourceName, resourceCategory));
        if (Objects.nonNull(endpoints)) {
            log.debug("retrieved resources are " + endpoints.size());
            if (isDecrypt) {
                if (this.isRoleEnabled()) {
                    ArrayList<ServiceEndpoint> ses = new ArrayList<ServiceEndpoint>(endpoints.size());
                    for (ServiceEndpoint resource : endpoints) {
                        ses.add(this.decryptResource(resource));
                    }
                    return ses;
                }
                log.info("user not enabled to see the resource free to air, sorry");
            }
        }
        return endpoints;
    }

    private boolean isRoleEnabled() {
        String at = AccessTokenProvider.instance.get();
        try {
            if (ModelUtils.getAccessTokenFrom((String)at).getRealmAccess().getRoles().contains("service-endpoint-key")) {
                log.info("The client is authorized to see the resource as 'free-to-air'");
                return true;
            }
        }
        catch (Exception e) {
            log.error("token not retrieved properly: " + e.getMessage());
            e.printStackTrace();
        }
        log.info("user not authorized, sorry");
        return false;
    }

    @GET
    @Path(value="/{category}/{name}/Result/{result:([^$\\?]+)}")
    @Produces(value={"text/xml"})
    public String retrieveCustom(@NotNull @PathParam(value="name") String resourceName, @NotNull @PathParam(value="category") String resourceCategory, @NotNull @PathParam(value="result") String resultXPath) {
        log.info("ServiceEndpoint called with category {} and name {} and result {} in scope {}", new Object[]{resourceCategory, resourceName, resultXPath, ScopeProvider.instance.get()});
        SimpleQuery query = this.getQuery(resourceName, resourceCategory);
        if (resultXPath.startsWith("/")) {
            query.setResult("$resource" + resultXPath);
        } else {
            query.setResult("$resource/" + resultXPath);
        }
        DiscoveryClient client = ICFactory.client();
        List endpoints = client.submit((Query)query);
        StringBuilder builder = new StringBuilder("<Results>");
        for (String single : endpoints) {
            builder.append("<Result>").append(single.replaceAll("\n", "")).append("</Result>");
        }
        builder.append("</Results>");
        log.debug("retrieved resources are " + endpoints.size());
        return builder.toString();
    }

    private SimpleQuery getQuery(String resourceName, String resourceCategory) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition(String.format("$resource/Profile/Name/text() eq '%s'", resourceName));
        query.addCondition(String.format("$resource/Profile/Category/text() eq '%s'", resourceCategory));
        return query;
    }

    private SimpleQuery getQuery(String resourceCategory) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition(String.format("$resource/Profile/Category/text() eq '%s'", resourceCategory));
        return query;
    }

    private ServiceEndpoint decryptResource(ServiceEndpoint resource) {
        Group aps = resource.profile().accessPoints();
        for (ServiceEndpoint.AccessPoint ap : aps) {
            String decrypted = ServiceEndpointResource.decryptString((String)ap.password());
            String user = ap.username();
            ap.credentials(decrypted, user);
        }
        return resource;
    }

    public static String decryptString(String toDecrypt) {
        try {
            return StringEncrypter.getEncrypter().decrypt(toDecrypt, new Key[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to decrypt : " + toDecrypt, e);
        }
    }
}

