/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.sweeper;

import java.util.Calendar;
import java.util.List;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.utils.DateFormatterAdapter;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sweeper {
    private static final Logger logger = LoggerFactory.getLogger(Sweeper.class);
    protected RegistryPublisher registryPublisher = RegistryPublisherFactory.create();
    protected DateFormatterAdapter dateFormatterAdapter = new DateFormatterAdapter();
    protected static final String UNREACHABLE = "unreachable";
    protected static final String CERTIFIED = "certified";

    protected String getHostingNodeMinimalInfo(HostingNode hostingNode) throws Exception {
        Calendar lastUpdate = hostingNode.profile().description().lastUpdate();
        return String.format("%s (ID : %s - Name : %s - Status : %s - LastUpdate : %s)", HostingNode.class.getSimpleName(), hostingNode.id(), hostingNode.profile().description().name(), hostingNode.profile().description().status(), this.dateFormatterAdapter.marshal(lastUpdate));
    }

    protected String getGCoreEndpointMinimalInfo(GCoreEndpoint gCoreEndpoint, HostingNode hostingNode) throws Exception {
        return String.format("%s (ID : %s - ServiceClass : %s - ServiceName : %s. Was running on %s)", GCoreEndpoint.class.getSimpleName(), gCoreEndpoint.id(), gCoreEndpoint.profile().serviceClass(), gCoreEndpoint.profile().serviceName(), this.getHostingNodeMinimalInfo(hostingNode));
    }

    public void sweepExpiredGHNs(int expiringField, int expiringQuantity) throws Exception {
        Calendar expiryCalendar = Calendar.getInstance();
        expiryCalendar.add(expiringField, expiringQuantity);
        String formattedDate = this.dateFormatterAdapter.marshal(expiryCalendar);
        String condition = String.format("xs:dateTime($resource/Profile/GHNDescription/LastUpdate/text()) lt xs:dateTime('%s')", formattedDate);
        XQuery query = ICFactory.queryFor(HostingNode.class).addCondition(String.format("$resource/Profile/GHNDescription/Status/text() eq '%s'", CERTIFIED)).addCondition(condition).setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(HostingNode.class);
        List hostingNodes = client.submit((Query)query);
        for (HostingNode hostingNode : hostingNodes) {
            try {
                logger.debug("Setting {} status to {}", (Object)this.getHostingNodeMinimalInfo(hostingNode), (Object)UNREACHABLE);
                hostingNode.profile().description().status(UNREACHABLE);
                this.registryPublisher.update((Resource)hostingNode);
                logger.debug("Request to set status to {} for {} successfully sent\n", (Object)UNREACHABLE, (Object)this.getHostingNodeMinimalInfo(hostingNode));
            }
            catch (Exception e) {
                logger.error("Unable to set status to {} for {}", new Object[]{UNREACHABLE, this.getHostingNodeMinimalInfo(hostingNode), e});
            }
        }
    }

    public void sweepDeadGHNs(int deadField, int deadQuantity) throws Exception {
        Calendar deadCalendar = Calendar.getInstance();
        deadCalendar.add(deadField, deadQuantity);
        String formattedDate = this.dateFormatterAdapter.marshal(deadCalendar);
        String condition = String.format("xs:dateTime($resource/Profile/GHNDescription/LastUpdate/text()) lt xs:dateTime('%s')", formattedDate);
        XQuery query = ICFactory.queryFor(HostingNode.class).addCondition(condition).setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(HostingNode.class);
        List hostingNodes = client.submit((Query)query);
        for (HostingNode hostingNode : hostingNodes) {
            try {
                logger.debug("Going to remove dead {}", (Object)this.getHostingNodeMinimalInfo(hostingNode));
                this.registryPublisher.remove((Resource)hostingNode);
                logger.debug("Request to remove {} successfully sent\n", (Object)this.getHostingNodeMinimalInfo(hostingNode));
            }
            catch (Exception e) {
                logger.error("Unable to remove {}", (Object)this.getHostingNodeMinimalInfo(hostingNode), (Object)e);
            }
        }
    }

    public void sweepOrphanRI() throws Exception {
        XQuery hostingNodeQuery = ICFactory.queryFor(HostingNode.class).addCondition(String.format("$resource/Profile/GHNDescription/Status/text() ne '%s'", CERTIFIED)).setResult("$resource");
        DiscoveryClient hostingNodeClient = ICFactory.clientFor(HostingNode.class);
        List hostingNodes = hostingNodeClient.submit((Query)hostingNodeQuery);
        for (HostingNode hostingNode : hostingNodes) {
            String condition = String.format("$resource/Profile/GHN/@UniqueID/string() eq '%s'", hostingNode.id());
            XQuery query = ICFactory.queryFor(GCoreEndpoint.class).addCondition(condition).setResult("$resource");
            DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
            List gCoreEndpoints = client.submit((Query)query);
            for (GCoreEndpoint gCoreEndpoint : gCoreEndpoints) {
                try {
                    logger.debug("Going to remove orphan {}", (Object)this.getGCoreEndpointMinimalInfo(gCoreEndpoint, hostingNode));
                    this.registryPublisher.remove((Resource)gCoreEndpoint);
                    logger.debug("Request to remove {} successfully sent\n", (Object)this.getGCoreEndpointMinimalInfo(gCoreEndpoint, hostingNode));
                }
                catch (Exception e) {
                    logger.error("Unable to remove {}", (Object)this.getGCoreEndpointMinimalInfo(gCoreEndpoint, hostingNode), (Object)e);
                }
            }
        }
    }
}

