/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resource_checker.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.gcube.informationsystem.resource_checker.utils.BasicFunctionalityBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicFunctionalitiesMandatoryReader {
    private static Logger logger = LoggerFactory.getLogger(BasicFunctionalitiesMandatoryReader.class);
    private List<BasicFunctionalityBean> mandatoryFunctionalities = null;
    private static final String FILE_PROPRETIES_LOCATION_PATH = "/META-INF/plugin_resources/resources_to_fetch.properties";
    private static final String SERVICE_NAME_KEY = "ServiceNames";
    private static final String CATEGORY_NAME_KEY = "CategoryNames";
    private static final String TYPES = "Types";
    private static final String SEPARATOR = ",";

    public BasicFunctionalitiesMandatoryReader() throws Exception {
        this.readFromLocalFile();
    }

    private void readFromLocalFile() throws Exception {
        Properties prop = new Properties();
        prop.load(this.getClass().getResourceAsStream(FILE_PROPRETIES_LOCATION_PATH));
        String serviceNames = prop.getProperty(SERVICE_NAME_KEY);
        String serviceCategories = prop.getProperty(CATEGORY_NAME_KEY);
        String types = prop.getProperty(TYPES);
        if (serviceNames == null || serviceCategories == null) {
            throw new Exception("Service names or categories are missing in file /META-INF/plugin_resources/resources_to_fetch.properties");
        }
        String[] serviceNamesSplitted = serviceNames.split(SEPARATOR);
        String[] serviceCategoriesSplitted = serviceCategories.split(SEPARATOR);
        String[] typesSplitted = null;
        if (types != null) {
            typesSplitted = types.split(SEPARATOR);
        }
        if (serviceNamesSplitted.length != serviceCategoriesSplitted.length) {
            throw new Exception("The file at /META-INF/plugin_resources/resources_to_fetch.properties seems to be malformed (service names and categories number do not match)!");
        }
        if (typesSplitted != null && serviceNamesSplitted.length != typesSplitted.length) {
            throw new Exception("The file at /META-INF/plugin_resources/resources_to_fetch.properties seems to be malformed (types lenght doesn't match the other properties)!");
        }
        this.mandatoryFunctionalities = new ArrayList<BasicFunctionalityBean>();
        int i = 0;
        while (i < serviceCategoriesSplitted.length) {
            this.mandatoryFunctionalities.add(new BasicFunctionalityBean(serviceCategoriesSplitted[i], serviceNamesSplitted[i], typesSplitted != null ? typesSplitted[i] : null));
            ++i;
        }
        logger.info("Built list is " + this.mandatoryFunctionalities);
    }

    public List<BasicFunctionalityBean> getMandatoryFunctionalities() {
        return this.mandatoryFunctionalities;
    }
}

