/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.api.contexts;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.core.JsonParseException;
import org.gcube.com.fasterxml.jackson.databind.JavaType;
import org.gcube.com.fasterxml.jackson.databind.JsonMappingException;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.type.MapType;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCache;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextUtility {
    private static Logger logger = LoggerFactory.getLogger(ContextUtility.class);

    public static Map<UUID, String> getContextMap(String objectnode) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = ElementMapper.getObjectMapper();
        MapType type = mapper.getTypeFactory().constructMapType(HashMap.class, UUID.class, String.class);
        return (Map)mapper.readValue(objectnode, (JavaType)type);
    }

    public static Set<UUID> getContextUUIDSet(Collection<String> uuidStrings) throws Exception {
        HashSet<UUID> uuids = new HashSet<UUID>();
        for (String uuidString : uuidStrings) {
            UUID uuid = UUID.fromString(uuidString);
            uuids.add(uuid);
        }
        return uuids;
    }

    public static Set<String> getContextFullNameSet(Collection<UUID> uuids) throws Exception {
        ContextCache contextCache = ContextCache.getInstance();
        HashSet<String> contextFullNames = new HashSet<String>();
        try {
            Map<UUID, String> uuidToContextFullNameAssociation = contextCache.getUUIDToContextFullNameAssociation();
            if (!uuidToContextFullNameAssociation.keySet().containsAll(uuids)) {
                logger.debug("{} does not contain all the contexts identified by the following UUID list. Trying to invalidate the cache", (Object)ContextCache.class.getSimpleName(), uuids);
                contextCache.cleanCache();
                uuidToContextFullNameAssociation = contextCache.getUUIDToContextFullNameAssociation();
            }
            for (UUID uuid : uuids) {
                String fullName = uuidToContextFullNameAssociation.get(uuid);
                if (fullName == null) {
                    throw new Exception("Unable to get the full name of context with UUID " + uuid.toString());
                }
                contextFullNames.add(fullName);
            }
        }
        catch (Exception e) {
            throw new Exception("Unable to convert Set<UUID> to Set<String> containing Context Full Name. Be sure the cache has been configured to retrieve the context list or provide a valid UUID list", e);
        }
        return contextFullNames;
    }
}

