/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.api.utils;

import java.io.IOException;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.gcube.informationsystem.types.TypeMapper;

public abstract class Utility {
    public static String getClassFromJsonNode(JsonNode jsonNode) {
        return jsonNode.get("@class").asText();
    }

    public static String getClassFromJsonString(String json) throws JsonProcessingException, IOException {
        JsonNode jsonNode = ElementMapper.getObjectMapper().readTree(json);
        return Utility.getClassFromJsonNode(jsonNode);
    }

    public static String getUUIDStringFromJsonNode(JsonNode jsonNode) {
        return jsonNode.get("header").get("@class").asText();
    }

    public static UUID getUUIDFromJsonNode(JsonNode jsonNode) {
        String uuidString = Utility.getUUIDStringFromJsonNode(jsonNode);
        return UUID.fromString(uuidString);
    }

    public static String getUUIDStringFromJsonString(String json) throws JsonProcessingException, IOException {
        JsonNode jsonNode = ElementMapper.getObjectMapper().readTree(json);
        return Utility.getUUIDStringFromJsonNode(jsonNode);
    }

    public static UUID getUUIDFromJsonString(String json) throws JsonProcessingException, IOException {
        JsonNode jsonNode = ElementMapper.getObjectMapper().readTree(json);
        return Utility.getUUIDFromJsonNode(jsonNode);
    }

    public static String getTypeName(Element element) {
        return Utility.getTypeName(element.getClass());
    }

    public static <E extends Element> String getTypeName(Class<E> clz) {
        if (!clz.isInterface()) {
            return clz.getAnnotation(JsonTypeName.class).value();
        }
        return TypeMapper.getType(clz);
    }
}

