package org.gcube.informationsystem.resourceregistry.api.exceptions.entities;

import java.io.Serial;


import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;

/**
 * The Class EntityAvailableInAnotherContextException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class EntityAvailableInAnotherContextException extends AvailableInAnotherContextException {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = 6169522499840275744L;

	/**
	 * Instantiates a new entity available in another context exception.
	 *
	 * @param message the message
	 */
	public EntityAvailableInAnotherContextException(String message) {
		super(message);
	}

	/**
	 * Instantiates a new entity available in another context exception.
	 *
	 * @param cause the cause
	 */
	public EntityAvailableInAnotherContextException(Throwable cause) {
		super(cause);
	}

	/**
	 * Instantiates a new entity available in another context exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public EntityAvailableInAnotherContextException(String message, Throwable cause) {
		super(message, cause);
	}
}
