/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.client;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.informationsystem.model.reference.ER;
import org.gcube.informationsystem.model.reference.ISManageable;
import org.gcube.informationsystem.model.reference.entities.Context;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.query.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.client.Direction;
import org.gcube.informationsystem.types.TypeBinder;

public interface ResourceRegistryClient {
    public <ERType extends ER> boolean exists(Class<ERType> var1, UUID var2) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException;

    public boolean exists(String var1, UUID var2) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException;

    public <ERType extends ER> ERType getInstance(Class<ERType> var1, UUID var2) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException;

    public String getInstance(String var1, UUID var2) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException;

    public <ERType extends ER, R extends Resource> List<R> getInstances(Class<ERType> var1, Boolean var2) throws ResourceRegistryException;

    public String getInstances(String var1, Boolean var2) throws ResourceRegistryException;

    public <R extends Resource, C extends ConsistsOf<?, ?>, F extends Facet> List<R> getResourcesFromReferenceFacet(Class<R> var1, Class<C> var2, Class<F> var3, F var4, boolean var5) throws ResourceRegistryException;

    public <R extends Resource, C extends ConsistsOf<?, ?>, F extends Facet> List<R> getResourcesFromReferenceFacet(Class<R> var1, Class<C> var2, Class<F> var3, UUID var4, boolean var5) throws ResourceRegistryException;

    public String getResourcesFromReferenceFacet(String var1, String var2, String var3, UUID var4, boolean var5) throws ResourceRegistryException;

    public <R extends Resource, C extends ConsistsOf<?, ?>, F extends Facet> List<R> getFilteredResources(Class<R> var1, Class<C> var2, Class<F> var3, boolean var4, Map<String, String> var5) throws ResourceRegistryException;

    public String getFilteredResources(String var1, String var2, String var3, boolean var4, Map<String, String> var5) throws ResourceRegistryException;

    public <R extends Resource, I extends IsRelatedTo<?, ?>, RR extends Resource> List<R> getRelatedResourcesFromReferenceResource(Class<R> var1, Class<I> var2, Class<RR> var3, RR var4, Direction var5, boolean var6) throws ResourceRegistryException;

    public <R extends Resource, I extends IsRelatedTo<?, ?>, RR extends Resource> List<R> getRelatedResourcesFromReferenceResource(Class<R> var1, Class<I> var2, Class<RR> var3, UUID var4, Direction var5, boolean var6) throws ResourceRegistryException;

    public String getRelatedResourcesFromReferenceResource(String var1, String var2, String var3, UUID var4, Direction var5, boolean var6) throws ResourceRegistryException;

    public <R extends Resource, I extends IsRelatedTo<?, ?>, RR extends Resource> List<R> getRelatedResources(Class<R> var1, Class<I> var2, Class<RR> var3, Direction var4, boolean var5) throws ResourceRegistryException;

    public String getRelatedResources(String var1, String var2, String var3, Direction var4, boolean var5) throws ResourceRegistryException;

    public String query(String var1, int var2, String var3) throws InvalidQueryException, ResourceRegistryException;

    public String query(String var1, int var2, String var3, boolean var4) throws InvalidQueryException, ResourceRegistryException;

    public <ISM extends ISManageable> List<TypeBinder.TypeDefinition> getSchema(Class<ISM> var1, Boolean var2) throws SchemaNotFoundException, ResourceRegistryException;

    public Context getContext(UUID var1) throws ContextNotFoundException, ResourceRegistryException;

    public Context getCurrentContext() throws ContextNotFoundException, ResourceRegistryException;

    public List<Context> getAllContext() throws ResourceRegistryException;
}

