/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.contexts;

import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.resourceregistry.api.rest.ServiceInstance;
import org.gcube.informationsystem.resourceregistry.contexts.ResourceRegistryContextClient;
import org.gcube.informationsystem.resourceregistry.contexts.ResourceRegistryContextClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryContextClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryContextClientFactory.class);

    public static String getCurrentContextFullName() {
        String token = SecurityTokenProvider.instance.get();
        AuthorizationEntry authorizationEntry = null;
        try {
            authorizationEntry = Constants.authorizationService().get(token);
        }
        catch (Exception e) {
            return ScopeProvider.instance.get();
        }
        return authorizationEntry.getContext();
    }

    public static ResourceRegistryContextClient create() {
        String address = String.format("%s/%s", ServiceInstance.getServiceURL(), "resource-registry");
        logger.trace("The {} will be contacted at {}", (Object)"resource-registry", (Object)address);
        return new ResourceRegistryContextClientImpl(address);
    }
}

