/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.publisher.proxy;

import java.io.StringWriter;
import java.util.UUID;
import javax.xml.ws.EndpointReference;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.clients.delegates.AsyncProxyDelegate;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.ServiceException;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.impl.utils.ISMapper;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsRelatedTo;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPCall;
import org.gcube.informationsystem.resourceregistry.publisher.proxy.ResourceRegistryPublisher;
import org.gcube.informationsystem.resourceregistry.publisher.proxy.ResourceRegistryPublisherCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryPublisherImpl
implements ResourceRegistryPublisher {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryPublisherImpl.class);
    private final AsyncProxyDelegate<EndpointReference> delegate;
    public static final String PATH_SEPARATOR = "/";

    public ResourceRegistryPublisherImpl(ProxyDelegate<EndpointReference> config) {
        this.delegate = new AsyncProxyDelegate(config);
    }

    private static String getCurrentContext() {
        String token = SecurityTokenProvider.instance.get();
        AuthorizationEntry authorizationEntry = null;
        try {
            authorizationEntry = Constants.authorizationService().get(token);
        }
        catch (Exception e) {
            return ScopeProvider.instance.get();
        }
        return authorizationEntry.getContext();
    }

    @Override
    public <F extends Facet> F createFacet(Class<F> facetClass, F facet) throws FacetAlreadyPresentException, ResourceRegistryException {
        try {
            logger.info("Going to create: {}", facet);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("facet");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(facetClass.getSimpleName());
            String body = ISMapper.marshal(facet);
            HTTPCall httpCall = new HTTPCall(stringWriter.toString(), HTTPCall.HTTPMETHOD.PUT, null, body);
            ResourceRegistryPublisherCall<F> call = new ResourceRegistryPublisherCall<F>(facetClass, httpCall);
            Facet f = (Facet)this.delegate.make(call);
            logger.info("{} successfully created", (Object)f);
            return (F)f;
        }
        catch (ResourceRegistryException e) {
            logger.error("Error Creating {}", facet, (Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Error Creating {}", facet, (Object)e);
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public <F extends Facet> F updateFacet(Class<F> facetClass, F facet) throws FacetNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to update: {}", facet);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("facet");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(facet.getHeader().getUUID().toString());
            String body = ISMapper.marshal(facet);
            HTTPCall httpCall = new HTTPCall(stringWriter.toString(), HTTPCall.HTTPMETHOD.POST, null, body);
            ResourceRegistryPublisherCall<F> call = new ResourceRegistryPublisherCall<F>(facetClass, httpCall);
            Facet f = (Facet)this.delegate.make(call);
            logger.info("{} successfully updated", (Object)f);
            return (F)f;
        }
        catch (ResourceRegistryException e) {
            logger.error("Error Updating {}", facet, (Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Error Updating {}", facet, (Object)e);
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public <F extends Facet> boolean deleteFacet(F facet) throws FacetNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to delete: {}", facet);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("facet");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(facet.getHeader().getUUID().toString());
            HTTPCall httpCall = new HTTPCall(stringWriter.toString(), HTTPCall.HTTPMETHOD.DELETE, null);
            ResourceRegistryPublisherCall<Boolean> call = new ResourceRegistryPublisherCall<Boolean>(Boolean.class, httpCall);
            boolean deleted = (Boolean)this.delegate.make(call);
            logger.info("{} {}", facet, (Object)(deleted ? " successfully deleted" : "was NOT deleted"));
            return deleted;
        }
        catch (ResourceRegistryException e) {
            logger.error("Error Removing {}", facet, (Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Error Removing {}", facet, (Object)e);
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public <R extends Resource> R createResource(Class<R> resourceClass, R resource) throws ResourceAlreadyPresentException, ResourceRegistryException {
        try {
            logger.info("Going to create: {}", resource);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("resource");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(resourceClass.getSimpleName());
            String body = ISMapper.marshal(resource);
            HTTPCall httpCall = new HTTPCall(stringWriter.toString(), HTTPCall.HTTPMETHOD.PUT, null, body);
            ResourceRegistryPublisherCall<R> call = new ResourceRegistryPublisherCall<R>(resourceClass, httpCall);
            Resource r = (Resource)this.delegate.make(call);
            logger.info("{} successfully created", (Object)r);
            return (R)r;
        }
        catch (ResourceRegistryException e) {
            logger.error("Error Creating {}", resource, (Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Error Creating {}", resource, (Object)e);
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public <R extends Resource> R updateResource(Class<R> resourceClass, R resource) throws ResourceNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to update: {}", resource);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("resource");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(resource.getHeader().getUUID().toString());
            String body = ISMapper.marshal(resource);
            HTTPCall httpCall = new HTTPCall(stringWriter.toString(), HTTPCall.HTTPMETHOD.POST, null, body);
            ResourceRegistryPublisherCall<R> call = new ResourceRegistryPublisherCall<R>(resourceClass, httpCall);
            Resource r = (Resource)this.delegate.make(call);
            logger.info("{} update created", (Object)r);
            return (R)r;
        }
        catch (ResourceRegistryException e) {
            logger.error("Error Creating {}", resource, (Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Error Creating {}", resource, (Object)e);
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public <R extends Resource> boolean deleteResource(R resource) throws ResourceNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to delete: {}", resource);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("resource");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(resource.getHeader().getUUID().toString());
            HTTPCall httpCall = new HTTPCall(stringWriter.toString(), HTTPCall.HTTPMETHOD.DELETE, null);
            ResourceRegistryPublisherCall<Boolean> call = new ResourceRegistryPublisherCall<Boolean>(Boolean.class, httpCall);
            boolean deleted = (Boolean)this.delegate.make(call);
            logger.info("{} {}", resource, (Object)(deleted ? " successfully deleted" : "was NOT deleted"));
            return deleted;
        }
        catch (ResourceRegistryException e) {
            logger.error("Error Removing {}", resource, (Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Error Removing {}", resource, (Object)e);
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C createConsistsOf(Class<C> consistsOfClass, C consistsOf) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to create: {}", consistsOf);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("consistsOf");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("source");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(((Resource)consistsOf.getSource()).getHeader().getUUID().toString());
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("target");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(((Facet)consistsOf.getTarget()).getHeader().getUUID().toString());
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(consistsOfClass.getSimpleName());
            String body = ISMapper.marshal(consistsOf);
            HTTPCall httpCall = new HTTPCall(stringWriter.toString(), HTTPCall.HTTPMETHOD.PUT, null, body);
            ResourceRegistryPublisherCall<C> call = new ResourceRegistryPublisherCall<C>(consistsOfClass, httpCall);
            ConsistsOf c = (ConsistsOf)this.delegate.make(call);
            logger.info("{} successfully created", (Object)c);
            return (C)c;
        }
        catch (ResourceRegistryException e) {
            logger.error("Error Creating {}", consistsOf, (Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Error Creating {}", consistsOf, (Object)e);
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> boolean deleteConsistsOf(C consistsOf) throws ResourceRegistryException {
        return this.deleteConsistsOf(consistsOf.getHeader().getUUID());
    }

    @Override
    public boolean deleteConsistsOf(UUID uuid) throws ResourceRegistryException {
        try {
            logger.info("Going to delete {} with UUID {}", (Object)"ConsistsOf", (Object)uuid);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("consistsOf");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = new HTTPCall(stringWriter.toString(), HTTPCall.HTTPMETHOD.DELETE, null);
            ResourceRegistryPublisherCall<Boolean> call = new ResourceRegistryPublisherCall<Boolean>(Boolean.class, httpCall);
            boolean deleted = (Boolean)this.delegate.make(call);
            logger.info("{} with UUID {} {}", new Object[]{"ConsistsOf", uuid, deleted ? " successfully deleted" : "was NOT deleted"});
            return deleted;
        }
        catch (ResourceRegistryException e) {
            logger.error("Error Removing {} with UUID {}", new Object[]{"ConsistsOf", uuid, e});
            throw e;
        }
        catch (Exception e) {
            logger.error("Error Removing {} with UUID {}", new Object[]{"ConsistsOf", uuid, e});
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I createIsRelatedTo(Class<I> isRelatedToClass, I isRelatedTo) throws ResourceNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to create: {}", isRelatedTo);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("isRelatedTo");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("source");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(((Resource)isRelatedTo.getSource()).getHeader().getUUID().toString());
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("target");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(((Resource)isRelatedTo.getTarget()).getHeader().getUUID().toString());
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(isRelatedToClass.getSimpleName());
            String body = ISMapper.marshal(isRelatedTo);
            HTTPCall httpCall = new HTTPCall(stringWriter.toString(), HTTPCall.HTTPMETHOD.PUT, null, body);
            ResourceRegistryPublisherCall<I> call = new ResourceRegistryPublisherCall<I>(isRelatedToClass, httpCall);
            IsRelatedTo i = (IsRelatedTo)this.delegate.make(call);
            logger.info("{} successfully created", (Object)i);
            return (I)i;
        }
        catch (ResourceRegistryException e) {
            logger.error("Error Creating {}", isRelatedTo, (Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Error Creating {}", isRelatedTo, (Object)e);
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> boolean deleteIsRelatedTo(I isRelatedTo) throws ResourceRegistryException {
        return this.deleteIsRelatedTo(isRelatedTo.getHeader().getUUID());
    }

    @Override
    public boolean deleteIsRelatedTo(UUID uuid) throws ResourceRegistryException {
        try {
            logger.info("Going to delete {} with UUID {}", (Object)"IsRelatedTo", (Object)uuid);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("isRelatedTo");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = new HTTPCall(stringWriter.toString(), HTTPCall.HTTPMETHOD.DELETE, null);
            ResourceRegistryPublisherCall<Boolean> call = new ResourceRegistryPublisherCall<Boolean>(Boolean.class, httpCall);
            boolean deleted = (Boolean)this.delegate.make(call);
            logger.info("{} with UUID {} {}", new Object[]{"IsRelatedTo", uuid, deleted ? " successfully deleted" : "was NOT deleted"});
            return deleted;
        }
        catch (ResourceRegistryException e) {
            logger.error("Error Removing {} with UUID {}", new Object[]{"IsRelatedTo", uuid, e});
            throw e;
        }
        catch (Exception e) {
            logger.error("Error Removing {} with UUID {}", new Object[]{"IsRelatedTo", uuid, e});
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public boolean addResourceToContext(UUID uuid) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        String context = ResourceRegistryPublisherImpl.getCurrentContext();
        try {
            logger.info("Going to add {} with UUID {} to current {} : {}", new Object[]{"Resource", uuid, "Context", context});
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("add");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("resource");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = new HTTPCall(stringWriter.toString(), HTTPCall.HTTPMETHOD.POST, null);
            ResourceRegistryPublisherCall<Boolean> call = new ResourceRegistryPublisherCall<Boolean>(Boolean.class, httpCall);
            boolean added = (Boolean)this.delegate.make(call);
            logger.info("{} with UUID {} was {} added to current {} : {}", new Object[]{"Resource", uuid, added ? "successfully" : "NOT", "Context", context});
            return added;
        }
        catch (ResourceRegistryException e) {
            logger.error("Error Adding {} with UUID {} to current {} : {}", new Object[]{"Resource", uuid, "Context", context, e});
            throw e;
        }
        catch (Exception e) {
            logger.error("Error Adding {} with UUID {} to current {} : {}", new Object[]{"Resource", uuid, "Context", context, e});
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public <R extends Resource> boolean addResourceToContext(R resource) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addResourceToContext(resource.getHeader().getUUID());
    }

    @Override
    public boolean addFacetToContext(UUID uuid) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        String context = ResourceRegistryPublisherImpl.getCurrentContext();
        try {
            logger.info("Going to add {} with UUID {} to current {} : {}", new Object[]{"Facet", uuid, "Context", context});
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("add");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("facet");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = new HTTPCall(stringWriter.toString(), HTTPCall.HTTPMETHOD.POST, null);
            ResourceRegistryPublisherCall<Boolean> call = new ResourceRegistryPublisherCall<Boolean>(Boolean.class, httpCall);
            boolean added = (Boolean)this.delegate.make(call);
            logger.info("{} with UUID {} was {} added to current {} : {}", new Object[]{"Facet", uuid, added ? "successfully" : "NOT", "Context", context});
            return added;
        }
        catch (ResourceRegistryException e) {
            logger.error("Error Adding {} with UUID {} to current {} : {}", new Object[]{"Facet", uuid, "Context", context, e});
            throw e;
        }
        catch (Exception e) {
            logger.error("Error Adding {} with UUID {} to current {} : {}", new Object[]{"Facet", uuid, "Context", context, e});
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public <F extends Facet> boolean addFacetToContext(F facet) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addFacetToContext(facet.getHeader().getUUID());
    }

    @Override
    public boolean removeResourceFromContext(UUID uuid) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        String context = ResourceRegistryPublisherImpl.getCurrentContext();
        try {
            logger.info("Going to add {} with UUID {} to current {} : {}", new Object[]{"Resource", uuid, "Context", context});
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("remove");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("resource");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = new HTTPCall(stringWriter.toString(), HTTPCall.HTTPMETHOD.POST, null);
            ResourceRegistryPublisherCall<Boolean> call = new ResourceRegistryPublisherCall<Boolean>(Boolean.class, httpCall);
            boolean removed = (Boolean)this.delegate.make(call);
            logger.info("{} with UUID {} was {} removed from current {} : {}", new Object[]{"Resource", uuid, removed ? "successfully" : "NOT", "Context", context});
            return removed;
        }
        catch (ResourceRegistryException e) {
            logger.error("Error Adding {} with UUID {} to current {} : {}", new Object[]{"Resource", uuid, "Context", context, e});
            throw e;
        }
        catch (Exception e) {
            logger.error("Error Adding {} with UUID {} to current {} : {}", new Object[]{"Resource", uuid, "Context", context, e});
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public <R extends Resource> boolean removeResourceFromContext(R resource) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeResourceFromContext(resource.getHeader().getUUID());
    }

    @Override
    public boolean removeFacetFromContext(UUID uuid) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        String context = ResourceRegistryPublisherImpl.getCurrentContext();
        try {
            logger.info("Going to add {} with UUID {} to current {} : {}", new Object[]{"Facet", uuid, "Context", context});
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("er");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("remove");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("facet");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPCall httpCall = new HTTPCall(stringWriter.toString(), HTTPCall.HTTPMETHOD.POST, null);
            ResourceRegistryPublisherCall<Boolean> call = new ResourceRegistryPublisherCall<Boolean>(Boolean.class, httpCall);
            boolean removed = (Boolean)this.delegate.make(call);
            logger.info("{} with UUID {} was {} removed from current {} : {}", new Object[]{"Facet", uuid, removed ? "successfully" : "NOT", "Context", context});
            return removed;
        }
        catch (ResourceRegistryException e) {
            logger.error("Error Adding {} with UUID {} to current {} : {}", new Object[]{"Facet", uuid, "Context", context, e});
            throw e;
        }
        catch (Exception e) {
            logger.error("Error Adding {} with UUID {} to current {} : {}", new Object[]{"Facet", uuid, "Context", context, e});
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public <F extends Facet> boolean removeFacetFromContext(F facet) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFacetFromContext(facet.getHeader().getUUID());
    }
}

