/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.publisher;

import java.net.HttpURLConnection;
import java.util.UUID;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.model.impl.properties.HeaderImpl;
import org.gcube.informationsystem.model.reference.ER;
import org.gcube.informationsystem.model.reference.ISManageable;
import org.gcube.informationsystem.model.reference.entities.Context;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPUtility;
import org.gcube.informationsystem.resourceregistry.api.utils.Utility;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisher;
import org.gcube.informationsystem.utils.ISMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryPublisherImpl
implements ResourceRegistryPublisher {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryPublisherImpl.class);
    protected final String address;

    public ResourceRegistryPublisherImpl(String address) {
        this.address = address;
    }

    private static String getCurrentContext() {
        String token = SecurityTokenProvider.instance.get();
        AuthorizationEntry authorizationEntry = null;
        try {
            authorizationEntry = Constants.authorizationService().get(token);
        }
        catch (Exception e) {
            return ScopeProvider.instance.get();
        }
        return authorizationEntry.getContext();
    }

    private UUID getCurrentContextUUID() throws ResourceRegistryException {
        logger.debug("Going to read current {} ({}) definition", (Object)"Context", (Object)ResourceRegistryPublisherImpl.getCurrentContext());
        try {
            logger.info("Going to get current {} ", (Object)"Context");
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryPublisher.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path("CURRENT_CONTEXT");
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            Context context = (Context)HTTPUtility.getResponse(Context.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got Context is {}", (Object)ISMapper.marshal((ISManageable)context));
            return context.getHeader().getUUID();
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String create(String erType, String er, UUID uuid) throws AlreadyPresentException, ResourceRegistryException {
        try {
            logger.trace("Going to create {} : {}", (Object)erType, (Object)er);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryPublisher.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.header("Content-type", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(erType);
            gxHTTPStringRequest.path(uuid.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put(er);
            String ret = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.trace("{} successfully created", (Object)ret);
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <E extends ER> String internalCreate(E er) throws AlreadyPresentException, ResourceRegistryException {
        try {
            String erType = Utility.getType(er);
            String erString = ISMapper.marshal(er);
            Header header = er.getHeader();
            if (header == null) {
                header = new HeaderImpl(UUID.randomUUID());
                er.setHeader(header);
            }
            UUID uuid = er.getHeader().getUUID();
            return this.create(erType, erString, uuid);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <E extends ER> E create(E er) throws AlreadyPresentException, ResourceRegistryException {
        try {
            String ret = this.internalCreate(er);
            return (E)((ER)ISMapper.unmarshal(ER.class, (String)ret));
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String create(String er) throws AlreadyPresentException, ResourceRegistryException {
        try {
            ER e = (ER)ISMapper.unmarshal(ER.class, (String)er);
            return this.internalCreate(e);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <E extends ER> E read(E er) throws NotFoundException, ResourceRegistryException {
        try {
            String erType = Utility.getType(er);
            UUID uuid = er.getHeader().getUUID();
            String ret = this.read(erType, uuid);
            return (E)((ER)ISMapper.unmarshal(ER.class, (String)ret));
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String read(String erType, UUID uuid) throws NotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to read {} with UUID {}", (Object)erType, (Object)uuid);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryPublisher.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(erType);
            gxHTTPStringRequest.path(uuid.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String ret = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got {} with UUID {} is {}", new Object[]{erType, uuid, ret});
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String update(String erType, String er, UUID uuid) throws AlreadyPresentException, ResourceRegistryException {
        try {
            logger.trace("Going to create {} : {}", (Object)erType, (Object)er);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryPublisher.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.header("Content-type", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(erType);
            gxHTTPStringRequest.path(uuid.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put(er);
            String ret = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.trace("{} with UUID {} successfully created : {}", new Object[]{erType, uuid, ret});
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <E extends ER> E update(E er) throws NotFoundException, ResourceRegistryException {
        try {
            String erType = Utility.getType(er);
            String erString = ISMapper.marshal(er);
            UUID uuid = er.getHeader().getUUID();
            String ret = this.update(erType, erString, uuid);
            return (E)((ER)ISMapper.unmarshal(ER.class, (String)ret));
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String update(String erType, String er) throws NotFoundException, ResourceRegistryException {
        try {
            UUID uuid = org.gcube.informationsystem.utils.Utility.getUUIDFromJSONString((String)er);
            return this.update(erType, er, uuid);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String update(String er) throws NotFoundException, ResourceRegistryException {
        try {
            String erType = Utility.getClassFromJsonString((String)er);
            return this.update(erType, er);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <E extends ER> boolean delete(E er) throws NotFoundException, ResourceRegistryException {
        try {
            String erType = Utility.getType(er);
            UUID uuid = er.getHeader().getUUID();
            return this.delete(erType, uuid);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean delete(String erType, UUID uuid) throws NotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to delete {} with UUID {}", (Object)erType, (Object)uuid);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryPublisher.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(erType);
            gxHTTPStringRequest.path(uuid.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.delete();
            HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            boolean deleted = true;
            logger.info("{} with UUID {} {}", new Object[]{erType, uuid, deleted ? " successfully deleted" : "was NOT deleted"});
            return deleted;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <F extends Facet> F createFacet(F facet) throws FacetAlreadyPresentException, ResourceRegistryException {
        return this.create((ER)facet);
    }

    @Override
    public String createFacet(String facet) throws FacetAlreadyPresentException, ResourceRegistryException {
        return this.create(facet);
    }

    @Override
    public <F extends Facet> F readFacet(F facet) throws FacetNotFoundException, ResourceRegistryException {
        return this.read((ER)facet);
    }

    @Override
    public String readFacet(String facetType, UUID uuid) throws FacetNotFoundException, ResourceRegistryException {
        return this.read(facetType, uuid);
    }

    @Override
    public <F extends Facet> F updateFacet(F facet) throws FacetNotFoundException, ResourceRegistryException {
        return this.update((ER)facet);
    }

    @Override
    public String updateFacet(String facet) throws FacetNotFoundException, ResourceRegistryException {
        return this.update(facet);
    }

    @Override
    public <F extends Facet> boolean deleteFacet(F facet) throws FacetNotFoundException, ResourceRegistryException {
        return this.delete((ER)facet);
    }

    @Override
    public boolean deleteFacet(String facetType, UUID uuid) throws FacetNotFoundException, ResourceRegistryException {
        return this.delete(facetType, uuid);
    }

    @Override
    public <R extends Resource> R createResource(R resource) throws ResourceAlreadyPresentException, ResourceRegistryException {
        return this.create((ER)resource);
    }

    @Override
    public String createResource(String resource) throws ResourceAlreadyPresentException, ResourceRegistryException {
        return this.create(resource);
    }

    @Override
    public <R extends Resource> R readResource(R resource) throws ResourceNotFoundException, ResourceRegistryException {
        return this.read((ER)resource);
    }

    @Override
    public String readResource(String resourceType, UUID uuid) throws ResourceNotFoundException, ResourceRegistryException {
        return this.read(resourceType, uuid);
    }

    @Override
    public <R extends Resource> R updateResource(R resource) throws ResourceNotFoundException, ResourceRegistryException {
        return this.update((ER)resource);
    }

    @Override
    public String updateResource(String resource) throws ResourceNotFoundException, ResourceRegistryException {
        return this.update(resource);
    }

    @Override
    public <R extends Resource> boolean deleteResource(R resource) throws ResourceNotFoundException, ResourceRegistryException {
        return this.delete((ER)resource);
    }

    @Override
    public boolean deleteResource(String resourceType, UUID uuid) throws ResourceNotFoundException, ResourceRegistryException {
        return this.delete(resourceType, uuid);
    }

    @Override
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C createConsistsOf(C consistsOf) throws NotFoundException, ResourceRegistryException {
        return this.create((ER)consistsOf);
    }

    @Override
    public String createConsistsOf(String consistsOf) throws NotFoundException, ResourceRegistryException {
        return this.create(consistsOf);
    }

    @Override
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C readConsistsOf(C consistsOf) throws NotFoundException, ResourceRegistryException {
        return this.read((ER)consistsOf);
    }

    @Override
    public String readConsistsOf(String consistsOfType, UUID uuid) throws NotFoundException, ResourceRegistryException {
        return this.read(consistsOfType, uuid);
    }

    @Override
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C updateConsistsOf(C consistsOf) throws NotFoundException, ResourceRegistryException {
        return this.update((ER)consistsOf);
    }

    @Override
    public String updateConsistsOf(String consistsOf) throws NotFoundException, ResourceRegistryException {
        return this.update(consistsOf);
    }

    @Override
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> boolean deleteConsistsOf(C consistsOf) throws ResourceRegistryException {
        return this.delete((ER)consistsOf);
    }

    @Override
    public boolean deleteConsistsOf(String consistsOfType, UUID uuid) throws ResourceRegistryException {
        return this.delete(consistsOfType, uuid);
    }

    @Override
    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I createIsRelatedTo(I isRelatedTo) throws ResourceNotFoundException, ResourceRegistryException {
        return this.create((ER)isRelatedTo);
    }

    @Override
    public String createIsRelatedTo(String isRelatedTo) throws ResourceNotFoundException, ResourceRegistryException {
        return this.create(isRelatedTo);
    }

    @Override
    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I readIsRelatedTo(I isRelatedTo) throws NotFoundException, ResourceRegistryException {
        return this.read((ER)isRelatedTo);
    }

    @Override
    public String readIsRelatedTo(String isRelatedToType, UUID uuid) throws NotFoundException, ResourceRegistryException {
        return this.read(isRelatedToType, uuid);
    }

    @Override
    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I updateIsRelatedTo(I isRelatedTo) throws NotFoundException, ResourceRegistryException {
        return this.update((ER)isRelatedTo);
    }

    @Override
    public String updateIsRelatedTo(String isRelatedTo) throws NotFoundException, ResourceRegistryException {
        return this.update(isRelatedTo);
    }

    @Override
    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> boolean deleteIsRelatedTo(I isRelatedTo) throws ResourceRegistryException {
        return this.delete((ER)isRelatedTo);
    }

    @Override
    public boolean deleteIsRelatedTo(String isRelatedToType, UUID uuid) throws ResourceRegistryException {
        return this.delete(isRelatedToType, uuid);
    }

    @Override
    public boolean addToContext(UUID contextUUID, String erType, UUID instanceUUID) throws NotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to add {} with UUID {} to {} with UUID {} ", new Object[]{erType, instanceUUID, "Context", contextUUID});
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryPublisher.class.getSimpleName());
            gxHTTPStringRequest.path("sharing");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(contextUUID.toString());
            gxHTTPStringRequest.path(erType);
            gxHTTPStringRequest.path(instanceUUID.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put();
            boolean added = (Boolean)HTTPUtility.getResponse(Boolean.class, (HttpURLConnection)httpURLConnection);
            logger.info("{} with UUID {} {} to {} with UUID {}", new Object[]{erType, instanceUUID, added ? " successfully added" : "was NOT added", "Context", contextUUID});
            return added;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <E extends ER> boolean addToContext(UUID contextUUID, E er) throws NotFoundException, ResourceRegistryException {
        try {
            String erType = Utility.getType(er);
            UUID instanceUUID = er.getHeader().getUUID();
            return this.addToContext(contextUUID, erType, instanceUUID);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean addToCurrentContext(String erType, UUID instanceUUID) throws NotFoundException, ResourceRegistryException {
        UUID contextUUID = this.getCurrentContextUUID();
        return this.addToContext(contextUUID, erType, instanceUUID);
    }

    @Override
    public <E extends ER> boolean addToCurrentContext(E er) throws NotFoundException, ResourceRegistryException {
        UUID contextUUID = this.getCurrentContextUUID();
        return this.addToContext(contextUUID, er);
    }

    @Override
    public boolean removeFromContext(UUID contextUUID, String erType, UUID instanceUUID) throws NotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to add {} with UUID {} to {} with UUID {} ", new Object[]{erType, instanceUUID, "Context", contextUUID});
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryPublisher.class.getSimpleName());
            gxHTTPStringRequest.path("sharing");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(contextUUID.toString());
            gxHTTPStringRequest.path(erType);
            gxHTTPStringRequest.path(instanceUUID.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.delete();
            boolean removed = (Boolean)HTTPUtility.getResponse(Boolean.class, (HttpURLConnection)httpURLConnection);
            logger.info("{} with UUID {} {} to {} with UUID {}", new Object[]{erType, instanceUUID, removed ? " successfully removed" : "was NOT removed", "Context", contextUUID});
            return removed;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <E extends ER> boolean removeFromContext(UUID contextUUID, E er) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        try {
            String erType = Utility.getType(er);
            UUID instanceUUID = er.getHeader().getUUID();
            return this.removeFromContext(contextUUID, erType, instanceUUID);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean removeFromCurrentContext(String erType, UUID instanceUUID) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        UUID contextUUID = this.getCurrentContextUUID();
        return this.removeFromContext(contextUUID, erType, instanceUUID);
    }

    @Override
    public <E extends ER> boolean removeFromCurrentContext(E er) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        UUID contextUUID = this.getCurrentContextUUID();
        return this.removeFromContext(contextUUID, er);
    }

    @Override
    public boolean addResourceToContext(UUID contextUUID, String resourceType, UUID resourceUUID) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToContext(contextUUID, resourceType, resourceUUID);
    }

    @Override
    public <R extends Resource> boolean addResourceToContext(UUID contextUUID, R resource) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToContext(contextUUID, (ER)resource);
    }

    @Override
    public boolean addResourceToCurrentContext(String resourceType, UUID resourceUUID) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToCurrentContext(resourceType, resourceUUID);
    }

    @Override
    public <R extends Resource> boolean addResourceToCurrentContext(R resource) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToCurrentContext((ER)resource);
    }

    @Override
    public boolean removeResourceFromContext(UUID contextUUID, String resourceType, UUID resourceUUID) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromContext(contextUUID, resourceType, resourceUUID);
    }

    @Override
    public <R extends Resource> boolean removeResourceFromContext(UUID contextUUID, R resource) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromContext(contextUUID, (ER)resource);
    }

    @Override
    public boolean removeResourceFromCurrentContext(String resourceType, UUID resourceUUID) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromCurrentContext(resourceType, resourceUUID);
    }

    @Override
    public <R extends Resource> boolean removeResourceFromCurrentContext(R resource) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromCurrentContext((ER)resource);
    }

    @Override
    public boolean addFacetToContext(UUID contextUUID, String facetType, UUID facetUUID) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToContext(contextUUID, facetType, facetUUID);
    }

    @Override
    public <F extends Facet> boolean addFacetToContext(UUID contextUUID, F facet) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToContext(contextUUID, (ER)facet);
    }

    @Override
    public boolean addFacetToCurrentContext(String facetType, UUID facetUUID) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToCurrentContext(facetType, facetUUID);
    }

    @Override
    public <F extends Facet> boolean addFacetToCurrentContext(F facet) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToCurrentContext((ER)facet);
    }

    @Override
    public boolean removeFacetFromContext(UUID contextUUID, String facetType, UUID facetUUID) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromContext(contextUUID, facetType, facetUUID);
    }

    @Override
    public <F extends Facet> boolean removeFacetFromContext(UUID contextUUID, F facet) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromContext(contextUUID, (ER)facet);
    }

    @Override
    public boolean removeFacetFromCurrentContext(String facetType, UUID facetUUID) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromCurrentContext(facetType, facetUUID);
    }

    @Override
    public <F extends Facet> boolean removeFacetFromCurrentContext(F facet) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromCurrentContext((ER)facet);
    }
}

