/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.publisher;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.model.reference.ERElement;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCache;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.facet.FacetAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.facet.FacetAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.facet.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.resource.ResourceAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.resource.ResourceAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.consistsof.ConsistsOfAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.consistsof.ConsistsOfAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.consistsof.ConsistsOfNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.isrelatedto.IsRelatedToAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.isrelatedto.IsRelatedToAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.isrelatedto.IsRelatedToNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaViolationException;
import org.gcube.informationsystem.resourceregistry.api.request.RequestInfo;

public interface ResourceRegistryPublisher
extends RequestInfo {
    public void addHeader(String var1, String var2);

    public void addHeader(String var1, boolean var2);

    public ContextCache getContextCache();

    public List<Context> getAllContexts() throws ResourceRegistryException;

    public Context getContext(UUID var1) throws ContextNotFoundException, ResourceRegistryException;

    public Context getCurrentContext() throws ContextNotFoundException, ResourceRegistryException;

    public <ERElem extends ERElement> List<ERElem> list(Class<ERElem> var1, Boolean var2) throws ResourceRegistryException;

    public String list(String var1, Boolean var2) throws ResourceRegistryException;

    public <ERElem extends ERElement> ERElem create(ERElem var1) throws SchemaViolationException, AlreadyPresentException, ResourceRegistryException;

    public String create(String var1) throws SchemaViolationException, AlreadyPresentException, ResourceRegistryException;

    public <ERElem extends ERElement> boolean exist(ERElem var1) throws AvailableInAnotherContextException, ResourceRegistryException;

    public <ERElem extends ERElement> boolean exist(Class<ERElem> var1, UUID var2) throws AvailableInAnotherContextException, ResourceRegistryException;

    public boolean exist(String var1, UUID var2) throws AvailableInAnotherContextException, ResourceRegistryException;

    public <ERElem extends ERElement> ERElem read(ERElem var1) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException;

    public <ERElem extends ERElement> ERElem read(Class<ERElem> var1, UUID var2) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException;

    public String read(String var1, UUID var2) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException;

    public <ERElem extends ERElement> ERElem update(ERElem var1) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public String update(String var1) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public String update(String var1, String var2) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public String update(String var1, String var2, UUID var3) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public <ERElem extends ERElement> boolean delete(ERElem var1) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public boolean delete(String var1, UUID var2) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public <F extends Facet> F createFacet(F var1) throws SchemaViolationException, FacetAlreadyPresentException, ResourceRegistryException;

    public String createFacet(String var1) throws SchemaViolationException, FacetAlreadyPresentException, ResourceRegistryException;

    public <F extends Facet> F readFacet(F var1) throws FacetNotFoundException, FacetAvailableInAnotherContextException, ResourceRegistryException;

    public String readFacet(String var1, UUID var2) throws FacetNotFoundException, FacetAvailableInAnotherContextException, ResourceRegistryException;

    public <F extends Facet> F updateFacet(F var1) throws SchemaViolationException, FacetNotFoundException, ResourceRegistryException;

    public String updateFacet(String var1) throws SchemaViolationException, FacetNotFoundException, ResourceRegistryException;

    public <F extends Facet> boolean deleteFacet(F var1) throws SchemaViolationException, FacetNotFoundException, ResourceRegistryException;

    public boolean deleteFacet(String var1, UUID var2) throws SchemaViolationException, FacetNotFoundException, ResourceRegistryException;

    public <R extends Resource> R createResource(R var1) throws SchemaViolationException, ResourceAlreadyPresentException, ResourceRegistryException;

    public String createResource(String var1) throws SchemaViolationException, ResourceAlreadyPresentException, ResourceRegistryException;

    public <R extends Resource> R readResource(R var1) throws ResourceNotFoundException, ResourceAvailableInAnotherContextException, ResourceRegistryException;

    public String readResource(String var1, UUID var2) throws ResourceNotFoundException, ResourceAvailableInAnotherContextException, ResourceRegistryException;

    public <R extends Resource> R updateResource(R var1) throws SchemaViolationException, ResourceNotFoundException, ResourceRegistryException;

    public String updateResource(String var1) throws SchemaViolationException, ResourceNotFoundException, ResourceRegistryException;

    public <R extends Resource> boolean deleteResource(R var1) throws ResourceNotFoundException, ResourceRegistryException;

    public boolean deleteResource(String var1, UUID var2) throws ResourceNotFoundException, ResourceRegistryException;

    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C createConsistsOf(C var1) throws SchemaViolationException, ConsistsOfAlreadyPresentException, ResourceNotFoundException, ResourceRegistryException;

    public String createConsistsOf(String var1) throws SchemaViolationException, ConsistsOfAlreadyPresentException, ResourceNotFoundException, ResourceRegistryException;

    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C readConsistsOf(C var1) throws ConsistsOfNotFoundException, ConsistsOfAvailableInAnotherContextException, ResourceRegistryException;

    public String readConsistsOf(String var1, UUID var2) throws ConsistsOfNotFoundException, ConsistsOfAvailableInAnotherContextException, ResourceRegistryException;

    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C updateConsistsOf(C var1) throws SchemaViolationException, ConsistsOfNotFoundException, ResourceRegistryException;

    public String updateConsistsOf(String var1) throws SchemaViolationException, ConsistsOfNotFoundException, ResourceRegistryException;

    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> boolean deleteConsistsOf(C var1) throws SchemaViolationException, ConsistsOfNotFoundException, ResourceRegistryException;

    public boolean deleteConsistsOf(String var1, UUID var2) throws SchemaViolationException, ConsistsOfNotFoundException, ResourceRegistryException;

    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I createIsRelatedTo(I var1) throws SchemaViolationException, IsRelatedToAlreadyPresentException, ResourceNotFoundException, ResourceRegistryException;

    public String createIsRelatedTo(String var1) throws SchemaViolationException, IsRelatedToAlreadyPresentException, ResourceNotFoundException, ResourceRegistryException;

    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I readIsRelatedTo(I var1) throws IsRelatedToNotFoundException, IsRelatedToAvailableInAnotherContextException, ResourceRegistryException;

    public String readIsRelatedTo(String var1, UUID var2) throws IsRelatedToNotFoundException, IsRelatedToAvailableInAnotherContextException, ResourceRegistryException;

    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I updateIsRelatedTo(I var1) throws SchemaViolationException, IsRelatedToNotFoundException, ResourceRegistryException;

    public String updateIsRelatedTo(String var1) throws SchemaViolationException, IsRelatedToNotFoundException, ResourceRegistryException;

    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> boolean deleteIsRelatedTo(I var1) throws IsRelatedToNotFoundException, ResourceRegistryException;

    public boolean deleteIsRelatedTo(String var1, UUID var2) throws IsRelatedToNotFoundException, ResourceRegistryException;

    public List<ERElement> addToContext(String var1, UUID var2, UUID var3, Boolean var4) throws SchemaViolationException, NotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> addToContext(ERElement var1, UUID var2, Boolean var3) throws SchemaViolationException, NotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> addToCurrentContext(String var1, UUID var2, Boolean var3) throws SchemaViolationException, NotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> addToCurrentContext(ERElement var1, Boolean var2) throws SchemaViolationException, NotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> removeFromContext(String var1, UUID var2, UUID var3, Boolean var4) throws SchemaViolationException, NotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> removeFromContext(ERElement var1, UUID var2, Boolean var3) throws SchemaViolationException, NotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> removeFromCurrentContext(String var1, UUID var2, Boolean var3) throws SchemaViolationException, NotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> removeFromCurrentContext(ERElement var1, Boolean var2) throws SchemaViolationException, NotFoundException, ContextNotFoundException, ResourceRegistryException;

    public Map<UUID, String> getElementContexts(String var1, UUID var2) throws NotFoundException, ResourceRegistryException;

    public <ERElem extends ERElement> Map<UUID, String> getElementContexts(ERElem var1) throws NotFoundException, ResourceRegistryException;

    public List<ERElement> addResourceToContext(String var1, UUID var2, UUID var3, Boolean var4) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <R extends Resource> List<ERElement> addResourceToContext(R var1, UUID var2, Boolean var3) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> addResourceToCurrentContext(String var1, UUID var2, Boolean var3) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <R extends Resource> List<ERElement> addResourceToCurrentContext(R var1, Boolean var2) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> removeResourceFromContext(String var1, UUID var2, UUID var3, Boolean var4) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <R extends Resource> List<ERElement> removeResourceFromContext(R var1, UUID var2, Boolean var3) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> removeResourceFromCurrentContext(String var1, UUID var2, Boolean var3) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <R extends Resource> List<ERElement> removeResourceFromCurrentContext(R var1, Boolean var2) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public Map<UUID, String> getResourceContexts(String var1, UUID var2) throws ResourceNotFoundException, ResourceRegistryException;

    public <R extends Resource> Map<UUID, String> getResourceContexts(R var1) throws ResourceNotFoundException, ResourceRegistryException;

    public List<ERElement> addFacetToContext(String var1, UUID var2, UUID var3, Boolean var4) throws SchemaViolationException, FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <F extends Facet> List<ERElement> addFacetToContext(F var1, UUID var2, Boolean var3) throws SchemaViolationException, FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> addFacetToCurrentContext(String var1, UUID var2, Boolean var3) throws SchemaViolationException, FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <F extends Facet> List<ERElement> addFacetToCurrentContext(F var1, Boolean var2) throws SchemaViolationException, FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> removeFacetFromContext(String var1, UUID var2, UUID var3, Boolean var4) throws SchemaViolationException, FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <F extends Facet> List<ERElement> removeFacetFromContext(F var1, UUID var2, Boolean var3) throws SchemaViolationException, FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> removeFacetFromCurrentContext(String var1, UUID var2, Boolean var3) throws SchemaViolationException, FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <F extends Facet> List<ERElement> removeFacetFromCurrentContext(F var1, Boolean var2) throws SchemaViolationException, FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public Map<UUID, String> getFacetContexts(String var1, UUID var2) throws FacetNotFoundException, ResourceRegistryException;

    public <F extends Facet> Map<UUID, String> getFacetContexts(F var1) throws FacetNotFoundException, ResourceRegistryException;
}

