/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.queries.templates;

import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.com.fasterxml.jackson.databind.JavaType;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.type.CollectionType;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.common.http.GXHTTPUtility;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.model.reference.ERElement;
import org.gcube.informationsystem.queries.templates.reference.entities.QueryTemplate;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.templates.QueryTemplateAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.templates.QueryTemplateNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPUtility;
import org.gcube.informationsystem.resourceregistry.queries.templates.ResourceRegistryQueryTemplateClient;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryQueryTemplateClientImpl
implements ResourceRegistryQueryTemplateClient {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryQueryTemplateClientImpl.class);
    private static final String ACCEPT_HTTP_HEADER_KEY = "Accept";
    private static final String CONTENT_TYPE_HTTP_HEADER_KEY = "Content-Type";
    protected final String address;
    protected Map<String, String> headers;
    protected boolean hierarchicalMode;
    protected boolean includeContexts;
    protected boolean includeMeta;
    protected boolean allMeta;

    public boolean isHierarchicalMode() {
        return this.hierarchicalMode;
    }

    public void setHierarchicalMode(boolean hierarchicalMode) {
        this.hierarchicalMode = hierarchicalMode;
    }

    public boolean includeContexts() {
        return this.includeContexts;
    }

    public void setIncludeContexts(boolean includeContexts) {
        this.includeContexts = includeContexts;
    }

    public boolean includeMeta() {
        return this.includeMeta;
    }

    public void setIncludeMeta(boolean includeMeta) {
        this.includeMeta = includeMeta;
    }

    public boolean allMeta() {
        return this.allMeta;
    }

    public void setAllMeta(boolean allMeta) {
        this.allMeta = allMeta;
    }

    private void addOptionalQueryParameters(Map<String, String> queryParams) throws UnsupportedEncodingException {
        this.addHierarchicalMode(queryParams);
        this.addIncludeContexts(queryParams);
        this.addIncludeMeta(queryParams);
        this.addIncludeAllMeta(queryParams);
    }

    private GXHTTPStringRequest includeAdditionalQueryParameters(GXHTTPStringRequest gxHTTPStringRequest) throws UnsupportedEncodingException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        return this.includeAdditionalQueryParameters(gxHTTPStringRequest, queryParams);
    }

    private GXHTTPStringRequest includeAdditionalQueryParameters(GXHTTPStringRequest gxHTTPStringRequest, Map<String, String> queryParams) throws UnsupportedEncodingException {
        if (queryParams == null) {
            queryParams = new HashMap<String, String>();
        }
        this.addOptionalQueryParameters(queryParams);
        return gxHTTPStringRequest.queryParams(queryParams);
    }

    private void addHierarchicalMode(Map<String, String> queryParams) throws UnsupportedEncodingException {
        if (this.hierarchicalMode) {
            queryParams.put("hierarchical", Boolean.toString(this.hierarchicalMode));
        }
    }

    private void addIncludeContexts(Map<String, String> queryParams) throws UnsupportedEncodingException {
        if (this.includeContexts) {
            queryParams.put("includeContexts", Boolean.toString(this.includeContexts));
        }
    }

    private void addIncludeMeta(Map<String, String> queryParams) throws UnsupportedEncodingException {
        if (this.includeMeta) {
            queryParams.put("includeMeta", Boolean.toString(this.includeMeta));
        }
    }

    private void addIncludeAllMeta(Map<String, String> queryParams) throws UnsupportedEncodingException {
        if (this.allMeta) {
            queryParams.put("allMeta", Boolean.toString(this.allMeta));
        }
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    protected GXHTTPStringRequest getGXHTTPStringRequest() {
        GXHTTPStringRequest gxHTTPStringRequest = GXHTTPUtility.getGXHTTPStringRequest((String)this.address);
        gxHTTPStringRequest.from(this.getClass().getSimpleName());
        for (String name : this.headers.keySet()) {
            gxHTTPStringRequest.header(name, this.headers.get(name));
        }
        return gxHTTPStringRequest;
    }

    public ResourceRegistryQueryTemplateClientImpl(String address) {
        this.address = address;
        this.headers = new HashMap<String, String>();
        this.hierarchicalMode = false;
        this.includeContexts = false;
        this.includeMeta = false;
        this.allMeta = false;
    }

    @Override
    public List<QueryTemplate> all() throws ResourceRegistryException {
        try {
            logger.trace("Going to list {}s", (Object)"QueryTemplate");
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("query-templates");
            HashMap<String, String> parameters = new HashMap<String, String>();
            this.addIncludeMeta(parameters);
            this.addIncludeAllMeta(parameters);
            gxHTTPStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String all = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got {}s are {}", (Object)"QueryTemplate", (Object)all);
            CollectionType type = ElementMapper.getObjectMapper().getTypeFactory().constructCollectionType(ArrayList.class, QueryTemplate.class);
            return (List)ElementMapper.getObjectMapper().readValue(all, (JavaType)type);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public QueryTemplate create(QueryTemplate queryTemplate) throws QueryTemplateAlreadyPresentException, ResourceRegistryException {
        try {
            String queryTemplateString = ElementMapper.marshal((Element)queryTemplate);
            String res = this.create(queryTemplateString);
            return (QueryTemplate)ElementMapper.unmarshal(QueryTemplate.class, (String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String create(String queryTemplate) throws QueryTemplateAlreadyPresentException, ResourceRegistryException {
        try {
            logger.trace("Going to create: {}", (Object)queryTemplate);
            QueryTemplate qt = (QueryTemplate)ElementMapper.unmarshal(QueryTemplate.class, (String)queryTemplate);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.header(CONTENT_TYPE_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("query-templates");
            gxHTTPStringRequest.path(qt.getName());
            HashMap<String, String> parameters = new HashMap<String, String>();
            this.addIncludeMeta(parameters);
            this.addIncludeAllMeta(parameters);
            gxHTTPStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put(queryTemplate);
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.trace("{} successfully created", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean exist(String queryTemplateName) throws ResourceRegistryException {
        try {
            logger.trace("Going to read {} with name {}", (Object)"QueryTemplate", (Object)queryTemplateName);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("query-templates");
            gxHTTPStringRequest.path(queryTemplateName);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.head();
            HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean exist(QueryTemplate queryTemplate) throws ResourceRegistryException {
        return this.exist(queryTemplate.getName());
    }

    @Override
    public QueryTemplate read(QueryTemplate queryTemplate) throws QueryTemplateNotFoundException, ResourceRegistryException {
        return this.read(queryTemplate.getName());
    }

    @Override
    public QueryTemplate read(String queryTemplateName) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            String queryTemplate = this.readAsString(queryTemplateName);
            return (QueryTemplate)ElementMapper.unmarshal(QueryTemplate.class, (String)queryTemplate);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String readAsString(String queryTemplateName) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to read {} with name {}", (Object)"QueryTemplate", (Object)queryTemplateName);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("query-templates");
            gxHTTPStringRequest.path(queryTemplateName);
            HashMap<String, String> parameters = new HashMap<String, String>();
            this.addIncludeMeta(parameters);
            this.addIncludeAllMeta(parameters);
            gxHTTPStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got {} is {}", (Object)"QueryTemplate", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public QueryTemplate update(QueryTemplate queryTemplate) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            String queryTemplateString = ElementMapper.marshal((Element)queryTemplate);
            String res = this.update(queryTemplateString);
            return (QueryTemplate)ElementMapper.unmarshal(QueryTemplate.class, (String)res);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String update(String queryTemplate) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to update: {}", (Object)queryTemplate);
            QueryTemplate qt = (QueryTemplate)ElementMapper.unmarshal(QueryTemplate.class, (String)queryTemplate);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.header(CONTENT_TYPE_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("query-templates");
            gxHTTPStringRequest.path(qt.getName());
            HashMap<String, String> parameters = new HashMap<String, String>();
            this.addIncludeMeta(parameters);
            this.addIncludeAllMeta(parameters);
            gxHTTPStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put(queryTemplate);
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.trace("{} successfully updated", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String runGetString(String name) throws QueryTemplateNotFoundException, ResourceRegistryException {
        return this.run(name, "");
    }

    @Override
    public <E extends ERElement> List<E> run(String name) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            String ret = this.runGetString(name);
            CollectionType type = ElementMapper.getObjectMapper().getTypeFactory().constructCollectionType(ArrayList.class, ERElement.class);
            return (List)ElementMapper.getObjectMapper().readValue(ret, (JavaType)type);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <E extends ERElement> List<E> run(QueryTemplate queryTemplate) throws QueryTemplateNotFoundException, ResourceRegistryException {
        return this.run(queryTemplate.getName());
    }

    @Override
    public String run(String name, String params) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            if (params == null || params.compareTo("") == 0) {
                logger.trace("Going to run {} using default parameters", (Object)"QueryTemplate");
                params = null;
            } else {
                logger.trace("Going to run {} with the following parameters {}", (Object)"QueryTemplate", (Object)params);
            }
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.header(CONTENT_TYPE_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("query-templates");
            gxHTTPStringRequest.path(name);
            this.includeAdditionalQueryParameters(gxHTTPStringRequest);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.post(params);
            String c = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.trace("The result of the query is {}", (Object)c);
            return c;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <E extends ERElement> List<E> run(String name, JsonNode jsonNode) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String ret = this.run(name, objectMapper.writeValueAsString((Object)jsonNode));
            CollectionType type = ElementMapper.getObjectMapper().getTypeFactory().constructCollectionType(ArrayList.class, ERElement.class);
            return (List)ElementMapper.getObjectMapper().readValue(ret, (JavaType)type);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <E extends ERElement> List<E> run(QueryTemplate queryTemplate, JsonNode jsonNode) throws QueryTemplateNotFoundException, ResourceRegistryException {
        return this.run(queryTemplate.getName(), jsonNode);
    }

    @Override
    public boolean delete(QueryTemplate queryTemplate) throws QueryTemplateNotFoundException, ResourceRegistryException {
        return this.delete(queryTemplate.getName());
    }

    @Override
    public boolean delete(String queryTemplateName) throws QueryTemplateNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to delete {} with name {}", (Object)"QueryTemplate", (Object)queryTemplateName);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("query-templates");
            gxHTTPStringRequest.path(queryTemplateName);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.delete();
            HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            boolean deleted = true;
            logger.info("{} with name {} {}", new Object[]{"QueryTemplate", queryTemplateName, deleted ? "successfully deleted" : "was NOT deleted"});
            return deleted;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

