/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources;

import javax.ws.rs.ApplicationPath;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.gcube.informationsystem.resourceregistry.api.SchemaManagement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaException;
import org.gcube.informationsystem.resourceregistry.resources.impl.SchemaManagementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationPath(value="schema")
public class SchemaManager {
    private static Logger logger = LoggerFactory.getLogger(SchemaManager.class);
    protected SchemaManagement schemaManager = new SchemaManagementImpl();

    @Path(value="embedded")
    @PUT
    public String registerEmbeddedTypeSchema(String jsonSchema) throws SchemaException {
        logger.trace("Requested Embedded registration with schema {} ", (Object)jsonSchema);
        return this.schemaManager.registerEmbeddedTypeSchema(jsonSchema);
    }

    @Path(value="facet")
    @PUT
    public String registerFacetSchema(String jsonSchema) throws SchemaException {
        logger.trace("Requested Facet registration with schema {} ", (Object)jsonSchema);
        return this.schemaManager.registerFacetSchema(jsonSchema);
    }

    @Path(value="resource")
    @PUT
    public String registerResourceSchema(String jsonSchema) throws SchemaException {
        logger.trace("Requested Resource registration with schema {} ", (Object)jsonSchema);
        return this.schemaManager.registerResourceSchema(jsonSchema);
    }

    @Path(value="consistof")
    @PUT
    public String registerConsistOfSchema(String jsonSchema) throws SchemaException {
        logger.trace("Requested ConsistOf registration with schema {} ", (Object)jsonSchema);
        return this.schemaManager.registerConsistOfSchema(jsonSchema);
    }

    @Path(value="relatedto")
    @PUT
    public String registerRelatedToSchema(String jsonSchema) throws SchemaException {
        logger.trace("Requested RelatedTo registration with schema {} ", (Object)jsonSchema);
        return this.schemaManager.registerRelatedToSchema(jsonSchema);
    }
}

