/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources;

import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.gcube.informationsystem.resourceregistry.api.ContextManagement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.resources.impl.ContextManagementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="context")
public class ContextManager {
    private static Logger logger = LoggerFactory.getLogger(ContextManager.class);
    protected ContextManagement contextManager = new ContextManagementImpl();

    @PUT
    @Path(value="create/{parentContextId}")
    public String create(@PathParam(value="parentContextId") String parentContextId, @QueryParam(value="name") String name) throws Exception {
        logger.trace("requested create context with json : {} ", (Object)name);
        return this.contextManager.create(parentContextId, name);
    }

    @PUT
    @Path(value="rename/{contextId}")
    public String rename(@PathParam(value="contextId") String uuid, @QueryParam(value="name") String name) throws ContextNotFoundException, ContextException {
        logger.trace("requested rename context id {} with {} ", (Object)uuid, (Object)name);
        return this.contextManager.rename(uuid, name);
    }

    @PUT
    @Path(value="move/{contextId}")
    public String move(@PathParam(value="contextId") String uuid, @QueryParam(value="newParentId") String newParentId) throws ContextNotFoundException, ContextException {
        logger.trace("requested move context id {} with new parend id {} ", (Object)uuid, (Object)newParentId);
        return this.contextManager.move(newParentId, uuid);
    }

    @DELETE
    @Path(value="delete/{id}")
    public String delete(@PathParam(value="id") String uuid) throws ContextNotFoundException {
        logger.trace("requested delete context with id {} ", (Object)uuid);
        return uuid;
    }
}

