/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources;

import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsRelatedTo;
import org.gcube.informationsystem.resourceregistry.api.EntityManagement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.EntityException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.resources.SchemaManager;
import org.gcube.informationsystem.resourceregistry.resources.impl.EntityManagementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="entity")
public class EntityManager {
    private static Logger logger = LoggerFactory.getLogger(SchemaManager.class);
    protected EntityManagement entityManager = new EntityManagementImpl();

    @Path(value="facet/{facetType}")
    @PUT
    public String createFacet(@PathParam(value="facetType") String facetType, String jsonRepresentation) throws EntityException, ResourceRegistryException {
        logger.trace("requested facet creation for type {} with json {} ", (Object)facetType, (Object)jsonRepresentation);
        return this.entityManager.createFacet(facetType, jsonRepresentation);
    }

    @Path(value="facet/{facetId}")
    @POST
    public String updateFacet(@PathParam(value="facetId") String facetId, String jsonRepresentation) throws FacetNotFoundException, ResourceRegistryException {
        logger.trace("requested facet update for id {} with json", (Object)facetId, (Object)jsonRepresentation);
        return this.entityManager.updateFacet(facetId, jsonRepresentation);
    }

    @Path(value="facet/{facetId}")
    @DELETE
    public boolean deleteFacet(@PathParam(value="facetId") String facetId) throws FacetNotFoundException, ResourceRegistryException {
        logger.trace("requested facet deletion for id {}", (Object)facetId);
        return this.entityManager.deleteFacet(facetId);
    }

    @Path(value="resource/{resourceType}")
    @PUT
    public String createResource(@PathParam(value="resourceType") String resourceType, String jsonRepresentation) throws FacetNotFoundException, ResourceRegistryException {
        logger.trace("requested resource creation for type {} with json {}", (Object)resourceType, (Object)jsonRepresentation);
        return this.entityManager.createResource(resourceType, jsonRepresentation);
    }

    @Path(value="resource/{resourceId}")
    @DELETE
    public boolean deleteResource(@PathParam(value="resourceId") String resourceId) throws ResourceNotFoundException, Exception {
        logger.trace("requested resource deletion for id {}", (Object)resourceId);
        return this.entityManager.deleteResource(resourceId);
    }

    @Path(value="consistOf/source/{resourceId}/target/{facetId}")
    @PUT
    public String attachFacet(@PathParam(value="resourceId") String resourceUUID, @PathParam(value="facetId") String facetUUID, @QueryParam(value="consistOfType") String consistOfType, @QueryParam(value="jsonProperties") String jsonProperties) throws FacetNotFoundException, ResourceNotFoundException, ResourceRegistryException {
        logger.trace("requested to attach resource {} to facet {} ({} Type {}) with properties {}", new Object[]{resourceUUID, facetUUID, ConsistsOf.class.getSimpleName(), consistOfType, jsonProperties});
        return this.entityManager.attachFacet(resourceUUID, facetUUID, consistOfType, jsonProperties);
    }

    @Path(value="consistOf/{consistOfId}")
    @DELETE
    public boolean detachFacet(@PathParam(value="consistOfId") String consistOfUUID) throws ResourceRegistryException {
        logger.trace("requested to detach {}", (Object)consistOfUUID);
        return this.entityManager.detachFacet(consistOfUUID);
    }

    @Path(value="relatedTo/source/{sourceResourceId}/target/{targetResourceId}")
    @PUT
    public String attachResource(@PathParam(value="sourceResourceId") String sourceResourceUuid, @PathParam(value="targetResourceId") String targetResourceUuid, @QueryParam(value="relatedToType") String relatedToType, @QueryParam(value="jsonProperties") String jsonProperties) throws ResourceNotFoundException, ResourceRegistryException {
        logger.trace("requested to attach source resource {} and target resource {} ({} Type {}) with properties {}", new Object[]{sourceResourceUuid, targetResourceUuid, IsRelatedTo.class.getSimpleName(), relatedToType, jsonProperties});
        return this.entityManager.attachResource(sourceResourceUuid, targetResourceUuid, relatedToType, jsonProperties);
    }

    @Path(value="relatedTo/{relatedToId}")
    @DELETE
    public boolean detachResource(@PathParam(value="relatedToId") String relatedToUUID) throws ResourceRegistryException {
        logger.trace("requested to detach {}", (Object)relatedToUUID);
        return this.entityManager.detachResource(relatedToUUID);
    }
}

