/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources;

import javax.ws.rs.ApplicationPath;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.gcube.informationsystem.resourceregistry.api.SchemaManagement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaException;
import org.gcube.informationsystem.resourceregistry.resources.impl.SchemaManagementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationPath(value="schema")
public class SchemaManager {
    private static Logger logger = LoggerFactory.getLogger(SchemaManager.class);
    protected SchemaManagement schemaManager = new SchemaManagementImpl();

    @PUT
    @Path(value="embedded")
    public String registerEmbeddedTypeSchema(@QueryParam(value="schema") String jsonSchema) throws SchemaException {
        logger.trace("Requested Embedded registration with schema {}", (Object)jsonSchema);
        return this.schemaManager.registerEmbeddedTypeSchema(jsonSchema);
    }

    @PUT
    @Path(value="facet")
    public String registerFacetSchema(@QueryParam(value="schema") String jsonSchema) throws SchemaException {
        logger.trace("Requested Facet registration with schema {}", (Object)jsonSchema);
        return this.schemaManager.registerFacetSchema(jsonSchema);
    }

    @PUT
    @Path(value="resource")
    public String registerResourceSchema(@QueryParam(value="schema") String jsonSchema) throws SchemaException {
        logger.trace("Requested Resource registration with schema {}", (Object)jsonSchema);
        return this.schemaManager.registerResourceSchema(jsonSchema);
    }

    @PUT
    @Path(value="consistOf")
    public String registerConsistOfSchema(@QueryParam(value="schema") String jsonSchema) throws SchemaException {
        logger.trace("Requested ConsistOf registration with schema {} ", (Object)jsonSchema);
        return this.schemaManager.registerConsistOfSchema(jsonSchema);
    }

    @PUT
    @Path(value="relatedTo")
    public String registerRelatedToSchema(@QueryParam(value="schema") String jsonSchema) throws SchemaException {
        logger.trace("Requested RelatedTo registration with schema {} ", (Object)jsonSchema);
        return this.schemaManager.registerRelatedToSchema(jsonSchema);
    }
}

