/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources.impl;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.frames.FramedGraphFactory;
import com.tinkerpop.frames.FramedTransactionalGraph;
import com.tinkerpop.frames.modules.Module;
import java.util.Iterator;
import java.util.UUID;
import org.gcube.informationsystem.model.orientdb.impl.entity.Context;
import org.gcube.informationsystem.model.orientdb.impl.entity.Entity;
import org.gcube.informationsystem.resourceregistry.api.ContextManagement;
import org.gcube.informationsystem.resourceregistry.api.exceptions.InternalException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextCreationException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.SecurityContext;
import org.gcube.informationsystem.resourceregistry.context.SecurityContextMapper;
import org.gcube.informationsystem.resourceregistry.resources.utils.HeaderUtility;
import org.gcube.informationsystem.resourceregistry.resources.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextManagementImpl
implements ContextManagement {
    private static Logger logger = LoggerFactory.getLogger(ContextManagementImpl.class);

    protected Vertex checkContext(OrientGraph orientGraph, String parentContextUUID, String contextName) throws ContextNotFoundException, ContextException {
        Vertex parent = null;
        if (parentContextUUID != null) {
            parent = this.getContext(orientGraph, parentContextUUID);
            String select = "SELECT FROM (TRAVERSE out(IsParentOf) FROM " + parent.getId() + " MAXDEPTH 1) WHERE " + "name" + "=\"" + contextName + "\" AND " + "header" + "." + "uuid" + "<>\"" + parentContextUUID + "\"";
            logger.trace(select);
            String message = "A context with the same name (" + contextName + ") has been already created as child of " + parentContextUUID + "(name=" + parent.getProperty("name").toString() + ")";
            logger.trace("Checking if {} -> {}", (Object)message, (Object)select);
            OSQLSynchQuery osqlSynchQuery = new OSQLSynchQuery(select);
            Iterable vertexes = (Iterable)orientGraph.command((OCommandRequest)osqlSynchQuery).execute(new Object[0]);
            if (vertexes != null && vertexes.iterator().hasNext()) {
                throw new ContextException(message);
            }
        } else {
            String select = "SELECT FROM Context WHERE name = \"" + contextName + "\"" + " AND in(\"" + "IsParentOf" + "\").size() = 0";
            OSQLSynchQuery osqlSynchQuery = new OSQLSynchQuery(select);
            Iterable vertexes = (Iterable)orientGraph.command((OCommandRequest)osqlSynchQuery).execute(new Object[0]);
            if (vertexes != null && vertexes.iterator().hasNext()) {
                throw new ContextException("A root context with the same name (" + contextName + ") already exist");
            }
        }
        return parent;
    }

    public Vertex getContext(OrientGraph orientGraph, String contextUUID) throws ContextNotFoundException {
        try {
            return Utility.getEntityByUUID((OrientGraph)orientGraph, (String)"Context", (String)contextUUID);
        }
        catch (ResourceRegistryException e) {
            throw new ContextNotFoundException(e.getMessage());
        }
    }

    public String create(String parentContextUUID, String name) throws ContextCreationException, InternalException {
        Vertex parent;
        logger.info("Trying to create {} with name {} and parent {} UUID {}", new Object[]{"Context", name, "Context", parentContextUUID});
        if (parentContextUUID != null && parentContextUUID.compareTo("") == 0) {
            parentContextUUID = null;
        }
        OrientGraph orientGraph = SecurityContextMapper.getSecurityContextFactory(null, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER).getTx();
        try {
            parent = this.checkContext(orientGraph, parentContextUUID, name);
        }
        catch (ContextException e) {
            throw new ContextCreationException(e.getMessage());
        }
        UUID uuid = UUID.randomUUID();
        String uuidString = uuid.toString();
        SecurityContext.createSecurityContext((OrientGraph)orientGraph, (String)uuidString, (boolean)true);
        try {
            FramedGraphFactory framedGraphFactory = new FramedGraphFactory(new Module[0]);
            FramedTransactionalGraph framedGraph = framedGraphFactory.create((TransactionalGraph)orientGraph);
            Context context = (Context)framedGraph.addVertex((Object)"class:Context", Context.class);
            context.setName(name);
            HeaderUtility.addHeader((Entity)context, (UUID)uuid);
            if (parentContextUUID != null) {
                orientGraph.addEdge(null, parent, context.asVertex(), "IsParentOf");
            }
            SecurityContext.addToSecurityContext((OrientGraph)orientGraph, (Vertex)context.asVertex(), (String)uuidString);
            String contextJsonString = Utility.toJsonString((Element)context.asVertex(), (boolean)true);
            logger.trace("Creating {}", (Object)contextJsonString);
            orientGraph.commit();
            logger.info("Context {} created", (Object)contextJsonString);
            String string = uuidString;
            return string;
        }
        catch (Exception e) {
            orientGraph.rollback();
            SecurityContext.deleteSecurityContext((OrientGraph)orientGraph, (String)uuidString, (boolean)true);
            throw new InternalException(e.getMessage());
        }
        finally {
            orientGraph.shutdown();
        }
    }

    public String read(String contextUUID) throws ContextNotFoundException, ContextException {
        OrientGraph orientGraph = SecurityContextMapper.getSecurityContextFactory(null, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER).getTx();
        Vertex context = this.getContext(orientGraph, contextUUID);
        return Utility.toJsonString((Element)context, (boolean)false);
    }

    public String rename(String contextUUID, String newName) throws ContextNotFoundException, ContextException {
        logger.info("Trying to rename {} with UUID {} to {}", new Object[]{"Context", contextUUID, newName});
        OrientGraph orientGraph = SecurityContextMapper.getSecurityContextFactory(null, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER).getTx();
        Vertex context = this.getContext(orientGraph, contextUUID);
        String parentUUID = null;
        Iterable edges = context.getEdges(Direction.IN, new String[]{"IsParentOf"});
        if (edges != null && edges.iterator().hasNext()) {
            Iterator iteratorEdge = edges.iterator();
            Edge edge = (Edge)iteratorEdge.next();
            if (iteratorEdge.hasNext()) {
                throw new ContextException("");
            }
            Vertex parent = edge.getVertex(Direction.OUT);
            parentUUID = parent.getProperty("header.uuid").toString();
        }
        this.checkContext(orientGraph, parentUUID, newName);
        context.setProperty("name", (Object)newName);
        orientGraph.commit();
        String contextJsonString = Utility.toJsonString((Element)context, (boolean)true);
        logger.info("Context renamed {}", (Object)contextJsonString);
        orientGraph.shutdown();
        return contextUUID;
    }

    public String move(String newParentUUID, String contextToMoveUUID) throws ContextNotFoundException, ContextException {
        logger.info("Trying to move {} with UUID {} as child of {} with UUID {}", new Object[]{"Context", contextToMoveUUID, "Context", newParentUUID});
        OrientGraph orientGraph = SecurityContextMapper.getSecurityContextFactory(null, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER).getTx();
        Vertex context = this.getContext(orientGraph, contextToMoveUUID);
        logger.trace("Context to move {}", (Object)Utility.toJsonString((Element)context, (boolean)true));
        this.checkContext(orientGraph, newParentUUID, context.getProperty("name").toString());
        Iterable edges = context.getEdges(Direction.IN, new String[]{"IsParentOf"});
        if (edges != null && edges.iterator().hasNext()) {
            Iterator edgeIterator = edges.iterator();
            Edge edge = (Edge)edgeIterator.next();
            logger.trace("Removing {} {}", (Object)Edge.class.getSimpleName(), (Object)edge);
            edge.remove();
        }
        if (newParentUUID != null) {
            Vertex parent = this.getContext(orientGraph, newParentUUID);
            logger.trace("New Parent Context {}", (Object)Utility.toJsonString((Element)parent, (boolean)true));
            orientGraph.addEdge(null, parent, context, "IsParentOf");
        }
        orientGraph.commit();
        context = this.getContext(orientGraph, contextToMoveUUID);
        String contextJsonString = Utility.toJsonString((Element)context, (boolean)true);
        logger.info("Context moved {}", (Object)contextJsonString);
        orientGraph.shutdown();
        return contextToMoveUUID;
    }

    public String delete(String uuid) throws ContextNotFoundException, ContextException {
        logger.info("Trying to remove {} with UUID {}", (Object)"Context", (Object)uuid);
        OrientGraph orientGraph = SecurityContextMapper.getSecurityContextFactory(null, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.WRITER).getTx();
        Vertex context = this.getContext(orientGraph, uuid);
        logger.trace("Context to be delete {}", (Object)Utility.toJsonString((Element)context, (boolean)true));
        Iterable edges = context.getEdges(Direction.OUT, new String[]{"IsParentOf"});
        if (edges != null && edges.iterator().hasNext()) {
            throw new ContextException("Only context with no children can be deleted");
        }
        SecurityContext.deleteSecurityContext((OrientGraph)orientGraph, (String)uuid, (boolean)false);
        context.remove();
        orientGraph.commit();
        orientGraph.shutdown();
        logger.info("{} with UUID {} successfully removed", (Object)"Context", (Object)uuid);
        return uuid;
    }
}

