/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.resources.utils;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;
import java.util.Iterator;
import java.util.UUID;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.informationsystem.model.entity.Context;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.SecurityContext;
import org.gcube.informationsystem.resourceregistry.context.SecurityContextMapper;
import org.gcube.informationsystem.resourceregistry.resources.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ContextUtility {
    private static final Logger logger = LoggerFactory.getLogger(ContextUtility.class);

    public static UUID addToActualContext(OrientGraph orientGraph, Vertex vertex) throws ContextException {
        UUID contextUUID = ContextUtility.getActualContextUUID();
        SecurityContext.addToSecurityContext((OrientGraph)orientGraph, (Vertex)vertex, (UUID)contextUUID);
        return contextUUID;
    }

    public static UUID addToActualContex(OSecurity oSecurity, Vertex vertex) throws ContextException {
        UUID contextUUID = ContextUtility.getActualContextUUID();
        SecurityContext.addToSecurityContext((OSecurity)oSecurity, (Vertex)vertex, (UUID)contextUUID);
        return contextUUID;
    }

    public static UUID addToActualContext(OrientGraph orientGraph, Edge edge) throws ContextException {
        UUID contextUUID = ContextUtility.getActualContextUUID();
        SecurityContext.addToSecurityContext((OrientGraph)orientGraph, (Edge)edge, (UUID)contextUUID);
        return contextUUID;
    }

    public static UUID addToActualContext(OSecurity oSecurity, Edge edge) throws ContextException {
        UUID contextUUID = ContextUtility.getActualContextUUID();
        SecurityContext.addToSecurityContext((OSecurity)oSecurity, (Edge)edge, (UUID)contextUUID);
        return contextUUID;
    }

    protected static UUID getContextUUIDFromContextVertex(Vertex vertex) {
        ODocument header = (ODocument)vertex.getProperty("header");
        String contextID = (String)header.field("uuid");
        return UUID.fromString(contextID);
    }

    public static String getCurrentContext() {
        String token = SecurityTokenProvider.instance.get();
        AuthorizationEntry authorizationEntry = null;
        try {
            authorizationEntry = Constants.authorizationService().get(token);
        }
        catch (Exception e) {
            return ScopeProvider.instance.get();
        }
        return authorizationEntry.getContext();
    }

    public static UUID getActualContextUUID() throws ContextException {
        OrientGraphFactory factory = null;
        OrientGraph orientGraph = null;
        try {
            String scope = ContextUtility.getCurrentContext();
            if (scope == null) {
                throw new ContextException("Null Token and Scope. Please set your token first.");
            }
            logger.trace("Trying to get context UUID for scope {}", (Object)scope);
            factory = SecurityContextMapper.getSecurityContextFactory((UUID)SecurityContextMapper.ADMIN_SECURITY_CONTEXT_UUID, (SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER);
            orientGraph = factory.getTx();
            Vertex context = ContextUtility.getContextVertexByFullName((OrientGraph)orientGraph, (String)scope);
            UUID uUID = ContextUtility.getContextUUIDFromContextVertex((Vertex)context);
            return uUID;
        }
        catch (ContextException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContextException("Unable to restrive Context UUID from current Context", (Throwable)e);
        }
        finally {
            if (orientGraph != null) {
                orientGraph.shutdown();
            }
        }
    }

    public static OrientGraphFactory getFactory(SecurityContextMapper.PermissionMode permissionMode) throws ResourceRegistryException {
        try {
            UUID contextUUID = ContextUtility.getActualContextUUID();
            return SecurityContextMapper.getSecurityContextFactory((UUID)contextUUID, (SecurityContextMapper.PermissionMode)permissionMode);
        }
        catch (ContextException ce) {
            logger.error("Unable to retrieve context.", (Throwable)ce);
            throw ce;
        }
        catch (Exception e) {
            logger.error("Unable to retrieve context.", (Throwable)e);
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public static OrientGraph getActualSecurityContextGraph(SecurityContextMapper.PermissionMode permissionMode) throws ResourceRegistryException {
        try {
            OrientGraphFactory factory = ContextUtility.getFactory((SecurityContextMapper.PermissionMode)permissionMode);
            return factory.getTx();
        }
        catch (ContextException ce) {
            logger.error("Unable to retrieve context.", (Throwable)ce);
            throw ce;
        }
        catch (Exception e) {
            logger.error("Unable to retrieve context.", (Throwable)e);
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public static OrientGraphNoTx getActualSecurityContextGraphNoTx(SecurityContextMapper.PermissionMode permissionMode) throws ResourceRegistryException {
        try {
            OrientGraphFactory factory = ContextUtility.getFactory((SecurityContextMapper.PermissionMode)permissionMode);
            return factory.getNoTx();
        }
        catch (ContextException ce) {
            logger.error("Unable to retrieve context.", (Throwable)ce);
            throw ce;
        }
        catch (Exception e) {
            logger.error("Unable to retrieve context.", (Throwable)e);
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public static ODatabaseDocumentTx getActualSecurityContextDatabaseTx(SecurityContextMapper.PermissionMode permissionMode) throws ResourceRegistryException {
        try {
            OrientGraphFactory factory = ContextUtility.getFactory((SecurityContextMapper.PermissionMode)permissionMode);
            return factory.getDatabase();
        }
        catch (ContextException ce) {
            logger.error("Unable to retrieve context.", (Throwable)ce);
            throw ce;
        }
        catch (Exception e) {
            logger.error("Unable to retrieve context.", (Throwable)e);
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public static Vertex getContextVertexByFullName(OrientGraph orientGraph, String fullName) throws ContextNotFoundException {
        logger.trace("Going to get {} {} from full name '{}'", new Object[]{"Context", Vertex.class.getSimpleName(), fullName});
        ScopeBean scopeBean = new ScopeBean(fullName);
        String name = scopeBean.name();
        String select = "SELECT FROM " + Context.class.getSimpleName() + " WHERE " + "name" + " = \"" + name + "\"";
        OSQLSynchQuery osqlSynchQuery = new OSQLSynchQuery(select);
        Iterable vertexes = (Iterable)orientGraph.command((OCommandRequest)osqlSynchQuery).execute(new Object[0]);
        if (vertexes == null || !vertexes.iterator().hasNext()) {
            throw new ContextNotFoundException("Error retrieving context with name " + fullName);
        }
        Iterator iterator = vertexes.iterator();
        Vertex context = (Vertex)iterator.next();
        logger.trace("Context Representing Vertex : {}", (Object)Utility.toJsonString((Element)context, (boolean)true));
        if (iterator.hasNext()) {
            throw new ContextNotFoundException("Found more than one context with name " + name + "but required the one with path" + fullName + ". Please Reimplement the query");
        }
        return context;
    }

    public static String getActualSecurityRoleOrUserName(SecurityContextMapper.PermissionMode permissionMode, SecurityContextMapper.SecurityType securityType) throws ContextException {
        UUID contextUUID = ContextUtility.getActualContextUUID();
        return SecurityContextMapper.getSecurityRoleOrUserName((SecurityContextMapper.PermissionMode)permissionMode, (SecurityContextMapper.SecurityType)securityType, (UUID)contextUUID);
    }
}

