/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.query;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.gcube.informationsystem.resourceregistry.api.exceptions.query.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.context.ContextUtility;
import org.gcube.informationsystem.resourceregistry.context.SecurityContextMapper;
import org.gcube.informationsystem.resourceregistry.query.Query;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryImpl
implements Query {
    private static Logger logger = LoggerFactory.getLogger(QueryImpl.class);

    public String query(String query, int limit, String fetchPlan) throws InvalidQueryException {
        limit = limit <= 0 ? -1 : limit;
        try (ODatabaseDocumentTx oDatabaseDocumentTx = null;){
            oDatabaseDocumentTx = ContextUtility.getActualSecurityContextDatabaseTx((SecurityContextMapper.PermissionMode)SecurityContextMapper.PermissionMode.READER);
            OSQLSynchQuery osqlSynchQuery = new OSQLSynchQuery(query, limit);
            osqlSynchQuery.setFetchPlan(fetchPlan);
            osqlSynchQuery.setCacheableResult(true);
            logger.debug("Going to execute query : \"{}\", fetchPlan : \"{}\", limit : {}", new Object[]{osqlSynchQuery.getText(), osqlSynchQuery.getFetchPlan(), osqlSynchQuery.getLimit()});
            List records = oDatabaseDocumentTx.query((OQuery)osqlSynchQuery, new Object[0]);
            StringWriter writer = new StringWriter();
            ((Writer)writer).append("{\"result\":[");
            for (int i = 0; i < records.size(); ++i) {
                ODocument oDocument = (ODocument)records.get(i);
                ((Writer)writer).append(Utility.toJsonString((ORecord)oDocument, (boolean)false));
                if (i >= records.size() - 1) continue;
                ((Writer)writer).append(",");
            }
            ((Writer)writer).append("]}");
            String string = ((Object)writer).toString();
            return string;
        }
    }
}

