/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.er;

import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeType;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tinkerpop.blueprints.impls.orient.OrientVertexType;
import java.util.UUID;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.er.ERNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.er.ERManagement;
import org.gcube.informationsystem.resourceregistry.er.entity.EntityManagement;
import org.gcube.informationsystem.resourceregistry.er.entity.FacetManagement;
import org.gcube.informationsystem.resourceregistry.er.entity.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.ConsistsOfManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.IsRelatedToManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.RelationManagement;
import org.gcube.informationsystem.resourceregistry.schema.SchemaManagementImpl;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ERManagementUtility {
    private static Logger logger = LoggerFactory.getLogger(EntityManagement.class);

    public static ERManagement getERManagement(String type) throws ResourceRegistryException {
        OClass oClass = SchemaManagementImpl.getTypeSchema((String)type, null);
        ResourceManagement erManagement = null;
        if (oClass.isSubClassOf("Resource")) {
            erManagement = new ResourceManagement();
        } else if (oClass.isSubClassOf("Facet")) {
            erManagement = new FacetManagement();
        } else if (oClass.isSubClassOf("ConsistsOf")) {
            erManagement = new ConsistsOfManagement();
        } else if (oClass.isSubClassOf("IsRelatedTo")) {
            erManagement = new IsRelatedToManagement();
        }
        if (erManagement == null) {
            throw new ResourceRegistryException(String.format("%s is not querable", type.toString()));
        }
        erManagement.setElementType(type);
        return erManagement;
    }

    private static ERManagement getERManagement(SecurityContext workingContext, OrientGraph orientGraph, Element element) throws ResourceRegistryException {
        if (element instanceof Vertex) {
            return ERManagementUtility.getEntityManagement((SecurityContext)workingContext, (OrientGraph)orientGraph, (Vertex)((Vertex)element));
        }
        if (element instanceof Edge) {
            return ERManagementUtility.getRelationManagement((SecurityContext)workingContext, (OrientGraph)orientGraph, (Edge)((Edge)element));
        }
        throw new ResourceRegistryException(String.format("%s is not a %s nor a %s", element.getClass().getSimpleName(), "Entity", "Relation"));
    }

    public static Element getAnyElementByUUID(UUID uuid) throws ERNotFoundException, ResourceRegistryException {
        try {
            return Utility.getElementByUUIDAsAdmin(null, (UUID)uuid, Vertex.class);
        }
        catch (ERNotFoundException e) {
            return Utility.getElementByUUIDAsAdmin(null, (UUID)uuid, Edge.class);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    private static Element getAnyElementByUUID(OrientGraph orientGraph, UUID uuid) throws ERNotFoundException, ResourceRegistryException {
        try {
            return Utility.getElementByUUID((Graph)orientGraph, null, (UUID)uuid, Vertex.class);
        }
        catch (ERNotFoundException e) {
            return Utility.getElementByUUID((Graph)orientGraph, null, (UUID)uuid, Edge.class);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public static ERManagement getERManagementFromUUID(SecurityContext workingContext, OrientGraph orientGraph, UUID uuid) throws ResourceRegistryException {
        try {
            Element element = ERManagementUtility.getAnyElementByUUID((OrientGraph)orientGraph, (UUID)uuid);
            return ERManagementUtility.getERManagement((SecurityContext)workingContext, (OrientGraph)orientGraph, (Element)element);
        }
        catch (Exception e) {
            throw new ResourceRegistryException(String.format("%s does not belong to an %s nor to a %s", uuid.toString(), "Entity", "Relation"));
        }
    }

    public static EntityManagement getEntityManagement(SecurityContext workingContext, OrientGraph orientGraph, Vertex vertex) throws ResourceRegistryException {
        if (orientGraph == null) {
            throw new ResourceRegistryException(OrientGraph.class.getSimpleName() + "instance is null. " + "This is really strange and should not occur. Please contact the system administrator.");
        }
        if (vertex == null) {
            throw new ResourceRegistryException(Vertex.class.getSimpleName() + "instance is null. " + "This is really strange and should not occur. Please contact the system administrator.");
        }
        OrientVertexType orientVertexType = null;
        try {
            orientVertexType = ((OrientVertex)vertex).getType();
        }
        catch (Exception e) {
            String error = String.format("Unable to detect type of %s. %s", vertex.toString(), "This is really strange and should not occur. Please contact the system administrator.");
            logger.error(error, (Throwable)e);
            throw new ResourceRegistryException(error);
        }
        ResourceManagement entityManagement = null;
        if (orientVertexType.isSubClassOf("Resource")) {
            entityManagement = new ResourceManagement(workingContext, orientGraph);
        } else if (orientVertexType.isSubClassOf("Facet")) {
            entityManagement = new FacetManagement(workingContext, orientGraph);
        } else {
            String error = String.format("{%s is not a %s nor a %s. %s", vertex, "Resource", "Facet", "This is really strange and should not occur. Please contact the system administrator.");
            throw new ResourceRegistryException(error);
        }
        entityManagement.setElement((Element)vertex);
        return entityManagement;
    }

    public static RelationManagement getRelationManagement(SecurityContext workingContext, OrientGraph orientGraph, Edge edge) throws ResourceRegistryException {
        if (orientGraph == null) {
            throw new ResourceRegistryException(OrientGraph.class.getSimpleName() + "instance is null. " + "This is really strange and should not occur. Please contact the system administrator.");
        }
        if (edge == null) {
            throw new ResourceRegistryException(Edge.class.getSimpleName() + "instance is null. " + "This is really strange and should not occur. Please contact the system administrator.");
        }
        OrientEdgeType orientEdgeType = ((OrientEdge)edge).getType();
        ConsistsOfManagement relationManagement = null;
        if (orientEdgeType.isSubClassOf("ConsistsOf")) {
            relationManagement = new ConsistsOfManagement(workingContext, orientGraph);
        } else if (orientEdgeType.isSubClassOf("IsRelatedTo")) {
            relationManagement = new IsRelatedToManagement(workingContext, orientGraph);
        } else {
            String error = String.format("{%s is not a %s nor a %s. %s", edge, "ConsistsOf", "IsRelatedTo", "This is really strange and should not occur. Please contact the system administrator.");
            throw new ResourceRegistryException(error);
        }
        relationManagement.setElement((Element)edge);
        return relationManagement;
    }
}

