/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.context;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.gcube.informationsystem.model.reference.AccessType;
import org.gcube.informationsystem.model.reference.entities.Context;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.EntityAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.context.ContextUtility;
import org.gcube.informationsystem.resourceregistry.context.IsParentOfManagement;
import org.gcube.informationsystem.resourceregistry.context.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.gcube.informationsystem.resourceregistry.er.ERManagement;
import org.gcube.informationsystem.resourceregistry.er.entity.EntityManagement;
import org.gcube.informationsystem.utils.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ContextManagement
extends EntityManagement<Context> {
    private static Logger logger = LoggerFactory.getLogger(ContextManagement.class);
    protected String name;

    private void init() {
        this.ignoreStartWithKeys.add("parent");
        this.ignoreStartWithKeys.add("children");
        this.elementType = "Context";
    }

    public ContextManagement() {
        super(AccessType.CONTEXT);
        this.init();
    }

    public ContextManagement(OrientGraph orientGraph) throws ResourceRegistryException {
        this();
        this.orientGraph = orientGraph;
        this.getWorkingContext();
    }

    public String getName() {
        if (this.name == null) {
            if (this.element == null) {
                if (this.jsonNode != null) {
                    this.name = this.jsonNode.get("name").asText();
                }
            } else {
                this.name = (String)((Vertex)this.element).getProperty("name");
            }
        }
        return this.name;
    }

    protected SecurityContext getWorkingContext() throws ResourceRegistryException {
        if (this.workingContext == null) {
            this.workingContext = ContextUtility.getInstance().getSecurityContextByUUID(DatabaseEnvironment.CONTEXT_SECURITY_CONTEXT_UUID);
        }
        return this.workingContext;
    }

    protected ContextNotFoundException getSpecificElementNotFoundException(NotFoundException e) {
        return new ContextNotFoundException(e.getMessage(), e.getCause());
    }

    protected EntityAvailableInAnotherContextException getSpecificERAvailableInAnotherContextException(String message) {
        return new EntityAvailableInAnotherContextException(message);
    }

    protected ContextAlreadyPresentException getSpecificERAlreadyPresentException(String message) {
        return new ContextAlreadyPresentException(message);
    }

    protected void checkContext(ContextManagement parentContext) throws ContextNotFoundException, ContextAlreadyPresentException, ResourceRegistryException {
        if (parentContext != null) {
            String parentId = ((Vertex)parentContext.getElement()).getId().toString();
            String select = "SELECT FROM (TRAVERSE out(IsParentOf) FROM " + parentId + " MAXDEPTH 1) WHERE " + "name" + "=\"" + this.getName() + "\" AND " + "header" + "." + "uuid" + "<>\"" + parentContext.uuid + "\"";
            logger.trace(select);
            StringBuilder message = new StringBuilder();
            message.append("A context with name (");
            message.append(this.getName());
            message.append(") has been already created as child of ");
            message.append(parentContext.serializeSelfOnly().toString());
            logger.trace("Checking if {} -> {}", (Object)message, (Object)select);
            OSQLSynchQuery osqlSynchQuery = new OSQLSynchQuery(select);
            Iterable vertexes = (Iterable)this.orientGraph.command((OCommandRequest)osqlSynchQuery).execute(new Object[0]);
            if (vertexes != null && vertexes.iterator().hasNext()) {
                throw new ContextAlreadyPresentException(message.toString());
            }
        } else {
            String select = "SELECT FROM Context WHERE name = \"" + this.getName() + "\" AND in(\"" + "IsParentOf" + "\").size() = 0";
            OSQLSynchQuery osqlSynchQuery = new OSQLSynchQuery(select);
            Iterable vertexes = (Iterable)this.orientGraph.command((OCommandRequest)osqlSynchQuery).execute(new Object[0]);
            if (vertexes != null && vertexes.iterator().hasNext()) {
                throw new ContextAlreadyPresentException("A root context with the same name (" + this.getName() + ") already exist");
            }
        }
    }

    public String serialize() throws ResourceRegistryException {
        return this.serializeAsJson().toString();
    }

    public JsonNode serializeAsJson() throws ResourceRegistryException {
        JsonNode context = this.serializeSelfOnly();
        int count = 0;
        Iterable parents = ((Vertex)this.getElement()).getEdges(Direction.IN, new String[0]);
        for (Edge edge : parents) {
            if (++count > 1) {
                throw new ContextException("A Context can not have more than one parent");
            }
            try {
                IsParentOfManagement isParentOfManagement = new IsParentOfManagement(this.orientGraph);
                isParentOfManagement.setElement((Element)edge);
                JsonNode isParentOf = isParentOfManagement.serializeAsJson(true, false);
                if (isParentOf == null) continue;
                ((ObjectNode)context).replace("parent", isParentOf);
            }
            catch (Exception e) {
                logger.error("Unable to correctly serialize {}. {}", (Object)edge, (Object)"This is really strange and should not occur. Please contact the system administrator.");
                throw new ContextException("");
            }
        }
        Iterable childrenEdges = ((Vertex)this.getElement()).getEdges(Direction.OUT, new String[0]);
        for (Edge edge : childrenEdges) {
            IsParentOfManagement isParentOfManagement = new IsParentOfManagement(this.orientGraph);
            isParentOfManagement.setElement((Element)edge);
            try {
                JsonNode isParentOf = isParentOfManagement.serializeAsJson();
                context = ContextManagement.addRelation((JsonNode)context, (JsonNode)isParentOf, (String)"children");
            }
            catch (ResourceRegistryException e) {
                logger.error("Unable to correctly serialize {}. {}", (Object)edge, (Object)"This is really strange and should not occur. Please contact the system administrator.");
                throw e;
            }
            catch (Exception e) {
                logger.error("Unable to correctly serialize {}. {}", (Object)edge, (Object)"This is really strange and should not occur. Please contact the system administrator.");
                throw new ResourceRegistryException((Throwable)e);
            }
        }
        return context;
    }

    protected Vertex reallyCreate() throws AlreadyPresentException, ResourceRegistryException {
        SecurityContext securityContext = null;
        SecurityContext parentSecurityContext = null;
        try {
            JsonNode isParentOfJsonNode = this.jsonNode.get("parent");
            if (isParentOfJsonNode != null && !(isParentOfJsonNode instanceof NullNode)) {
                JsonNode parentJsonNode = isParentOfJsonNode.get("source");
                ContextManagement parentContextManagement = new ContextManagement(this.orientGraph);
                parentContextManagement.setJsonNode(parentJsonNode);
                UUID parentUUID = parentContextManagement.uuid;
                parentSecurityContext = ContextUtility.getInstance().getSecurityContextByUUID(parentUUID);
                this.checkContext(parentContextManagement);
                if (this.uuid == null) {
                    this.uuid = UUID.randomUUID();
                }
                this.createVertex();
                IsParentOfManagement isParentOfManagement = new IsParentOfManagement(this.orientGraph);
                isParentOfManagement.setJsonNode(isParentOfJsonNode);
                isParentOfManagement.setSourceEntityManagement((EntityManagement)parentContextManagement);
                isParentOfManagement.setTargetEntityManagement((EntityManagement)this);
                isParentOfManagement.internalCreate();
            } else {
                this.checkContext(null);
                this.createVertex();
            }
            securityContext = new SecurityContext(this.uuid);
            securityContext.setParentSecurityContext(parentSecurityContext);
            securityContext.create(this.orientGraph);
            ContextUtility.getInstance().addSecurityContext(securityContext);
            return (Vertex)this.getElement();
        }
        catch (Exception e) {
            this.orientGraph.rollback();
            if (securityContext != null) {
                securityContext.delete(this.orientGraph);
                if (parentSecurityContext != null && securityContext != null) {
                    parentSecurityContext.getChildren().remove(securityContext);
                }
                ContextUtility.getInstance().removeFromCache(this.uuid, false);
            }
            throw e;
        }
    }

    protected Vertex reallyUpdate() throws NotFoundException, ResourceRegistryException {
        boolean parentChanged = false;
        boolean nameChanged = false;
        Vertex parent = null;
        boolean found = false;
        Iterable iterable = ((Vertex)this.getElement()).getVertices(Direction.IN, new String[]{"IsParentOf"});
        for (Vertex p : iterable) {
            if (found) {
                String message = String.format("{} has more than one parent. {}", "Context", "This is really strange and should not occur. Please contact the system administrator.");
                throw new ResourceRegistryException(message.toString());
            }
            parent = p;
            found = true;
        }
        ContextManagement actualParentContextManagement = null;
        if (parent != null) {
            actualParentContextManagement = new ContextManagement(this.orientGraph);
            actualParentContextManagement.setElement((Element)parent);
        }
        ContextManagement newParentContextManagement = actualParentContextManagement;
        JsonNode isParentOfJsonNode = this.jsonNode.get("parent");
        JsonNode parentContextJsonNode = null;
        if (isParentOfJsonNode != null && !(isParentOfJsonNode instanceof NullNode)) {
            parentContextJsonNode = isParentOfJsonNode.get("source");
        }
        if (parentContextJsonNode != null && !(parentContextJsonNode instanceof NullNode)) {
            UUID parentUUID = Utility.getUUIDFromJsonNode((JsonNode)parentContextJsonNode);
            if (actualParentContextManagement != null) {
                if (parentUUID.compareTo(actualParentContextManagement.uuid) != 0) {
                    parentChanged = true;
                }
            } else {
                parentChanged = true;
            }
            if (parentChanged) {
                newParentContextManagement = new ContextManagement(this.orientGraph);
                newParentContextManagement.setJsonNode(parentContextJsonNode);
            }
        } else if (actualParentContextManagement != null) {
            parentChanged = true;
            newParentContextManagement = null;
        }
        String oldName = (String)((Vertex)this.getElement()).getProperty("name");
        String newName = this.jsonNode.get("name").asText();
        if (oldName.compareTo(newName) != 0) {
            nameChanged = true;
            this.name = newName;
        }
        if (parentChanged || nameChanged) {
            this.checkContext(newParentContextManagement);
        }
        if (parentChanged) {
            this.move(newParentContextManagement, false);
        }
        this.element = (Vertex)ERManagement.updateProperties((OClass)this.oClass, (Element)this.getElement(), (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
        ContextUtility.getInstance().removeFromCache(this.uuid, nameChanged && !parentChanged);
        return (Vertex)this.element;
    }

    private void move(ContextManagement newParentContextManagement, boolean check) throws ContextNotFoundException, ContextAlreadyPresentException, ResourceRegistryException {
        if (check) {
            this.checkContext(newParentContextManagement);
        }
        SecurityContext newParentSecurityContext = null;
        Iterable edges = ((Vertex)this.getElement()).getEdges(Direction.IN, new String[]{"IsParentOf"});
        if (edges != null && edges.iterator().hasNext()) {
            Iterator edgeIterator = edges.iterator();
            Edge edge = (Edge)edgeIterator.next();
            IsParentOfManagement isParentOfManagement = new IsParentOfManagement();
            isParentOfManagement.setElement((Element)edge);
            isParentOfManagement.internalDelete();
            if (edgeIterator.hasNext()) {
                throw new ContextException("Seems that the Context has more than one Parent. This is really strange and should not occur. Please contact the system administrator.");
            }
        }
        if (newParentContextManagement != null) {
            JsonNode isParentOfJsonNode = this.jsonNode.get("parent");
            IsParentOfManagement isParentOfManagement = new IsParentOfManagement(this.orientGraph);
            isParentOfManagement.setJsonNode(isParentOfJsonNode);
            isParentOfManagement.setSourceEntityManagement((EntityManagement)newParentContextManagement);
            isParentOfManagement.setTargetEntityManagement((EntityManagement)this);
            isParentOfManagement.internalCreate();
            newParentSecurityContext = ContextUtility.getInstance().getSecurityContextByUUID(newParentContextManagement.uuid);
        }
        SecurityContext thisSecurityContext = ContextUtility.getInstance().getSecurityContextByUUID(this.uuid);
        thisSecurityContext.changeParentSecurityContext(newParentSecurityContext, this.orientGraph);
    }

    protected boolean reallyDelete() throws NotFoundException, ResourceRegistryException {
        Iterable iterable = ((Vertex)this.getElement()).getEdges(Direction.OUT, new String[0]);
        Iterator iterator = iterable.iterator();
        if (iterator.hasNext()) {
            throw new ContextException("Cannot remove a Context having children");
        }
        ((Vertex)this.element).remove();
        ContextUtility contextUtility = ContextUtility.getInstance();
        SecurityContext securityContext = contextUtility.getSecurityContextByUUID(this.uuid);
        securityContext.delete(this.orientGraph);
        contextUtility.removeFromCache(this.uuid, false);
        return true;
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayNode arrayNode = objectMapper.createArrayNode();
        Iterable iterable = this.orientGraph.getVerticesOfClass(this.elementType, polymorphic);
        for (Vertex vertex : iterable) {
            ContextManagement contextManagement = new ContextManagement();
            contextManagement.setElement((Element)vertex);
            try {
                JsonNode jsonObject = contextManagement.serializeAsJson();
                arrayNode.add(jsonObject);
            }
            catch (ResourceRegistryException e) {
                logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)vertex.toString(), (Object)"This is really strange and should not occur. Please contact the system administrator.");
            }
        }
        try {
            return objectMapper.writeValueAsString((Object)arrayNode);
        }
        catch (JsonProcessingException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }
}

