/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.er.entity;

import com.fasterxml.jackson.databind.JsonNode;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeType;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import org.gcube.informationsystem.model.reference.AccessType;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.er.entity.EntityManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.ConsistsOfManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.IsRelatedToManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.RelationManagement;
import org.gcube.informationsystem.resourceregistry.utils.Utility;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceManagement
extends EntityManagement<Resource> {
    public ResourceManagement() {
        super(AccessType.RESOURCE);
    }

    public ResourceManagement(SecurityContext workingContext, OrientGraph orientGraph) {
        super(AccessType.RESOURCE, workingContext, orientGraph);
    }

    protected ResourceNotFoundException getSpecificElementNotFoundException(NotFoundException e) {
        return new ResourceNotFoundException(e.getMessage(), e.getCause());
    }

    protected ResourceAvailableInAnotherContextException getSpecificERAvailableInAnotherContextException(String message) {
        return new ResourceAvailableInAnotherContextException(message);
    }

    protected ResourceAlreadyPresentException getSpecificERAlreadyPresentException(String message) {
        return new ResourceAlreadyPresentException(message);
    }

    public String serialize() throws ResourceRegistryException {
        return this.serializeAsJson().toString();
    }

    public JsonNode serializeAsJson() throws ResourceRegistryException {
        JsonNode sourceResource = this.serializeSelfOnly();
        Iterable edges = ((Vertex)this.getElement()).getEdges(Direction.OUT, new String[0]);
        for (Edge edge : edges) {
            RelationManagement relationManagement = this.getRelationManagement(edge);
            relationManagement.setReload(this.reload);
            if (relationManagement.giveMeSourceEntityManagementAsIs() == null) {
                relationManagement.setSourceEntityManagement((EntityManagement)this);
            }
            if (relationManagement.giveMeSourceEntityManagementAsIs() != this) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append("SourceEntityManagement for ");
                errorMessage.append(relationManagement.getClass().getSimpleName());
                errorMessage.append(" is not the one expected. ");
                errorMessage.append("This is really strange and should not occur. Please contact the system administrator.");
                throw new ResourceRegistryException(errorMessage.toString());
            }
            if (!(relationManagement instanceof ConsistsOfManagement)) continue;
            try {
                JsonNode consistsOf = relationManagement.serializeAsJson(true, true);
                sourceResource = ResourceManagement.addConsistsOf((JsonNode)sourceResource, (JsonNode)consistsOf);
            }
            catch (ResourceRegistryException e) {
                this.logger.error("Unable to correctly serialize {}. {}", (Object)edge, (Object)"This is really strange and should not occur. Please contact the system administrator.");
                throw e;
            }
            catch (Exception e) {
                this.logger.error("Unable to correctly serialize {}. {}", (Object)edge, (Object)"This is really strange and should not occur. Please contact the system administrator.");
                throw new ResourceRegistryException((Throwable)e);
            }
        }
        return sourceResource;
    }

    public static JsonNode addConsistsOf(JsonNode sourceResource, JsonNode consistsOf) throws ResourceRegistryException {
        return ResourceManagement.addRelation((JsonNode)sourceResource, (JsonNode)consistsOf, (String)AccessType.CONSISTS_OF.lowerCaseFirstCharacter());
    }

    public static JsonNode addIsRelatedTo(JsonNode sourceResource, JsonNode isRelatedTo) throws ResourceRegistryException {
        return ResourceManagement.addRelation((JsonNode)sourceResource, (JsonNode)isRelatedTo, (String)AccessType.IS_RELATED_TO.lowerCaseFirstCharacter());
    }

    protected Vertex reallyCreate() throws ResourceAlreadyPresentException, ResourceRegistryException {
        JsonNode jsonNodeArray;
        this.createVertex();
        String property = AccessType.CONSISTS_OF.lowerCaseFirstCharacter();
        if (this.jsonNode.has(property)) {
            jsonNodeArray = this.jsonNode.get(property);
            for (JsonNode consistOfJsonNode : jsonNodeArray) {
                ConsistsOfManagement com = new ConsistsOfManagement(this.getWorkingContext(), this.orientGraph);
                com.setJsonNode(consistOfJsonNode);
                com.setSourceEntityManagement((EntityManagement)this);
                com.internalCreate();
                this.addToRelationManagement((RelationManagement)com);
            }
        }
        if (this.jsonNode.has(property = AccessType.IS_RELATED_TO.lowerCaseFirstCharacter())) {
            jsonNodeArray = this.jsonNode.get(property);
            for (JsonNode relationJsonNode : jsonNodeArray) {
                IsRelatedToManagement irtm = new IsRelatedToManagement(this.getWorkingContext(), this.orientGraph);
                irtm.setJsonNode(relationJsonNode);
                irtm.setSourceEntityManagement((EntityManagement)this);
                irtm.internalCreate();
                this.addToRelationManagement((RelationManagement)irtm);
            }
        }
        return (Vertex)this.element;
    }

    protected Vertex reallyUpdate() throws ResourceNotFoundException, ResourceRegistryException {
        JsonNode jsonNodeArray;
        this.getElement();
        String property = AccessType.CONSISTS_OF.lowerCaseFirstCharacter();
        if (this.jsonNode.has(property)) {
            jsonNodeArray = this.jsonNode.get(property);
            for (JsonNode relationJsonNode : jsonNodeArray) {
                ConsistsOfManagement com = new ConsistsOfManagement(this.getWorkingContext(), this.orientGraph);
                com.setJsonNode(relationJsonNode);
                com.internalCreateOrUdate();
                this.addToRelationManagement((RelationManagement)com);
            }
        }
        if (this.jsonNode.has(property = AccessType.IS_RELATED_TO.lowerCaseFirstCharacter())) {
            jsonNodeArray = this.jsonNode.get(property);
            for (JsonNode relationJsonNode : jsonNodeArray) {
                IsRelatedToManagement irtm = new IsRelatedToManagement(this.getWorkingContext(), this.orientGraph);
                irtm.setJsonNode(relationJsonNode);
                irtm.internalUpdate();
                this.addToRelationManagement((RelationManagement)irtm);
            }
        }
        return (Vertex)this.element;
    }

    protected boolean reallyDelete() throws ResourceNotFoundException, ResourceRegistryException {
        this.getElement();
        Iterable iterable = ((Vertex)this.element).getEdges(Direction.OUT, new String[0]);
        for (Edge edge : iterable) {
            OrientEdgeType orientEdgeType = ((OrientEdge)edge).getType();
            IsRelatedToManagement relationManagement = null;
            if (orientEdgeType.isSubClassOf("IsRelatedTo")) {
                relationManagement = new IsRelatedToManagement(this.getWorkingContext(), this.orientGraph);
            } else if (orientEdgeType.isSubClassOf("ConsistsOf")) {
                relationManagement = new ConsistsOfManagement(this.getWorkingContext(), this.orientGraph);
            } else {
                this.logger.warn("{} is not a {} nor a {}. {}", new Object[]{Utility.toJsonString((Element)edge, (boolean)true), "IsRelatedTo", "ConsistsOf", "This is really strange and should not occur. Please contact the system administrator."});
            }
            if (relationManagement == null) continue;
            relationManagement.setElement((Element)edge);
            relationManagement.internalDelete();
        }
        ((Vertex)this.element).remove();
        return true;
    }

    public String all(boolean polymorphic) throws ResourceRegistryException {
        try {
            this.orientGraph = this.getWorkingContext().getGraph(SecurityContext.PermissionMode.READER);
            String string = this.reallyGetAll(polymorphic);
            return string;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }
}

