/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.er.relation;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.informationsystem.model.reference.AccessType;
import org.gcube.informationsystem.model.reference.entities.Entity;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.informationsystem.model.reference.relations.Relation;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relation.RelationNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaException;
import org.gcube.informationsystem.resourceregistry.context.ContextUtility;
import org.gcube.informationsystem.resourceregistry.context.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.er.ERManagement;
import org.gcube.informationsystem.resourceregistry.er.ERManagementUtility;
import org.gcube.informationsystem.resourceregistry.er.entity.EntityManagement;
import org.gcube.informationsystem.resourceregistry.er.entity.FacetManagement;
import org.gcube.informationsystem.resourceregistry.er.entity.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.ConsistsOfManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.IsRelatedToManagement;
import org.gcube.informationsystem.resourceregistry.er.relation.RelationManagement;
import org.gcube.informationsystem.resourceregistry.utils.PropagationConstraintOrient;
import org.gcube.informationsystem.resourceregistry.utils.Utility;
import org.gcube.informationsystem.utils.ISMapper;

public abstract class RelationManagement<R extends Relation, S extends EntityManagement, T extends EntityManagement>
extends ERManagement<R, Edge> {
    protected final Class<? extends Entity> targetEntityClass;
    protected S sourceEntityManagement;
    protected T targetEntityManagement;
    public final PropagationConstraint defaultPropagationConstraint;

    protected RelationManagement(AccessType accessType, PropagationConstraint defaultPropagationConstraint) {
        super(accessType);
        this.ignoreKeys.add("header");
        this.ignoreKeys.add("target");
        this.ignoreKeys.add("source");
        this.ignoreKeys.add("in".toLowerCase());
        this.ignoreKeys.add("out".toLowerCase());
        this.ignoreKeys.add("in".toUpperCase());
        this.ignoreKeys.add("out".toUpperCase());
        switch (1.$SwitchMap$org$gcube$informationsystem$model$reference$AccessType[accessType.ordinal()]) {
            case 1: {
                this.targetEntityClass = Facet.class;
                break;
            }
            case 2: {
                this.targetEntityClass = Resource.class;
                break;
            }
            default: {
                this.targetEntityClass = Resource.class;
            }
        }
        this.sourceEntityManagement = null;
        this.targetEntityManagement = null;
        this.defaultPropagationConstraint = defaultPropagationConstraint;
    }

    protected RelationManagement(AccessType accessType, SecurityContext workingContext, OrientGraph orientGraph, PropagationConstraint defaultPropagationConstraint) {
        this(accessType, defaultPropagationConstraint);
        this.orientGraph = orientGraph;
        this.setWorkingContext(workingContext);
    }

    public S giveMeSourceEntityManagementAsIs() throws ResourceRegistryException {
        return (S)this.sourceEntityManagement;
    }

    public S getSourceEntityManagement() throws ResourceRegistryException {
        if (this.sourceEntityManagement == null) {
            Vertex source = ((Edge)this.getElement()).getVertex(Direction.OUT);
            this.sourceEntityManagement = this.newSourceEntityManagement();
            this.sourceEntityManagement.setElement((Element)source);
        }
        this.sourceEntityManagement.setReload(this.reload);
        return (S)this.sourceEntityManagement;
    }

    public T getTargetEntityManagement() throws ResourceRegistryException {
        if (this.targetEntityManagement == null) {
            Vertex target = ((Edge)this.getElement()).getVertex(Direction.IN);
            this.targetEntityManagement = this.newTargetEntityManagement();
            this.targetEntityManagement.setElement((Element)target);
        }
        this.targetEntityManagement.setReload(this.reload);
        return (T)this.targetEntityManagement;
    }

    public void setSourceEntityManagement(S sourceEntityManagement) {
        this.sourceEntityManagement = sourceEntityManagement;
    }

    public void setTargetEntityManagement(T targetEntityManagement) {
        this.targetEntityManagement = targetEntityManagement;
    }

    public String serialize() throws ResourceRegistryException {
        return this.serializeAsJson().toString();
    }

    public JsonNode serializeAsJson() throws ResourceRegistryException {
        return this.serializeAsJson(true, true);
    }

    public JsonNode serializeAsJson(boolean includeSource, boolean includeTarget) throws ResourceRegistryException {
        JsonNode relation = this.serializeSelfOnly();
        try {
            if (includeSource) {
                EntityManagement sourceEntityManagement = this.getSourceEntityManagement();
                ((ObjectNode)relation).replace("source", sourceEntityManagement.serializeSelfOnly());
            }
            if (includeTarget) {
                EntityManagement targetEntityManagement = this.getTargetEntityManagement();
                ((ObjectNode)relation).replace("target", targetEntityManagement.serializeAsJson());
            }
        }
        catch (ResourceRegistryException e) {
            this.logger.error("Unable to correctly serialize {}. {}", new Object[]{this.element, "This is really strange and should not occur. Please contact the system administrator.", e});
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Unable to correctly serialize {}. {}", new Object[]{this.element, "This is really strange and should not occur. Please contact the system administrator.", e});
            throw new ResourceRegistryException((Throwable)e);
        }
        return relation;
    }

    protected Map<String, JsonNode> fullSerialize(Map<String, JsonNode> visitedSourceResources) throws ResourceRegistryException {
        Vertex source = ((Edge)this.getElement()).getVertex(Direction.OUT);
        String id = source.getId().toString();
        JsonNode sourceResource = visitedSourceResources.get(id);
        ResourceManagement resourceManagement = null;
        if (sourceResource == null) {
            resourceManagement = (ResourceManagement)ERManagementUtility.getEntityManagement((SecurityContext)this.getWorkingContext(), (OrientGraph)this.orientGraph, (Vertex)source);
            if (this instanceof IsRelatedToManagement) {
                sourceResource = resourceManagement.serializeAsJson();
            } else if (this instanceof ConsistsOfManagement) {
                sourceResource = resourceManagement.serializeSelfOnly();
            } else {
                String error = String.format("{%s is not a %s nor a %s. %s", this, IsRelatedToManagement.class.getSimpleName(), ConsistsOfManagement.class.getSimpleName(), "This is really strange and should not occur. Please contact the system administrator.");
                throw new ResourceRegistryException(error);
            }
        }
        if (this instanceof IsRelatedToManagement) {
            sourceResource = ResourceManagement.addIsRelatedTo((JsonNode)sourceResource, (JsonNode)this.serializeAsJson());
        } else if (this instanceof ConsistsOfManagement) {
            sourceResource = ResourceManagement.addConsistsOf((JsonNode)sourceResource, (JsonNode)this.serializeAsJson());
        } else {
            String error = String.format("{%s is not a %s nor a %s. %s", this, IsRelatedToManagement.class.getSimpleName(), ConsistsOfManagement.class.getSimpleName(), "This is really strange and should not occur. Please contact the system administrator.");
            throw new ResourceRegistryException(error);
        }
        visitedSourceResources.put(id, sourceResource);
        return visitedSourceResources;
    }

    protected PropagationConstraintOrient getPropagationConstraint(ODocument oDocument) throws ResourceRegistryException {
        PropagationConstraintOrient propagationConstraintOrient = new PropagationConstraintOrient();
        PropagationConstraint propagationConstraint = null;
        if (oDocument == null) {
            propagationConstraint = this.defaultPropagationConstraint;
        } else if (oDocument instanceof PropagationConstraintOrient) {
            propagationConstraint = (PropagationConstraint)oDocument;
        } else {
            try {
                propagationConstraint = (PropagationConstraint)ISMapper.unmarshal(PropagationConstraint.class, (String)oDocument.toJSON());
            }
            catch (Exception e) {
                this.logger.warn("Unable to recreate {}. {}", (Object)"PropagationConstraint", (Object)"This is really strange and should not occur. Please contact the system administrator.");
            }
        }
        PropagationConstraint.AddConstraint addConstraint = propagationConstraint.getAddConstraint();
        if (addConstraint == null) {
            addConstraint = this.defaultPropagationConstraint.getAddConstraint();
            this.logger.warn("Unable to get {}. Default value ({}) will be used", (Object)PropagationConstraint.AddConstraint.class.getSimpleName(), (Object)addConstraint);
        }
        propagationConstraintOrient.setAddConstraint(addConstraint);
        PropagationConstraint.RemoveConstraint removeConstraint = propagationConstraint.getRemoveConstraint();
        if (removeConstraint == null) {
            removeConstraint = this.defaultPropagationConstraint.getRemoveConstraint();
            this.logger.warn("Unable to get {}. Default value ({}) will be used", (Object)PropagationConstraint.RemoveConstraint.class.getSimpleName(), (Object)removeConstraint);
        }
        propagationConstraintOrient.setRemoveConstraint(removeConstraint);
        return propagationConstraintOrient;
    }

    protected void checkPropagationConstraint() throws ResourceRegistryException {
        OrientElement orientElement = (OrientElement)this.element;
        Object object = orientElement.getProperty("propagationConstraint");
        PropagationConstraintOrient pc = this.getPropagationConstraint((ODocument)object);
        orientElement.setProperty("propagationConstraint", (Object)pc, OType.EMBEDDED);
    }

    protected Edge reallyCreate() throws ResourceRegistryException {
        if (this.sourceEntityManagement == null) {
            if (!this.jsonNode.has("source")) {
                throw new ResourceRegistryException("Error while creating relation. No source definition found");
            }
            UUID sourceUUID = org.gcube.informationsystem.utils.Utility.getUUIDFromJsonNode((JsonNode)this.jsonNode.get("source"));
            this.sourceEntityManagement = this.newSourceEntityManagement();
            this.sourceEntityManagement.setUUID(sourceUUID);
        }
        if (this.targetEntityManagement == null) {
            this.targetEntityManagement = this.newTargetEntityManagement();
            if (!this.jsonNode.has("target")) {
                throw new ResourceRegistryException("Error while creating " + this.elementType + ". No target definition found");
            }
            try {
                this.targetEntityManagement.setJsonNode(this.jsonNode.get("target"));
            }
            catch (SchemaException e) {
                StringBuilder errorMessage = new StringBuilder();
                errorMessage.append("A ");
                errorMessage.append(this.elementType);
                errorMessage.append(" can be only created beetween ");
                errorMessage.append(this.sourceEntityManagement.getAccessType().getName());
                errorMessage.append(" and ");
                errorMessage.append(this.targetEntityManagement.getAccessType().getName());
                throw new ResourceRegistryException(errorMessage.toString(), (Throwable)e);
            }
            try {
                this.targetEntityManagement.getElement();
            }
            catch (Exception e) {
                this.targetEntityManagement.internalCreate();
            }
        }
        this.logger.trace("Creating {} beetween {} -> {}", new Object[]{this.elementType, this.getSourceEntityManagement().serialize(), this.getTargetEntityManagement().serialize()});
        Vertex source = (Vertex)this.getSourceEntityManagement().getElement();
        Vertex target = (Vertex)this.getTargetEntityManagement().getElement();
        this.element = this.orientGraph.addEdge(null, source, target, this.elementType);
        ERManagement.updateProperties((OClass)this.oClass, (Element)this.element, (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
        this.checkPropagationConstraint();
        this.logger.info("{} successfully created", (Object)this.elementType);
        return (Edge)this.element;
    }

    protected abstract S newSourceEntityManagement() throws ResourceRegistryException;

    protected abstract T newTargetEntityManagement() throws ResourceRegistryException;

    protected Edge reallyUpdate() throws ResourceRegistryException {
        JsonNode target;
        this.logger.debug("Trying to update {} : {}", (Object)this.elementType, (Object)this.jsonNode);
        Edge edge = (Edge)this.getElement();
        ERManagement.updateProperties((OClass)this.oClass, (Element)edge, (JsonNode)this.jsonNode, (Set)this.ignoreKeys, (Set)this.ignoreStartWithKeys);
        if (this.accessType.compareTo((Enum)AccessType.CONSISTS_OF) == 0 && (target = this.jsonNode.get("target")) != null) {
            FacetManagement fm = new FacetManagement(this.getWorkingContext(), this.orientGraph);
            fm.setJsonNode(target);
            fm.internalUpdate();
        }
        this.logger.info("{} {} successfully updated", (Object)this.elementType, (Object)this.jsonNode);
        return edge;
    }

    protected boolean reallyAddToContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        this.getElement();
        PropagationConstraint.AddConstraint addConstraint = PropagationConstraint.AddConstraint.unpropagate;
        try {
            PropagationConstraint propagationConstraint = (PropagationConstraint)Utility.getPropertyDocument(PropagationConstraint.class, (Element)this.element, (String)"propagationConstraint");
            if (propagationConstraint.getAddConstraint() == null) {
                String error = String.format("%s.%s in %s is null. %s", "propagationConstraint", "add", Utility.toJsonString((Element)this.element, (boolean)true), "This is really strange and should not occur. Please contact the system administrator.");
                this.logger.error(error);
                throw new ResourceRegistryException(error);
            }
            addConstraint = propagationConstraint.getAddConstraint();
        }
        catch (Exception e) {
            String error = String.format("Error while getting %s from %s while performing AddToContext. %s", "propagationConstraint", Utility.toJsonString((Element)this.element, (boolean)true), "This is really strange and should not occur. Please contact the system administrator.");
            this.logger.warn(error);
            throw new ResourceRegistryException(error, (Throwable)e);
        }
        switch (1.$SwitchMap$org$gcube$informationsystem$model$reference$properties$PropagationConstraint$AddConstraint[addConstraint.ordinal()]) {
            case 1: {
                this.getTargetEntityManagement().internalAddToContext(targetSecurityContext);
                targetSecurityContext.addElement(this.getElement(), this.orientGraph);
                break;
            }
            case 2: {
                break;
            }
        }
        return true;
    }

    public boolean forcedAddToContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        this.getElement();
        this.getSourceEntityManagement().internalAddToContext(targetSecurityContext);
        this.getTargetEntityManagement().internalAddToContext(targetSecurityContext);
        targetSecurityContext.addElement(this.getElement(), this.orientGraph);
        return true;
    }

    protected boolean reallyRemoveFromContext(SecurityContext targetSecurityContext) throws ContextException, ResourceRegistryException {
        this.getElement();
        PropagationConstraint.RemoveConstraint removeConstraint = PropagationConstraint.RemoveConstraint.keep;
        try {
            PropagationConstraint propagationConstraint = (PropagationConstraint)Utility.getPropertyDocument(PropagationConstraint.class, (Element)this.element, (String)"propagationConstraint");
            if (propagationConstraint.getRemoveConstraint() == null) {
                String error = String.format("%s.%s in %s is null. %s", "propagationConstraint", "remove", Utility.toJsonString((Element)this.element, (boolean)true), "This is really strange and should not occur. Please contact the system administrator.");
                this.logger.error(error);
                throw new ResourceRegistryException(error);
            }
            removeConstraint = propagationConstraint.getRemoveConstraint();
        }
        catch (Exception e) {
            String error = String.format("Error while getting %s from %s while performing RemoveFromContext. %s", "propagationConstraint", Utility.toJsonString((Element)this.element, (boolean)true), "This is really strange and should not occur. Please contact the system administrator.");
            this.logger.error(error);
            throw new ResourceRegistryException(error, (Throwable)e);
        }
        targetSecurityContext.removeElement(this.getElement(), this.orientGraph);
        switch (1.$SwitchMap$org$gcube$informationsystem$model$reference$properties$PropagationConstraint$RemoveConstraint[removeConstraint.ordinal()]) {
            case 1: {
                this.getTargetEntityManagement().internalRemoveFromContext(targetSecurityContext);
                break;
            }
            case 2: {
                Vertex target = (Vertex)this.getTargetEntityManagement().getElement();
                Iterable iterable = target.getEdges(Direction.IN, new String[0]);
                Iterator iterator = iterable.iterator();
                int count = 0;
                OrientEdge edge = null;
                while (iterator.hasNext()) {
                    OrientEdge thisOrientEdge;
                    edge = (OrientEdge)iterator.next();
                    if (edge.compareTo((OIdentifiable)(thisOrientEdge = (OrientEdge)this.getElement())) == 0 || thisOrientEdge.getOutVertex().compareTo((Object)edge.getOutVertex()) == 0) continue;
                    ++count;
                    break;
                }
                if (count > 0) {
                    this.logger.trace("{} point to {} which is not orphan ({} exists). Giving {} directive, it will be not remove from .", new Object[]{this.element, target, edge, removeConstraint, targetSecurityContext});
                    break;
                }
                this.getTargetEntityManagement().internalRemoveFromContext(targetSecurityContext);
                break;
            }
            case 3: {
                break;
            }
        }
        return true;
    }

    protected boolean reallyDelete() throws RelationNotFoundException, ResourceRegistryException {
        this.logger.debug("Going to remove {} with UUID {}. Related {}s will be detached.", new Object[]{this.accessType.getName(), this.uuid, this.targetEntityClass.getSimpleName()});
        this.getElement();
        PropagationConstraint.RemoveConstraint removeConstraint = PropagationConstraint.RemoveConstraint.keep;
        try {
            PropagationConstraint propagationConstraint = (PropagationConstraint)Utility.getPropertyDocument(PropagationConstraint.class, (Element)this.element, (String)"propagationConstraint");
            if (propagationConstraint.getRemoveConstraint() == null) {
                String error = String.format("%s.%s in %s is null. %s", "propagationConstraint", "remove", Utility.toJsonString((Element)this.element, (boolean)true), "This is really strange and should not occur. Please contact the system administrator.");
                this.logger.error(error);
                throw new ResourceRegistryException(error);
            }
            removeConstraint = propagationConstraint.getRemoveConstraint();
        }
        catch (Exception e) {
            this.logger.warn("Error while getting {} from {}. Assuming {}. {}", new Object[]{"propagationConstraint", Utility.toJsonString((Element)this.element, (boolean)true), removeConstraint, "This is really strange and should not occur. Please contact the system administrator."});
        }
        Vertex target = (Vertex)this.getTargetEntityManagement().getElement();
        ((Edge)this.element).remove();
        switch (1.$SwitchMap$org$gcube$informationsystem$model$reference$properties$PropagationConstraint$RemoveConstraint[removeConstraint.ordinal()]) {
            case 1: {
                this.getTargetEntityManagement().internalDelete();
                break;
            }
            case 2: {
                Iterable iterable = target.getEdges(Direction.IN, new String[0]);
                Iterator iterator = iterable.iterator();
                if (iterator.hasNext()) {
                    this.logger.trace("{} point to {} which is not orphan. Giving {} directive, it will be keep.", new Object[]{this.element, target, removeConstraint});
                    break;
                }
                this.getTargetEntityManagement().internalDelete();
                break;
            }
            case 3: {
                break;
            }
        }
        return true;
    }

    protected Collection<JsonNode> serializeEdges(Iterable<Edge> edges, boolean postFilterPolymorphic) throws ResourceRegistryException {
        Map visitedSourceResources = new HashMap();
        for (Edge edge : edges) {
            if (postFilterPolymorphic && edge.getLabel().compareTo(this.elementType) != 0) continue;
            RelationManagement relationManagement = ERManagementUtility.getRelationManagement((SecurityContext)this.getWorkingContext(), (OrientGraph)this.orientGraph, (Edge)edge);
            visitedSourceResources = relationManagement.fullSerialize(visitedSourceResources);
        }
        return visitedSourceResources.values();
    }

    protected String serializeJsonNodeCollectionAsString(Collection<JsonNode> collection) throws ResourceRegistryException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            ArrayNode arrayNode = (ArrayNode)objectMapper.valueToTree(collection);
            return objectMapper.writeValueAsString((Object)arrayNode);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        Iterable edges = this.orientGraph.getEdgesOfClass(this.elementType, polymorphic);
        Collection collection = this.serializeEdges(edges, false);
        return this.serializeJsonNodeCollectionAsString(collection);
    }

    public boolean addToContext(UUID contextUUID) throws NotFoundException, ContextException {
        this.logger.debug("Going to add {} with UUID {} to Context with UUID {}", new Object[]{this.accessType.getName(), this.uuid, contextUUID});
        try {
            this.orientGraph = ContextUtility.getAdminSecurityContext().getGraph(SecurityContext.PermissionMode.WRITER);
            SecurityContext targetSecurityContext = ContextUtility.getInstance().getSecurityContextByUUID(contextUUID);
            boolean added = this.forcedAddToContext(targetSecurityContext);
            this.orientGraph.commit();
            this.logger.info("{} with UUID {} successfully added to Context with UUID {}", new Object[]{this.accessType.getName(), this.uuid, contextUUID});
            boolean bl = added;
            return bl;
        }
        catch (Exception e) {
            this.logger.error("Unable to add {} with UUID {} to Context with UUID {}", new Object[]{this.accessType.getName(), this.uuid, contextUUID, e});
            if (this.orientGraph != null) {
                this.orientGraph.rollback();
            }
            throw new ContextException((Throwable)e);
        }
        finally {
            if (this.orientGraph != null) {
                this.orientGraph.shutdown();
            }
        }
    }
}

