/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;
import java.util.Iterator;
import java.util.UUID;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.context.ContextUtility;
import org.gcube.informationsystem.resourceregistry.context.security.AdminSecurityContext;
import org.gcube.informationsystem.resourceregistry.context.security.SecurityContext;
import org.gcube.informationsystem.resourceregistry.utils.HeaderUtility;
import org.gcube.informationsystem.utils.ISMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utility {
    private static final Logger logger = LoggerFactory.getLogger(Utility.class);
    public static final String SHOULD_NOT_OCCUR_ERROR_MESSAGE = "This is really strange and should not occur. Please contact the system administrator.";

    public static JsonNode toJsonNode(Element element, boolean raw) throws ResourceRegistryException {
        ODocument oRecord = ((OrientElement)element).getRecord();
        return Utility.toJsonNode((ORecord)oRecord, (boolean)raw);
    }

    public static JsonNode toJsonNode(ORecord oRecord, boolean raw) throws ResourceRegistryException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.readTree(Utility.toJsonString((ORecord)oRecord, (boolean)raw));
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public static String toJsonString(Element element, boolean raw) {
        ODocument oRecord = ((OrientElement)element).getRecord();
        return Utility.toJsonString((ORecord)oRecord, (boolean)raw);
    }

    public static String toJsonString(ORecord oRecord, boolean raw) {
        if (raw) {
            return oRecord.toJSON();
        }
        return oRecord.toJSON("class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <El extends Element> El getElementByUUIDAsAdmin(String elementType, UUID uuid, Class<? extends El> clz) throws NotFoundException, ResourceRegistryException {
        OrientGraphNoTx orientGraphNoTx = null;
        try {
            AdminSecurityContext adminSecurityContext = ContextUtility.getAdminSecurityContext();
            orientGraphNoTx = adminSecurityContext.getGraphNoTx(SecurityContext.PermissionMode.READER);
            Element element = Utility.getElementByUUID((Graph)orientGraphNoTx, (String)elementType, (UUID)uuid, clz);
            return (El)element;
        }
        finally {
            if (orientGraphNoTx != null) {
                orientGraphNoTx.shutdown();
            }
        }
    }

    public static <El extends Element> El getElementByUUID(Graph graph, String elementType, UUID uuid, Class<? extends El> clz) throws NotFoundException, ResourceRegistryException {
        String select;
        OSQLSynchQuery osqlSynchQuery;
        Iterable elements;
        if (elementType == null || elementType.compareTo("") == 0) {
            if (Vertex.class.isAssignableFrom(clz)) {
                elementType = "Entity";
            }
            if (Edge.class.isAssignableFrom(clz)) {
                elementType = "Relation";
            }
        }
        if ((elements = (Iterable)((OrientBaseGraph)graph).command((OCommandRequest)(osqlSynchQuery = new OSQLSynchQuery(select = "SELECT FROM " + elementType + " WHERE " + "header" + "." + "uuid" + " = \"" + uuid.toString() + "\""))).execute(new Object[0])) == null || !elements.iterator().hasNext()) {
            String error = String.format("No %s with UUID %s was found", elementType, uuid.toString());
            logger.info(error);
            throw new NotFoundException(error);
        }
        Iterator iterator = elements.iterator();
        Element element = (Element)iterator.next();
        logger.trace("{} with id {} is : {}", new Object[]{elementType, uuid.toString(), Utility.toJsonString((Element)element, (boolean)true)});
        if (iterator.hasNext()) {
            throw new ResourceRegistryException("Found more than one " + elementType + " with uuid " + uuid.toString() + ". This is a fatal error please contact Admnistrator");
        }
        return (El)element;
    }

    public static <P extends Property> P getPropertyDocument(Class<P> clz, Element element, String property) throws ResourceRegistryException {
        try {
            ODocument oDocument = (ODocument)element.getProperty(property);
            Property e = (Property)ISMapper.unmarshal(clz, (String)oDocument.toJSON());
            return (P)e;
        }
        catch (Exception ex) {
            String error = String.format("Error while getting %s from %s", property, Utility.toJsonString((Element)element, (boolean)true));
            throw new ResourceRegistryException(error, (Throwable)ex);
        }
    }

    public static UUID getUUID(Element element) throws ResourceRegistryException {
        Header header = HeaderUtility.getHeader((Element)element);
        return header.getUUID();
    }
}

