/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import com.tinkerpop.blueprints.Direction;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.common.gxhttp.reference.GXConnection;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.query.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.context.ContextManagement;
import org.gcube.informationsystem.resourceregistry.context.ContextUtility;
import org.gcube.informationsystem.resourceregistry.er.ERManagement;
import org.gcube.informationsystem.resourceregistry.er.ERManagementUtility;
import org.gcube.informationsystem.resourceregistry.er.entity.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.query.QueryImpl;
import org.gcube.informationsystem.resourceregistry.schema.SchemaManagementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="access")
public class Access {
    private static Logger logger = LoggerFactory.getLogger(Access.class);

    public static void setCalledMethod(GXConnection.HTTPMETHOD httpMethod, List<String> pathValues, Map<String, String> map) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.append(httpMethod.name());
        boolean first = true;
        for (String value : pathValues) {
            stringWriter.append(first ? " /" : "/");
            stringWriter.append(value);
        }
        first = true;
        if (map != null) {
            for (String key : map.keySet()) {
                stringWriter.append(first ? "?" : "&");
                stringWriter.append(key);
                stringWriter.append("=");
                stringWriter.append(map.get(key));
            }
        }
        CalledMethodProvider.instance.set(stringWriter.toString());
    }

    protected void setCalledMethodLocal(GXConnection.HTTPMETHOD httpMethod, String path) {
        this.setCalledMethodLocal(httpMethod, path, null);
    }

    protected void setCalledMethodLocal(GXConnection.HTTPMETHOD httpMethod, String path, Map<String, String> map) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(path);
        this.setCalledMethodLocal(httpMethod, list, map);
    }

    protected void setCalledMethodLocal(GXConnection.HTTPMETHOD httpMethod, List<String> pathValues) {
        this.setCalledMethodLocal(httpMethod, pathValues, null);
    }

    protected void setCalledMethodLocal(GXConnection.HTTPMETHOD httpMethod, List<String> pathValues, Map<String, String> map) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("access");
        list.addAll(pathValues);
        Access.setCalledMethod((GXConnection.HTTPMETHOD)httpMethod, list, map);
    }

    @GET
    @Path(value="contexts")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getAllContexts() throws ResourceRegistryException {
        logger.info("Requested to read all {}s", (Object)"Context");
        this.setCalledMethodLocal(GXConnection.HTTPMETHOD.GET, "contexts");
        ContextManagement contextManagement = new ContextManagement();
        return contextManagement.all(false);
    }

    @GET
    @Path(value="contexts/{UUID}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String getContext(@PathParam(value="UUID") String uuid) throws ContextNotFoundException, ResourceRegistryException {
        if (uuid.compareTo("CURRENT_CONTEXT") == 0) {
            uuid = ContextUtility.getCurrentSecurityContext().getUUID().toString();
        }
        logger.info("Requested to read {} with id {} ", (Object)"Context", (Object)uuid);
        ArrayList<String> pathValues = new ArrayList<String>();
        pathValues.add("contexts");
        pathValues.add(uuid);
        this.setCalledMethodLocal(GXConnection.HTTPMETHOD.GET, pathValues);
        ContextManagement contextManagement = new ContextManagement();
        contextManagement.setUUID(UUID.fromString(uuid));
        return contextManagement.read();
    }

    @GET
    @Path(value="types/{TYPE_NAME}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String getType(@PathParam(value="TYPE_NAME") String type, @QueryParam(value="polymorphic") @DefaultValue(value="false") Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        logger.info("Requested Schema for type {}", (Object)type);
        ArrayList<String> pathValues = new ArrayList<String>();
        pathValues.add("types");
        pathValues.add(type);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("polymorphic", polymorphic.toString());
        this.setCalledMethodLocal(GXConnection.HTTPMETHOD.GET, pathValues, map);
        SchemaManagementImpl schemaManagement = new SchemaManagementImpl();
        return schemaManagement.read(type, polymorphic.booleanValue());
    }

    @GET
    @Path(value="instances/{TYPE_NAME}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String getAllInstances(@PathParam(value="TYPE_NAME") String type, @QueryParam(value="polymorphic") @DefaultValue(value="true") Boolean polymorphic) throws NotFoundException, ResourceRegistryException {
        logger.info("Requested all {}instances of {}", (Object)(polymorphic != false ? "polymorphic " : ""), (Object)type);
        ArrayList<String> pathValues = new ArrayList<String>();
        pathValues.add("instances");
        pathValues.add(type);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("polymorphic", polymorphic.toString());
        this.setCalledMethodLocal(GXConnection.HTTPMETHOD.GET, pathValues, map);
        ERManagement erManagement = ERManagementUtility.getERManagement((String)type);
        return erManagement.all(polymorphic.booleanValue());
    }

    @HEAD
    @Path(value="instances/{TYPE_NAME}/{UUID}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response instanceExists(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String uuid) throws NotFoundException, ResourceRegistryException {
        logger.info("Requested to check if {} with id {} exists", (Object)type, (Object)uuid);
        ArrayList<String> pathValues = new ArrayList<String>();
        pathValues.add("instances");
        pathValues.add(type);
        pathValues.add("{UUID}");
        this.setCalledMethodLocal(GXConnection.HTTPMETHOD.HEAD, pathValues);
        ERManagement erManagement = ERManagementUtility.getERManagement((String)type);
        try {
            erManagement.setUUID(UUID.fromString(uuid));
            boolean found = erManagement.exists();
            if (found) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (AvailableInAnotherContextException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
    }

    @GET
    @Path(value="instances/{TYPE_NAME}/{UUID}")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String getInstance(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String uuid) throws NotFoundException, ResourceRegistryException {
        logger.info("Requested to read {} with id {}", (Object)type, (Object)uuid);
        ArrayList<String> pathValues = new ArrayList<String>();
        pathValues.add("instances");
        pathValues.add(type);
        pathValues.add("{UUID}");
        this.setCalledMethodLocal(GXConnection.HTTPMETHOD.GET, pathValues);
        ERManagement erManagement = ERManagementUtility.getERManagement((String)type);
        erManagement.setElementType(type);
        erManagement.setUUID(UUID.fromString(uuid));
        return erManagement.read();
    }

    @GET
    @Path(value="query")
    @Produces(value={"application/json;charset=UTF-8"})
    public String query(@QueryParam(value="q") String query, @QueryParam(value="limit") Integer limit, @QueryParam(value="fetchPlan") @DefaultValue(value="*:-1") String fetchPlan, @QueryParam(value="raw") @DefaultValue(value="false") Boolean raw) throws InvalidQueryException {
        logger.info("Requested query (fetch plan {}, limit : {}, Raw : raw):\n{}", new Object[]{fetchPlan, limit, query, raw});
        this.setCalledMethodLocal(GXConnection.HTTPMETHOD.GET, "query");
        QueryImpl queryManager = new QueryImpl();
        return queryManager.query(query, limit, fetchPlan, raw.booleanValue());
    }

    @GET
    @Path(value="query/{RESOURCE_TYPE_NAME}/{RELATION_TYPE_NAME}/{REFERENCE_TYPE_NAME}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String getAllResourcesHavingFacet(@PathParam(value="RESOURCE_TYPE_NAME") String resourcetype, @PathParam(value="RELATION_TYPE_NAME") String relationType, @PathParam(value="REFERENCE_TYPE_NAME") String referenceType, @QueryParam(value="reference") String reference, @QueryParam(value="polymorphic") @DefaultValue(value="false") Boolean polymorphic, @QueryParam(value="direction") @DefaultValue(value="out") String direction, @Context UriInfo uriInfo) throws ResourceRegistryException {
        logger.info("Requested {} instances having a(n) {} ({}={}} with {} ({}={})", new Object[]{resourcetype, relationType, "direction", direction, referenceType, "polymorphic", polymorphic});
        ArrayList<String> pathValues = new ArrayList<String>();
        pathValues.add("query");
        pathValues.add(resourcetype);
        pathValues.add(relationType);
        pathValues.add(referenceType);
        this.setCalledMethodLocal(GXConnection.HTTPMETHOD.GET, pathValues);
        ERManagement erManagement = ERManagementUtility.getERManagement((String)resourcetype);
        if (erManagement instanceof ResourceManagement) {
            String error;
            UUID refereceUUID = null;
            Direction directionEnum = Direction.OUT;
            HashMap<String, Object> constraint = new HashMap<String, Object>();
            MultivaluedMap multivaluedMap = uriInfo.getQueryParameters();
            for (String key : multivaluedMap.keySet()) {
                if (key.compareTo("polymorphic") == 0 || key.compareTo("gcube-token") == 0 || key.compareTo("gcube-scope") == 0) continue;
                constraint.put(key, multivaluedMap.getFirst((Object)key));
            }
            if (reference != null) {
                try {
                    refereceUUID = UUID.fromString(reference);
                }
                catch (Exception e) {
                    error = String.format("%s is not a valid %s", reference, UUID.class.getSimpleName());
                    throw new InvalidQueryException(error);
                }
            }
            try {
                directionEnum = Direction.valueOf((String)direction.toUpperCase());
            }
            catch (Exception e) {
                error = String.format("%s is not a valid. Allowed values are %s", direction, Direction.values());
                throw new InvalidQueryException(error);
            }
            return ((ResourceManagement)erManagement).query(relationType, referenceType, refereceUUID, directionEnum, polymorphic.booleanValue(), constraint);
        }
        String error = String.format("%s is not a %s type", resourcetype, "Resource");
        throw new InvalidQueryException(error);
    }
}

